/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "nickform.h"
#include "symbian_auto_ptr.h"
#include <contextcontacts.rsg>
#include <avkon.hrh>
#include <eikedwin.h>
#include <eiklabel.h>

CNickForm* CNickForm::NewL(CJabberData& Data, TInt ContactId, const TDesC& Title, phonebook_i* Book)
{
	CALLSTACKITEM_N(_CL("CNickForm"), _CL("NewL"));


	auto_ptr<CNickForm> self (
		new (ELeave) CNickForm(Data, ContactId, Book));
	self->ConstructL(Title);
	return self.release();
}

CNickForm::~CNickForm()
{
	CALLSTACKITEM_N(_CL("CNickForm"), _CL("~CNickForm"));


	delete iTitle;
}
CNickForm::CNickForm(CJabberData& Data, TInt ContactId, phonebook_i* Book) : 
	iData(Data), iContactId(ContactId), iBook(Book)
{
	CALLSTACKITEM_N(_CL("CNickForm"), _CL("CNickForm"));


}

void CNickForm::ConstructL(const TDesC& Title)
{
	CALLSTACKITEM_N(_CL("CNickForm"), _CL("ConstructL"));


	iTitle=Title.AllocL();
	iData.GetJabberNickL(iContactId, iNick);
	CAknForm::ConstructL();
}

TInt CNickForm::ExecuteLD()
{
	CALLSTACKITEM_N(_CL("CNickForm"), _CL("ExecuteLD"));


	return CAknForm::ExecuteLD(R_CB_NICK_DIALOG);
}
void CNickForm::PrepareLC()
{
	CALLSTACKITEM_N(_CL("CNickForm"), _CL("PrepareLC"));


	CAknForm::PrepareLC(R_CB_NICK_DIALOG);
}

TBool CNickForm::SaveFormDataL()
{
	CALLSTACKITEM_N(_CL("CNickForm"), _CL("SaveFormDataL"));


	GetEdwinText(iNick, 2);

	iData.SetJabberNickL(iContactId, iNick);

	if (iBook) iBook->ReRead();

	return true;
}

TBool CNickForm::OkToExitL( TInt aButtonId )
{
	CALLSTACKITEM_N(_CL("CNickForm"), _CL("OkToExitL"));


	if (aButtonId==EAknSoftkeyOk) {
		TRAPD(err, SaveFormDataL());
		if (err!=KErrNone) {
			//TODO: show error
		}
	}
	return true;
}

void CNickForm::DoNotSaveFormDataL()
{
	CALLSTACKITEM_N(_CL("CNickForm"), _CL("DoNotSaveFormDataL"));


}
void CNickForm::SetInitialCurrentLine()
{
	CALLSTACKITEM_N(_CL("CNickForm"), _CL("SetInitialCurrentLine"));


	ActivateFirstPageL();
	TryChangeFocusToL(2);
}

void CNickForm::PostLayoutDynInitL()
{
	CALLSTACKITEM_N(_CL("CNickForm"), _CL("PostLayoutDynInitL"));


	CEikEdwin* f=(CEikEdwin*)Control(2);
	f->SetTextL(&iNick);

	CEikEdwin* l=(CEikEdwin*)Control(1);
	l->SetTextL(&(*iTitle));

	CAknForm::PostLayoutDynInitL();
	// To Following line change the edit mode
	SetEditableL(ETrue);

	// The following line set to change status
	// This avoid back set form View status in the beginning 
	// Usually without change back do that, like when we start an empty Form.
	SetChangesPending(ETrue);

}

TBool CNickForm::QuerySaveChangesL()
{
	CALLSTACKITEM_N(_CL("CNickForm"), _CL("QuerySaveChangesL"));


	TBool isAnsYes(CAknForm::QuerySaveChangesL());
	
	if (isAnsYes)
        {
		SaveFormDataL();
        }
	else 
        {
		// Case that answer "No" to query.
		DoNotSaveFormDataL();
        }
	
	return isAnsYes;
}