#ifndef CONTEXT_CM_NETWORK_H_INCLUDED
#define CONTEXT_CM_NETWORK_H_INCLUDED 1

#include "cm_storage.h"

class MNetworkStatus {
public:
	enum TFetchStatus { EConnecting, EWaiting, EFetching, EFailed, EDone };

	// TInt64(0) means all threads
	virtual void FetchStatusChange(TInt64 aThreadId, TFetchStatus aStatus) = 0;
	virtual void Downloading(TBool aDownloading) = 0;
};

class CCMNetwork : public CBase {
public:
	IMPORT_C static CCMNetwork* NewL(CPostStorage* aStorage, MApp_context& aContext,
		const TDesC& aFetchUrl, TInt aFetchPeriod,
		 const TDesC& aDir, TInt aIapSetting);
	
	virtual void SetFetchUrl(const TDesC& aFetchUrl) = 0;
	virtual void SetFetchPeriod(TInt aSeconds) = 0;
	virtual void SetIap(TInt aIapSetting) = 0;

	virtual void FetchThread(TInt64 aThreadId) = 0;
	virtual void FetchMedia(const CCMPost* aPost, TBool force=EFalse) = 0;
	virtual void FetchThreads()=0;

	virtual void AddStatusListener(MNetworkStatus* aListener) = 0;
	virtual void RemoveStatusListener(MNetworkStatus* aListener) = 0;
	virtual MNetworkStatus::TFetchStatus GetFetchStatus(TInt64 aThreadId) = 0;
	virtual TBool GetDownloadingStatus() = 0;
};

#endif