#ifndef CONTEXT_POST_H_INCLUDED
#define CONTEXT_POST_H_INCLUDED 1

#include <bbdata.h>
#include <concretedata.h>
#include <context_uids.h>
#include <gulicon.h>
#include <csd_presence.h>
#include <symbian_refcounted_ptr.h>

const TTupleName KPostTuple = { { CONTEXT_UID_CONTEXTMEDIAFACTORY }, 1 };

const TTypeName KPostType = { { CONTEXT_UID_CONTEXTMEDIAFACTORY }, 1, 1, 0 };
const TTypeName KSenderType = { { CONTEXT_UID_CONTEXTMEDIAFACTORY }, 2, 1, 0 };

class MPostDeletionNotify {
public:
	virtual void PostDeleted(const class CCMPost* aPost) = 0;
};

class TCMSender : public TBBCompoundData {
public:
	TBBShortString		iName;
	TBBShortString		iPhoneNo;
	TBBShortString		iJabberNick;
	TBBBtDeviceInfo		iBt;
	TBBShortString		iImei;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C TCMSender& operator=(const TCMSender& aInfo);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
	const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TCMSender();
	IMPORT_C bool operator==(const TCMSender& aRhs) const;
	virtual const TDesC& StringSep(TUint aBeforePart) const;

};

class CCMPost : public CBase, public TBBCompoundData, public MRefCounted {
public:
	TBBInt64		iParentId;
	TBBInt64		iPostId;
	TCMSender		iSender;
	TBBLongString		iMediaUrl;
	CBBString*		iBodyText;
	TBBTime			iTimeStamp;
	TBBShortString		iProject; // aware project name

	TBBInt			iUnreadCounter;
	
	TBBLongString		iMediaFileName;
	TBBUint			iLocalDatabaseId;
	CBBString*		iTag;
	CBBGeneralHolder	iPresence;
	TBBLongString		iErrorDescr;
	TBBInt			iErrorCode;
	TBBLongString		iContentType;

	IMPORT_C TInt GetThumbnailIndex() const;
	IMPORT_C const TDesC& LastPostAuthor() const;
	IMPORT_C const TTime& LastPostDate() const;
	IMPORT_C void SetLastPostInfo(const TDesC& aAuthor, const TTime& aDateTime);

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C CCMPost& operator=(const CCMPost& aInfo);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
	const MBBData* Part(TUint aPartNo) const;
	IMPORT_C static CCMPost* NewL(MBBDataFactory* aBBFactory, TInt bodysize=-1, TInt tagsize=-1); // addrefs

	IMPORT_C ~CCMPost();
	IMPORT_C bool operator==(const CCMPost& aRhs) const;
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C void AddRef() const;
	IMPORT_C void Release() const;

	IMPORT_C TBool HasCrucialFields() const;
	IMPORT_C TBool HasMainFields() const;
private:
	
	MBBData* GetPart(const TDesC& aName, const TTypeName& aType, TUint& aPartNoInto);
	IMPORT_C CCMPost(MBBDataFactory* aBBFactory);
	IMPORT_C void ConstructL(TInt bodysize, TInt tagsize);
	mutable TUint iRefCount;

	friend class CPostStorageImpl;
	IMPORT_C void SetThumbNailIndex(TInt aIconIdx);
	IMPORT_C void SetDeletionNotify(MPostDeletionNotify* aDeletionNotify);
	TInt iIconIdx;
	TBuf<50>	iLastPostAuthor;
	TTime		iLastPostDate;
	MPostDeletionNotify* iDeletionNotify;
	MBBDataFactory* iBBFactory;
};

#endif
