#ifndef CONTEXT_STORAGE_H_INCLUDED
#define CONTEXT_STORAGE_H_INCLUDED 1

#include "cm_post.h"
#include <db.h>

// these are related to definitions in ::constructL
static const TInt KNoIconIndex=-1;
static const TInt KUnknownIconIndex=0;
static const TInt KPlaceholderIconIndex=0;
static const TInt KReplyIconIndex=1;
static const TInt KAudioIconIndex=2;
static const TInt KVideoIconIndex=3;
static const TInt KNewThreadIconIndex=4;
static const TInt KUseCodeIconIndex=5;
static const TInt KErrorIconIndex=6;

class MPostNotify {
public:
	enum TEvent {
		EMediaLoaded,
		EThumbnailLoaded,
		EUnreadChanged,
		EChildAdded,
		EErrorUpdated,
		EPlaceholderFilled,
		EPostUpdated,
		EPostHidden,
		EPostVisible,
		ELastPostChanged
	};
	virtual void PostEvent(CCMPost* aParent, CCMPost* aChild, TEvent aEvent) = 0;
	// aParent is NULL for subscriptions on the individual post
};

class CPostStorage : public CCheckedActive {
public:
	enum TSortBy {
		EByDate,
		EByAuthor,
		EByUnread,
		EByTitle,
		EByLastPost
	};
	enum TOrder {
		EAscending,
		EDescending
	};

	IMPORT_C static CPostStorage* NewL(MApp_context& Context, CDb& Db, MBBDataFactory* aBBFactory);

	virtual CArrayPtr<CGulIcon>* IconArray() = 0;

	// adding/modifying
	virtual void AddLocalL(CCMPost* aPost, auto_ptr<CFbsBitmap>& aIcon) = 0; 
		// takes ownership of icon 
		// you have to call SubscribeL manually after this, if keeping
		// the object, you can do that when getting the child addition event
	virtual void MarkAsRead(CCMPost* aPost) = 0;
	virtual void RemovePostL(const CCMPost * aPost)=0;

	virtual void AddPlaceHolderL(TInt64 aThreadId) = 0;
	virtual void AddNewThreadPlaceHolderL(TInt64 aThreadId) = 0;
	virtual void AddErrorPlaceHolderL(TInt64 aThreadId) = 0;
	virtual TBool IsPlaceHolderL(TInt64 aThreadId) = 0;

	virtual void UpdatePostL(CCMPost * aPost) = 0;
	virtual void UpdateFileName(TInt64 aPostId, const TDesC& aFileName, const TDesC& aContentType) = 0;
	virtual void UpdateIcon(TInt64 aPostId, auto_ptr<CFbsBitmap>& aIcon) = 0;
	virtual void UpdateError(TInt64 aPostId, TInt aErrorCode, const TDesC& aError) = 0;

	virtual void SetThreadVisibleL(TInt64 aPostId, TBool visible) = 0;
	virtual void SetAllThreadsVisibleL() = 0;
	virtual TInt HasHiddenThreads()=0;

	// iteration
	virtual TBool FirstL(const TInt64& aParentId, TSortBy aSortBy, TOrder aSortOrder, TBool aOnlyUnread, TBool aOnlyVisible=ETrue) = 0;
	virtual TBool NextL() = 0;
	virtual TUint GetCurrentIndexL() = 0;
	virtual TInt64 GetCurrentIdL() = 0;
	
	virtual TInt64 GetLastPostId(TInt64 aParentId) = 0;
	
	// accessing
	virtual CCMPost* GetCurrentL(MPostNotify* aNotify) = 0; // addrefs, sets up for notification
	virtual CCMPost* GetByIndexL(MPostNotify* aNotify, TUint aIdx) = 0; // addrefs, sets up for notification
	virtual CCMPost* GetByPostIdL(MPostNotify* aNotify, TInt64 aPostId) = 0; // addrefs, sets up for notification
	virtual void SubscribeL(CCMPost* aPost, MPostNotify* aNotify) = 0; // addrefs, sets up for notification
	virtual void Release(CCMPost* aPost, MPostNotify* aNotify) = 0; // releases
	virtual CCMPost* GetRootL(MPostNotify* aNotify) = 0; // sets up for notification 

	// Special PostId
	IMPORT_C static TInt64 RootId(); 
	IMPORT_C static TInt64 MediaPoolId(); // a thread that contains posts representing all media on the phone
	IMPORT_C static TInt64 AddMeToMediaPoolId();

protected:
	CPostStorage();
};

#endif
