#ifndef CONTEXT_CONVERTER_H_INCLUDED
#define CONTEXT_CONVERTER_H_INCLUDED 1

#include <app_context.h>
#include <db.h>
#include <downloader.h>
#include "fetch_request.h"
#include <fbs.h>

_LIT(KFbsImage, "image/fbs");

class MConvertingDownloadObserver : public MDownloadObserver
{
public:
	virtual void DownloadFinished(TInt64 aRequestId, const TDesC& aFileName,
		const TDesC& aContentType, auto_ptr<CFbsBitmap>& aIcon) = 0;
	virtual void ConverterDownloading(TBool aIsDownloading) = 0;
};


struct TConverterArgs {
	TFileName	iDir;
	TConverterArgs(): iDir(0){ }
};


// requires an RFbsSession to exist
class CConvertingDownloader : public CCheckedActive {
public:
	IMPORT_C static CConvertingDownloader* NewL(MApp_context& aContext, RDbDatabase& aDb, const TDesC& aDirectory, MConvertingDownloadObserver &aObserver);
	virtual void DownloadL(const CBBFetchMediaRequest * aReq) = 0;
	virtual void RemoveRequest(TInt64 aRequestId) = 0;
	//IMPORT_C static TInt RunConverterInThread(TAny* aPtr);

protected:
	CConvertingDownloader();
};

#endif
