#ifndef CONTEXT_FETCH_H_INCLUDED
#define CONTEXT_FETCH_H_INCLUDED 1

#include "cm_post.h"
#include <app_context.h>
#include <list.h>
#include "fetch_request.h"

class MPostReceiver {
public:
	// if aErrors==ETrue, the errors have been communicated
	// via Error() previously. The receiver must decide themselves
	// whether the post is complete enough to use
	virtual void NewPost(CCMPost* aPost, TBool aErrors) = 0; // may AddRef()
	virtual void Error(TInt aCode, const TDesC& aMsg) = 0;
	virtual void Finished() = 0;
};

class CFetchPosts : public CCheckedActive {
public:
	IMPORT_C static CFetchPosts* NewL(MApp_context& Context, MPostReceiver& aReceiver);
	virtual void FetchL(const CBBFetchPostRequest * aReq) = 0;
	virtual void Stop() = 0; // won't call Finished()
	CFetchPosts();

	//IMPORT_C static TInt RunFetcherInThread(TAny* aPtr);
};

#endif
