#include "cm_sendui.h"

#include <sendui.h>
#include "cm_post.h"
#include <txtrich.h>
#include "symbian_auto_ptr.h"
#include "raii_f32file.h"
#include "app_context_impl.h"

EXPORT_C void OpenPostInMessageEditorL(MApp_context& Context,
				       CSendAppUi& aSendUi,
				 const CCMPost& aPost,
				 TInt	aCommandId) 
{
	TUid mtm_uid=aSendUi.MtmForCommand(aCommandId) ;
	TSendingCapabilities cap=aSendUi.MtmCapabilitiesL(mtm_uid);
	auto_ptr<CRichText> body(0);
	auto_ptr<CParaFormatLayer> paraf(0);
	auto_ptr<CCharFormatLayer> charf(0);

	auto_ptr<CDesCArrayFlat> attach(new (ELeave) CDesCArrayFlat(2));
	TFileName body_filen;

	if (aPost.iMediaFileName().Length()>0) {
		attach->AppendL(aPost.iMediaFileName());
	}
	if (cap.iFlags & TSendingCapabilities::ESupportsBodyText) {
		paraf.reset(CParaFormatLayer::NewL());

		charf.reset(CCharFormatLayer::NewL());
		body.reset(CRichText::NewL(paraf.get(), charf.get()));

		body->InsertL(body->DocumentLength(), aPost.iBodyText->iPtr);
		body->InsertL(body->DocumentLength(), CEditableText::EParagraphDelimiter);
		body->InsertL(body->DocumentLength(), aPost.iSender.iName());
	} else {
		body_filen=Context.DataDir();
		body_filen.AppendNum( aPost.iPostId() );
		body_filen.Append(_L(".txt"));
		RAFile f;
		User::LeaveIfError(f.Replace(Context.Fs(), body_filen, EFileWrite|EFileShareAny));
		TPtr8 body( (TText8*)aPost.iBodyText->iPtr.Ptr(), aPost.iBodyText->iPtr.Length()*2);
		User::LeaveIfError(f.Write(body));
		attach->AppendL(body_filen);
	}

	aSendUi.CreateAndSendMessageL(aCommandId, body.get(), attach.get());
	Context.Fs().Delete(body_filen);
}
