#include "cm_post.h"
#include "fetch_request.h"

_LIT(KDefaultStringSep, " ");

class TConcreteDataFactory : public MBBDataFactory {
	virtual MBBData* CreateBBDataL(const TTypeName& aType, const TDesC& aName, MBBDataFactory* aTopLevelFactory) {
		if (aType==KPostType) {
			return CCMPost::NewL(aTopLevelFactory);
		} else if (aType==KFetchMediaRequestType) {
			return CBBFetchMediaRequest::NewL(0, 0, KNullDesC);
		} else if (aType==KFetchPostRequestType) {
			return CBBFetchPostRequest::NewL(0, KNullDesC);
		}
		return 0;
	}
	virtual ~TConcreteDataFactory() { }
	virtual void ConstructL() { }
};

EXPORT_C MBBDataFactory* CreateDataFactory()
{
	return new TConcreteDataFactory;
}
