#ifndef CONTEXTMEDIAAPPAPPUI_H
#define CONTEXTMEDIAAPPAPPUI_H

#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknviewappui.h>
#include <akntabgrp.h>
#include <aknnavide.h>
#include <akniconarray.h>

#include <phonehelper.h>
#include "contextmediaappview.h"
#include "contextmediaappview2.h"
#include <app_context.h>
#include <settingsview.h>
#include <recognizerview.h>
#include <cm_storage.h>
#include <cm_network.h>

#include <transferdir2.h>
#include <picture_publisher.h>
#include <status_notif.h>

#include "codeprompt.h"
#include "cm_oldprompt.h"
#include "popup_notifier.h"


class CContextMediaAppAppUi : public CAknViewAppUi, public MContextBase, public MRecognizerCallback, 
				public MSocketObserver, public i_status_notif,
				public MUploadPrompt, MUploadCallBack, public MBusyIndicator
{
	struct TCallBackItem {
		TFileName		iFileName;
		MUploadCallBack*	iCallBack;
		TCallBackItem() : iCallBack(0) { }
		TCallBackItem(const TDesC& aFileName, MUploadCallBack* aCallBack) :
			iFileName(aFileName), iCallBack(aCallBack) { }
	};

public: 
	CContextMediaAppAppUi(MApp_context& Context, 
		CPostStorage &aThreadStorage, CBBDataFactory * aFactory, 
		CCMNetwork &iCMNetwork);
        void ConstructL();
        ~CContextMediaAppAppUi();
private:
	void InnerConstructL();

public:
	void CodeSelected(const CCodeInfo& aCode);
	void CodeSelected(TInt64 id);
	void Cancelled();

public:
	virtual void ShowBusy(TBool aIsBusy);

private:
	void Prompt(const TDesC& FileName, MUploadCallBack* CallBack);
	TFileOpStatus Back(bool Upload, bool DeleteFromPhone, MBBData* Packet);
	void AddMediaPublisher(CPicturePublisher* aPublisher);
	void PublishOldMedia();

public:
	void SetTab(TInt tabId);

private:
	void success(CBase * source);
	void error(CBase *source,TInt code,const TDesC& aReason);
	void info(CBase * source, const TDesC &msg);

private:
	void finished() {}
	inline void error(const TDesC& ) {}
	inline void status_change(const TDesC& ) {}

private:
        void HandleCommandL(TInt aCommand);
	virtual TKeyResponse HandleKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
	void hide();

public:
	void GetVideoMbmPath(TFileName &aFilename);
	void GetAudioMbmPath(TFileName &aFilename);
	void GetUnknownMbmPath(TFileName &aFilename);
private:
	TFileName iVideoMbmPath;
	TFileName iAudioMbmPath;
	TFileName iUnknownMbmPath;

private:
        CAknNavigationControlContainer* iNaviPane;
        CAknNavigationDecorator*        iDecoratedTabGroup;
	CAknTabGroup*                   iTabGroup;

	CRecognizerView *		iVisualCodeView;
	CContextMediaAppThreadView *	iThreadsByLastPostView;
	CContextMediaAppThreadView *	iThreadsByAuthorView;
	CContextMediaAppThreadView *	iThreadsByTitleView;

	CContextMediaAppThreadView *    iThreadsByDatePrompt;

	CContextMediaAppThreadView *	iThreadView;
	CContextMediaAppThreadView *	iPostView;

	CContextMediaEditorView *	iEditorView;

	CSettingsView *			iSettingsView;

	CPostStorage &iThreadStorage;
	CCMNetwork &iCMNetwork;
	CBBDataFactory * iFactory;

	phonehelper * iPhoneHelper;

	CArrayPtrFlat<CPicturePublisher> *iMediaPublishers;
	CTransferDir * iTransferDir;

	CVisualCodePrompt *		iVisualPrompt;

	// -------
	CList<TCallBackItem> *iCallBacks;
	bool		iNext;       //??   
	MUploadCallBack* iCallBack;
	TFileName	iFileName;
	TBool		iUpload;
	TBool		iDelete;
	CCMPost		*iPacket;
	TUid		iCurrentPrompt;	

	TCMOldPrompt	*iOldPrompt;
	CAknGlobalNote * iNote;
	CPopupNotifier * iBusyNotifier;
public:
	TUid		iLastViewBeforePrompt;
	TVwsViewId	iNextView;
};

#endif

