#ifndef CONTEXTMEDIACONTAINER_H
#define CONTEXTMEDIACONTAINER_H

#include <coecntrl.h>
#include <aknlists.h> 
#include "cm_storage.h"
#include <akniconarray.h>
#include <aknview.h>
#include <eikrted.h>
#include <cm_network.h>
#include <PAlbImageViewerBasic.h>
#include "medialistbox.h"
#include "videoengine.h"
#include "audioengine.h"
#include <timeout.h>
#include <aknwaitdialog.h>
#include "reporting.h"
#include "app_context.h"

class OurOwnRichTextEditor : public CEikRichTextEditor
{
public:
	OurOwnRichTextEditor(HBufC * aDefaultValue): iDefaultValue(aDefaultValue) {}
	inline ~OurOwnRichTextEditor() {}
	void PrepareForFocusLossL();
	void PrepareForFocusGainL();
	void HandleTextChangedL();
	void Reset();
private:
	HBufC * iDefaultValue;
};


class CContextMediaAppGeneralContainer : public CCoeControl {
public: 
	CContextMediaAppGeneralContainer(CCMNetwork &aCMNetwork, CPostStorage &aStorage, TInt64 aNode, 
					CPostStorage::TSortBy aSort, CPostStorage::TOrder aOrder, CAknView * aView): 
				iStorage(aStorage), 
				iCMNetwork(aCMNetwork),
				iNode(aNode),
				iSort(aSort), 
				iOrder(aOrder),
				iView (aView){}
	virtual void ConstructL(const TRect& aRect)=0;
        virtual ~CContextMediaAppGeneralContainer();

public:
	virtual TInt get_current_idx()=0;
	virtual TInt get_top_idx()=0;
	virtual void set_current_idx(TInt idx)=0;
       	virtual void set_top_idx(TInt idx)=0;
	virtual TInt get_item_count()=0;

public:
	virtual CCMPost * get_current_post()=0;
	void mark_as_read();
	virtual TBool IsCurrentPlayableMedia()=0;

protected:
	CPostStorage &iStorage;
	CCMNetwork &iCMNetwork;
	TInt64 iNode;
	CPostStorage::TSortBy iSort;
	CPostStorage::TOrder iOrder;
	CAknView * iView;
};

class CContextMediaAppListboxContainer : public CContextMediaAppGeneralContainer, public MContextBase,
	public MEikListBoxObserver, public MPostNotify, public MTimeOut/*, public MBusyIndicator*/ {
public: 
	CContextMediaAppListboxContainer(CCMNetwork &aCMNetwork, CPostStorage &aStorage, TInt64 aNode, 
		CPostStorage::TSortBy aSort, CPostStorage::TOrder aOrder, CAknView * aView);
	void ConstructL(const TRect &aRect);
        ~CContextMediaAppListboxContainer();
private:
	void SizeChanged();
        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;
        void Draw(const TRect& aRect) const;
	TKeyResponse OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType);

private: 
	void HandleListBoxEventL(CEikListBox* aListBox,TListBoxEvent aEventType);
	virtual void PostEvent(CCMPost* aParent, CCMPost* aChild, TEvent aEvent);

private: 
	void expired(CBase * Source);

public:
	TInt get_current_idx();
	TInt get_top_idx();
	void set_current_idx(TInt idx);
       	void set_top_idx(TInt idx);
	TInt get_item_count();
	CCMPost * get_current_post();

private:
//	void SetupFreeBusyBitmaps();
//	virtual void ShowBusy(TBool aIsBusy);

public:
	TBool IsCurrentPlayableMedia();

private:
	CContextMediaBox * iListbox;
	CAknIconArray * iIconArray;
	CContextMediaArray * iMediaTextArray;

	CTimeOut * iTimer;
	
	HBufC * iNoTitleBuf;
	HBufC * iNoItemBuf;
	HBufC * iNoVisibleItemBuf;
	HBufC * iNewThreadBuf;
	
	//MBusyIndicator* iPreviousIndicator;
	
	//CFbsBitmap * iCPBitmapFree;
	//CFbsBitmap * iCPBitmapFreeMask;
	//CFbsBitmap * iCPBitmapBusy;
	//CFbsBitmap * iCPBitmapBusyMask;
	
	CEikLabel * iNoItemLabel;
};

class CContextMediaAppPostContainer : public CContextMediaAppGeneralContainer, public MPlayerUIControllerListener,
					public MContextBase, public MPostNotify, public MTimeOut
{
public: 
	CContextMediaAppPostContainer(CCMNetwork &aCMNetwork, CPostStorage &aStorage, TInt64 aNode, 
		CPostStorage::TSortBy aSort, CPostStorage::TOrder aOrder, CAknView * aView, 
		const TDesC& aFileName=KNullDesC, CBBDataFactory * aFactory=0);

	void ConstructL(const TRect &aRect);
        ~CContextMediaAppPostContainer();
private:
	void SizeChanged();
        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;
        void Draw(const TRect& aRect) const;
	TKeyResponse OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType);
	void RestoreOriginalCBAL();
	void DisplayPictureL();

public:
	TInt get_current_idx();
	TInt get_top_idx();
	void set_current_idx(TInt idx);
       	void set_top_idx(TInt idx);
	CCMPost * get_current_post();
	TInt get_item_count();
public:
	TBool IsCurrentPlayableMedia();
	void Play();
	void Pause();
	void Resume();
	void Stop();

private:
	void expired(CBase*source);

private: // PRIVATE MEDIA FUNCTIONS
	void PlayMediaFileL(const TDesC& aFilename);
	void PauseMediaFileL();
	void StopMediaFileL();
	void ResumeMediaFileL();

private: // video callbacks
	void InitControllerCompletedL(TInt aError);
        void PlayCompletedL(TInt aError);

private: // post callback
	void PostEvent(CCMPost* aParent, CCMPost* aChild, TEvent aEvent);

public: // Browsing related
	TBool has_next();
	TBool has_previous();   
	void display_next();
	void display_previous();
	void display_current();

private: // focus related
	void FocusPrevious();
	void FocusNext();

public:
	void save_contribution_to_post();
	TBool IsLoadingMedia();	

public:
	enum TMediaFileType {EUnknown, EImage, EAudio, EVideo};
	TMediaFileType iMediaFileType;

private: 
	TEikScrollBarModel iModel;
	CEikScrollBarFrame * iSBFrame;
	TInt iMaxScrollPos;
	TInt iCurrentScrollPos;

	CEikLabel * iLoadingLabel;
	OurOwnRichTextEditor * iComment;
	OurOwnRichTextEditor * iSignature;
	CEikLabel * iLeftArrow;
	CEikLabel * iLeftArrowBg;
	CEikLabel * iLeftArrowBlackBg;
	CEikLabel * iRightArrow;
	CEikLabel * iRightArrowBg;
	CEikLabel * iRightArrowBlackBg;
	CEikLabel * iTimeLabel;
	CEikLabel * iTimeLabelBg;
	CEikLabel * iTimeLabelBlackBg;
	CEikLabel * iCountLabel;
	CEikLabel * iCountLabelBg;
	CEikLabel * iCountLabelBlackBg;
	class CNotifyWindowControl* iNotifyControl;

	HBufC * iLoadingBuf;
	HBufC * iDownloadingBuf;
	HBufC * iDefaultSignatureBuf;
	HBufC * iDefaultCommentBuf;

	TBool iMediaReady;   // whether media is ready (to be displayed and/or played)
	TBool iLoadingMedia; // whether we're opening the media file for display
	TBool iPlayingMedia; // whether we currently are playing media
	TBool iMediaBrowsingOn; //in captured media mode, whether we can go left&right
	
	CPAlbImageViewerBasic * iMediaDisplay;

	CArrayFixFlat<TUint>* iPostArray;
	CCMPost	*iPost, *iParentPost;
	TInt iCurrentPostIndex;

	CVideoEngine * iVideoEngine;
	CAudioEngine * iAudioEngine;
	CTimeOut * iDisplayTimeOut;

	TFileName iFileName;

	CArrayPtrFlat< CCoeControl > * iControls;

	CBBDataFactory * iFactory;

};

#endif

