#ifndef CONTEXTMEDIAVIEW_H
#define CONTEXTMEDIAVIEW_H

#include <aknview.h>
#include <cm_storage.h>
#include <cpbkcontactengine.h>
#include "view_ids.h"
#include "phonehelper.h"
#include "contextmediaappcontainer.h"
#include <cm_network.h>
#include <transferdir2.h>
#include "codeprompt.h"

class CContextMediaAppThreadView : public CAknView, public MUploadPrompt
{
public: 
	CContextMediaAppThreadView(	TUid aViewId, TUid aNextViewId, CPostStorage &aStorage, 
					CPostStorage::TOrder aOrder, CPostStorage::TSortBy aSort,
					TInt64 aNode, TBool is_single_thread_view, TBool is_full_screen, 
					phonehelper &aPhoneHelper, CCMNetwork &aCMNetwork, 
					CVisualCodePrompt * aVisualPrompt
				   ) :  iViewId(aViewId), iNextViewId(aNextViewId), iStorage(aStorage), iCMNetwork(aCMNetwork), 
					iOrder(aOrder), iSort(aSort), 
					iNode(aNode), is_single_thread_view(is_single_thread_view), is_full_screen(is_full_screen), 
					iPhoneHelper(aPhoneHelper), iVisualPrompt(aVisualPrompt)  { }
	void ConstructL();
	~CContextMediaAppThreadView();
public:
	virtual void Prompt(const TDesC& FileName, MUploadCallBack* CallBack);
public:
	void SetNodeId(TInt64 aNode);
	TBool IsSingleThreadView();

public:
	void SetTopIndex(TInt idx);
	void SetCurrentIndex(TInt idx);

public: 
	TUid Id() const;
	void HandleCommandL(TInt aCommand);
	void HandleClientRectChange();
	void DynInitMenuPaneL(TInt aResourceId, CEikMenuPane* aMenuPane);

private:
	void DoActivateL(const TVwsViewId& aPrevViewId, TUid aCustomMessageId, const TDesC8& aCustomMessage);
	void DoDeactivate();

private:
	TBool IsKnownContact(const TDesC& phone_number);

private: 
	CContextMediaAppGeneralContainer* iContainer;
	TUid iViewId;
	TUid iNextViewId;
	TVwsViewId iPrevViewId;
		
	CPostStorage &iStorage;
	CCMNetwork &iCMNetwork;
	CPostStorage::TOrder iOrder;
	CPostStorage::TSortBy iSort;
	TInt64 iNode;

	TInt iTopIndex;
	TInt iCurrentIndex;

	CPbkContactEngine * iEngine;
	TBool owns_engine;

	TBool is_single_thread_view;
	TBool is_full_screen;

	phonehelper &iPhoneHelper;

	TBool iCameraAppFound;
	TBool iCameraApp2Found;
        TBool iVideoAppFound;
	TBool iVideoApp2Found;
	TBool iAudioAppFound;

	MUploadCallBack*	iCallBack;
	CVisualCodePrompt * iVisualPrompt;
};

#endif


