#ifndef CONTEXTMEDIAAPPVIEW2_H
#define CONTEXTMEDIAAPPVIEW2_H

#include <aknview.h>
#include <transferdir2.h>
#include <transfer2.h>
#include "contextmediaappcontainer.h"

class CContextMediaEditorView : public CAknView, public MContextBase, public MUploadPrompt
{
	struct TCallBackItem {
		TFileName		iFileName;
		MUploadCallBack*	iCallBack;
		TCallBackItem() : iCallBack(0) { }
		TCallBackItem(const TDesC& aFileName, MUploadCallBack* aCallBack) :
			iFileName(aFileName), iCallBack(aCallBack) { }
	};

public: 
	CContextMediaEditorView(TUid aViewId, TVwsViewId* NextViewId, MApp_context& Context, CCMNetwork &aCMNetwork, 
		CPostStorage &aStorage, CBBDataFactory * aFactory, CHttpTransfer2* aTransferer) 
		: MContextBase(Context), iViewId(aViewId), iCMNetwork(aCMNetwork), 
		  iStorage(aStorage), iFactory(aFactory), iNextViewId(NextViewId), iTransferer(aTransferer) {}
        void ConstructL();
        ~CContextMediaEditorView();

public:
	virtual void Prompt(const TDesC& FileName, MUploadCallBack* CallBack);

public: 
        TUid Id() const;
        void HandleCommandL(TInt aCommand);
        void HandleClientRectChange();
	void DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane);

private:
        void DoActivateL(const TVwsViewId& aPrevViewId,TUid aCustomMessageId, const TDesC8& aCustomMessage);
        void DoDeactivate();

public:
	void SetThreadTarget(TInt64 aCodeId);
	void ResetThreadTarget();

private: 
        CContextMediaAppPostContainer* iContainer;
	TUid iViewId;
	TVwsViewId iPrevViewId;
	TInt64 iThreadTarget;
	CCMNetwork &iCMNetwork;
	CPostStorage &iStorage;
	CBBDataFactory * iFactory;
	TBool iMediaBrowsingOn;

	// -------
	TVwsViewId*	iNextViewId;
	MUploadCallBack* iCallBack;
	TFileName	iFileName;
	//---------
	CHttpTransfer2* iTransferer;
	CPostStorage::TOrder iOrder;
	CPostStorage::TSortBy iSort;
	TInt64 iNode;

	class CSendAppUi * iSendUi;
};

#endif


