#ifndef CM_AUDIOENGINE_H_INCLUDED
#define CM_AUDIOENGINE_H_INCLUDED 1

#include <MdaAudioSamplePlayer.h>
#include "mplayeruicontrollerlistener.h"

class CAudioEngine: public CBase, public MMdaAudioPlayerCallback
{
public:
	static CAudioEngine* NewL();
	static CAudioEngine* NewLC();
	~CAudioEngine();

	void DoStopL();
	void DoPlayL();
	void SetNewFileL(const TDesC& aFileName);
	void DoPauseL();

	TInt IncreaseVolume();
	TInt DecreaseVolume();
   
	void MapcInitComplete(TInt aError, const TTimeIntervalMicroSeconds& aDuration);
	void MapcPlayComplete(TInt aError);

	void InitControllerL( MPlayerUIControllerListener* aCallback );
	void CloseController();
	TInt GetEngineState();
	enum TEngineState {EPNotInitialised, EPInitialising, EPStopped, EPPlaying, EPPaused};

private:
	CAudioEngine();
	void ConstructL();

private:
	
	TEngineState iEngineState;
	MPlayerUIControllerListener* iListener;
	CMdaAudioPlayerUtility* iMdaPlayer;
	HBufC*	iMediaFile;
};

#endif