#ifndef MEDIALISTBOX_H_INCLUDED
#define MEDIALISTBOX_H_INCLUDED

#include <cm_storage.h>
#include <cm_network.h>
#include <eikfrlb.h>

class CContextMediaArray : public CBase, public MDesCArray, public MPostNotify {
public:
	enum TAdditionalItem {ENone, EAddReply, EUseVCode};
public:
	static CContextMediaArray* NewL(CCMNetwork & aNetwork,
					CPostStorage &aStorage, 
					TInt64 aNode, 
					CPostStorage::TSortBy aSort, 
					CPostStorage::TOrder aOrder,
					MPostNotify& aObserver, TAdditionalItem aItem);
public:
	virtual CCMPost*  GetPostAt(TInt aIndex) = 0;
};



class CContextMediaBox : public CEikFormattedCellListBox
{
public:
	CContextMediaBox(CContextMediaArray * aPostArray) : CEikFormattedCellListBox(), iPostArray(aPostArray) {}
private:
	void CreateItemDrawerL(void);
public:
	virtual ~CContextMediaBox();
private:
	CContextMediaArray * iPostArray;
	CFont * iLatinPlainItalic12;
};


class CContextMediaBoxDrawer : public CFormattedCellListBoxItemDrawer 
{
public:
	CContextMediaBoxDrawer(MTextListBoxModel *aTextListBoxModel, 
			 const CFont *aFont, 
			 CFormattedCellListBoxData *aFormattedCellData, 
			 CContextMediaArray* aPostArray);

private:
	void DrawItemText (TInt aItemIndex, const TRect &aItemTextRect,TBool aItemIsCurrent, 
		TBool aViewIsEmphasized, TBool aItemIsSelected) const;
	
	CFormattedCellListBoxData *itemd;
	MTextListBoxModel * iTextListBoxModel;
	CContextMediaArray * iPostArray;
};




#endif