#ifndef __VIDEO_ENGINE_H__
#define __VIDEO_ENGINE_H__

#include <e32base.h>
#include <VideoPlayer.h>
#include "MPlayerUIControllerListener.h"

class CVideoFileDetails : public CBase
{
public:
        CVideoFileDetails();
        virtual ~CVideoFileDetails();

private:    
        HBufC* iTitle;
        HBufC* iFileName;
        HBufC* iUrl;
        HBufC* iFormat;
        HBufC* iCopyright;
        TInt   iResolutionWidth;
        TInt   iResolutionHeight;
        TInt   iBitrate;
        TInt   iSize;
        TTime  iTime;
        TInt64 iDurationInSeconds;
        TBool  iAudioTrack;
        TBool  iVideoTrack;
        
public:   
	friend class CVideoEngine;
};

enum TPlayerErrCode
	{
	KErrReOpen = 101,
	KErrAutoDisconnect,
	KErrAudioLost
	};


class CVideoEngine : public MVideoPlayerUtilityObserver, public MBeating, public CBase
{
public:
	static CVideoEngine* NewL();

private:
        CVideoEngine( );
	void ConstructL();

public:
	~CVideoEngine();

public:  
	void DoStopL();
	void DoPlayL();
	void SetNewFileL(const TDesC& aFileName);
	void DoPauseL();
	TInt GetEngineState();

	TInt IncreaseVolume();
	TInt DecreaseVolume();

        void InitControllerL( MPlayerUIControllerListener* aCallback,
                              RWsSession& aWs,
                              CWsScreenDevice& aScreenDevice,
                              RWindowBase& aWindow,
                              TRect& aScreenRect,
                              TRect& aClipRect);  
	void CloseController();
public: 
        void Beat();
        void Synchronize();
	enum TEngineState {EPNotInitialised, EPInitialising, EPStopped, EPPlaying, EPPaused};

public: 
        void MvpuoOpenComplete(TInt aError);
        void MvpuoPrepareComplete(TInt aError);
        void MvpuoFrameReady(CFbsBitmap& aFrame,TInt aError);
        void MvpuoPlayComplete(TInt aError);
        void MvpuoEvent(const TMMFEvent& aEvent);
	
private:
	CVideoPlayerUtility*	iPlayer;
	HBufC*	iMediaFile;
	CVideoFileDetails* iFileDetails;
	TEngineState iEngineState;
	MPlayerUIControllerListener* iListener;
	CHeartbeat* iProgressUpdater;  
	TInt64 iPlayPosition;
};

#endif // __VIDEO_ENGINE_H__