#include "ContextMediaAppAppUi.h"
#include "view_ids.h"
#include "symbian_auto_ptr.h"
#include "contextmediaapp.hrh"
#include "cm_post.h"
#include <contextmediaapp.rsg>
#include "cl_settings.h"
#include "local_defaults.h"
#include <aknnotewrappers.h> 
#include <flogger.h>
#include "app_context_impl.h"
#include "reporting.h"
#include <bautils.h>
#include "contextnotifyclientsession.h"

CContextMediaAppAppUi::CContextMediaAppAppUi(MApp_context& Context, 
		CPostStorage &aThreadStorage, CBBDataFactory * aFactory, 
		CCMNetwork &aCMNetwork) : 
	MContextBase(Context), iThreadStorage(aThreadStorage), iCMNetwork(aCMNetwork), iFactory(aFactory) { }

void CContextMediaAppAppUi::ConstructL()
{
#ifndef __WINS__
	{ TRAPD(errs, StartStarterL(_L("context_media_app"), KUidContextMediaApp, true)); }
#endif

	TRAPD(err, InnerConstructL());
	if (err!=KErrNone) {
		AppContext().ReportActiveError(_L(""),
			_L("UI Construct"), err);
	}
	User::LeaveIfError(err);
}

void CContextMediaAppAppUi::InnerConstructL()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("InnerConstructL"));

	{
		BaseConstructL();
	}

	CLocalNotifyWindow::CreateAndActivateL();

	iBusyNotifier = new (ELeave) CPopupNotifier;
	iBusyNotifier->ConstructL(TRect(TPoint(0,0), TSize(10,10)));

	Reporting().AddBusyIndicator(this);

	iNote = CAknGlobalNote::NewL();
	iCallBacks=CList<TCallBackItem>::NewL();
	iOldPrompt = new (ELeave) TCMOldPrompt(iThreadStorage, iCMNetwork);

	{
		iPhoneHelper = new (ELeave) phonehelper(0);
		iPhoneHelper->ConstructL();
	}

	{
		iTransferDir=CTransferDir::NewL(AppContext(), *this, _L("MEDIA_TRANSFER"));
	}

// TAB HANDLING
	{
		CEikStatusPane* sp = StatusPane();
		iNaviPane = (CAknNavigationControlContainer*)sp->ControlL(TUid::Uid(EEikStatusPaneUidNavi));
		iDecoratedTabGroup = iNaviPane->ResourceDecorator();
		if (iDecoratedTabGroup) {
			iTabGroup = (CAknTabGroup*) iDecoratedTabGroup->DecoratedControl();
		}
	}

// CREATING VIEWS
	{
		{
			iPostView = new (ELeave) CContextMediaAppThreadView(KPostViewId, KNullUid,
						iThreadStorage, CPostStorage::EDescending, CPostStorage::EByDate,
						CPostStorage::RootId(), ETrue, ETrue, *iPhoneHelper, iCMNetwork, 0);

			iPostView->ConstructL();
			AddViewL( iPostView );		// transfer ownership to CAknViewAppUi
		}


		{
			iThreadView = new (ELeave) CContextMediaAppThreadView(KThreadViewId, KPostViewId,
						iThreadStorage, CPostStorage::EDescending, CPostStorage::EByDate,
						CPostStorage::RootId(), ETrue, EFalse, *iPhoneHelper, iCMNetwork, 0);

			iThreadView->ConstructL();
			AddViewL( iThreadView );      // transfer ownership to CAknViewAppUi

		}

		{
			iThreadsByLastPostView = new (ELeave) CContextMediaAppThreadView(KThreadsByLastPostViewId, KThreadViewId,
						iThreadStorage, CPostStorage::EDescending, CPostStorage::EByLastPost,
						CPostStorage::RootId(), EFalse, EFalse, *iPhoneHelper, iCMNetwork, 0);
			iThreadsByLastPostView->ConstructL();
			AddViewL( iThreadsByLastPostView );      // transfer ownership to CAknViewAppUi

			iThreadsByAuthorView = new (ELeave) CContextMediaAppThreadView(KThreadsByAuthorViewId, KThreadViewId,
						iThreadStorage, CPostStorage::EAscending, CPostStorage::EByAuthor,
						CPostStorage::RootId(), EFalse, EFalse, *iPhoneHelper, iCMNetwork, 0);
			iThreadsByAuthorView->ConstructL();
			AddViewL( iThreadsByAuthorView );      // transfer ownership to CAknViewAppUi

			/*iThreadsByUnreadView = new (ELeave) CContextMediaAppThreadView(KThreadsByUnreadViewId, KThreadViewId,
						iThreadStorage, CPostStorage::EDescending, CPostStorage::EByUnread,
						CPostStorage::RootId(), EFalse, EFalse, *iPhoneHelper, iCMNetwork, 0);
			iThreadsByUnreadView->ConstructL();
			AddViewL( iThreadsByUnreadView );      // transfer ownership to CAknViewAppUi
*/
			iThreadsByTitleView = new (ELeave) CContextMediaAppThreadView(KThreadsByTitleViewId, KThreadViewId,
						iThreadStorage, CPostStorage::EAscending, CPostStorage::EByTitle,
						CPostStorage::RootId(), EFalse, EFalse, *iPhoneHelper, iCMNetwork, 0);
			iThreadsByTitleView->ConstructL();
			AddViewL( iThreadsByTitleView );      // transfer ownership to CAknViewAppUi
		}

		{
			iVisualCodeView = CRecognizerView::NewL(AppContext(),
				this, KVisualCodeViewId, 
				KThreadsByLastPostViewId, 0, R_VISUALCODE_VIEW);
			AddViewL(iVisualCodeView);
		}

		{
			iEditorView = new (ELeave) CContextMediaEditorView(KEditorViewId, &iNextView, AppContext(), iCMNetwork, iThreadStorage, iFactory, iTransferDir->Transferer());
			iEditorView->ConstructL();
			AddViewL( iEditorView );      // transfer ownership to CAknViewAppUi
		}

		{
			auto_ptr<CSettingsView> iSettingsView(CSettingsView::NewL(KSettingsViewId, AppContext(), TLocalAppSettings::GetEnabledSettingsArray()));
			AddViewL(iSettingsView.get());
			iSettingsView.release();
		}
			
		{
			SetDefaultViewL(*iVisualCodeView);
		}
	}

	{
		iVisualPrompt = CVisualCodePrompt::NewL(AppContext(),
			this, KVisualCodePromptId, 
			KThreadsByLastPostViewId, 0 /*&(iThreadsByLastPostView->iNextView)*/);

		iThreadsByDatePrompt = new (ELeave) CContextMediaAppThreadView(KThreadsByDatePromptId, KThreadViewId,
					iThreadStorage, CPostStorage::EDescending, CPostStorage::EByDate,
					CPostStorage::RootId(), EFalse, EFalse, *iPhoneHelper, iCMNetwork, iVisualPrompt);
		iThreadsByDatePrompt->ConstructL();
		AddViewL( iThreadsByDatePrompt );      // transfer ownership to CAknViewAppUi
	}

	{
		iMediaPublishers=new (ELeave) CArrayPtrFlat<CPicturePublisher>(10);

		AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\nokia\\images"),
			_L("*jpg"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CM, SETTING_VISUALCODES_URLBASE, SETTING_VISUALCODES_SCRIPT, *this, *iOldPrompt, iTransferDir));
		AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\images"),
			_L("*jpg"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CM, SETTING_VISUALCODES_URLBASE, SETTING_VISUALCODES_SCRIPT, *this, *iOldPrompt, iTransferDir));

		AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\nokia\\videos"),
			_L("*3gp"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CM, SETTING_VISUALCODES_URLBASE, SETTING_VISUALCODES_SCRIPT, *this, *iOldPrompt, iTransferDir));
		AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\videos"),
			_L("*3gp"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CM, SETTING_VISUALCODES_URLBASE, SETTING_VISUALCODES_SCRIPT, *this, *iOldPrompt, iTransferDir));

		AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\nokia\\Sounds\\digital"),
			_L("*amr"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CM, SETTING_VISUALCODES_URLBASE, SETTING_VISUALCODES_SCRIPT, *this, *iOldPrompt, iTransferDir, _L("*aac")));
		AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\Sounds\\digital"),
			_L("*amr"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CM, SETTING_VISUALCODES_URLBASE, SETTING_VISUALCODES_SCRIPT, *this, *iOldPrompt, iTransferDir, _L("*aac")));

		// n-gage
		AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\Record"),
			_L("*amr"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CM, SETTING_VISUALCODES_URLBASE, SETTING_VISUALCODES_SCRIPT, *this, *iOldPrompt, iTransferDir, _L("*aac")));
		
		AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\Sounds\\digital"),
			_L("*amr"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CM, SETTING_VISUALCODES_URLBASE, SETTING_VISUALCODES_SCRIPT, *this, *iOldPrompt, iTransferDir, _L("*aac")));	

		AddMediaPublisher(CPicturePublisher::NewL(AppContext(), *this, _L("?:\\system\\apps\\ContextNote"),
			_L("*txt"), SETTING_MEDIA_UPLOAD_ENABLE, MEDIA_PUBLISHER_CM, SETTING_VISUALCODES_URLBASE, SETTING_VISUALCODES_SCRIPT, *this, *iOldPrompt, iTransferDir));
	}
	PublishOldMedia();

#ifdef __WINS__
	_LIT(KMbmVideo, "z:\\system\\data\\contextmediaapp_video.mbm");
	_LIT(KMbmAudio, "z:\\system\\data\\contextmediaapp_audio.mbm");
	_LIT(KMbmUnknown, "z:\\system\\data\\contextmediaapp_unknown.mbm");
#else
	_LIT(KMbmVideo, "c:\\system\\data\\contextmediaapp_video.mbm");
	_LIT(KMbmAudio, "c:\\system\\data\\contextmediaapp_audio.mbm");
	_LIT(KMbmUnknown, "c:\\system\\data\\contextmediaapp_unknown.mbm");
#endif

	iVideoMbmPath=KMbmVideo();
	iAudioMbmPath=KMbmAudio();
	iUnknownMbmPath=KMbmUnknown();
	if (! BaflUtils::FileExists(Fs(), iVideoMbmPath))	iVideoMbmPath.Replace(0, 1, _L("e"));
	if (! BaflUtils::FileExists(Fs(), iAudioMbmPath))	iAudioMbmPath.Replace(0, 1, _L("e"));
	if (! BaflUtils::FileExists(Fs(), iUnknownMbmPath)) 	iUnknownMbmPath.Replace(0, 1, _L("e"));

	iLastViewBeforePrompt = KThreadsByLastPostViewId;
}

void CContextMediaAppAppUi::PublishOldMedia()
{
	if (iTransferDir && iTransferDir->Transferer()) {
		iTransferDir->Transferer()->Trigger();
	}
	if (iMediaPublishers) {
		for (int i=0; i< iMediaPublishers->Count(); i++) {
			iMediaPublishers->At(i)->PublishOld();
		}
	}
}

CContextMediaAppAppUi::~CContextMediaAppAppUi()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("~CContextMediaAppAppUi"));

	CLocalNotifyWindow::Destroy();

	Reporting().RemoveBusyIndicator(this);
	delete iBusyNotifier;
	delete iNote;
	delete iPacket;
	delete iDecoratedTabGroup;
	delete iPhoneHelper;
	if (iMediaPublishers) iMediaPublishers->ResetAndDestroy();
	delete iMediaPublishers;

	delete iOldPrompt;
	delete iVisualPrompt;
	delete iTransferDir;

	delete iCallBacks;
}

TKeyResponse CContextMediaAppAppUi::HandleKeyEventL(const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("HandleKeyEventL"));

	if ( iTabGroup == NULL || iView == NULL) {
		return EKeyWasNotConsumed;
	}
	if ( (iView->Id() == KPostViewId) || (iView->Id() == KThreadViewId) ) {
		return EKeyWasNotConsumed;
	}
	
	TInt active = iTabGroup->ActiveTabIndex();
	TInt count = iTabGroup->TabCount();

	switch ( aKeyEvent.iCode ) {
		case EKeyLeftArrow:
			if ( active > 0 ) {
				active--;
				iTabGroup->SetActiveTabByIndex( active );
				TInt i = iTabGroup->TabIdFromIndex(active);
				ActivateLocalViewL(TUid::Uid(i));
			}
			break;
		case EKeyRightArrow:
			if( (active + 1) < count ) {
				active++;
				iTabGroup->SetActiveTabByIndex( active );
				TInt i = iTabGroup->TabIdFromIndex(active);
				ActivateLocalViewL(TUid::Uid(i));
			}
			break;
		default:
			return EKeyWasNotConsumed;
			break;
	}
	return EKeyWasConsumed;
}

void CContextMediaAppAppUi::HandleCommandL(TInt aCommand)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("HandleCommandL"));

	switch ( aCommand ) {
		case EAknSoftkeyBack:
			hide();
			break;
		case EAknSoftkeyExit:
		case EAknCmdExit:
		case EEikCmdExit:{
			Exit();
			break;
		}
		case EcontextmediaappCmdSettings:
			ActivateLocalViewL(KSettingsViewId);
			break;
		default:
			break;      
	}
}

void CContextMediaAppAppUi::hide()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("hide"));


	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	
	TApaTask task(wsSession);
	TInt id = CEikonEnv::Static()->RootWin().Identifier();
	task.SetWgId(id);
		
	if ( wsSession.GetFocusWindowGroup() == id ) {
		task.SendToBackground();
	}
}

void CContextMediaAppAppUi::SetTab(TInt tabId)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("SetTab"));


	TInt idx = iTabGroup->TabIndexFromId(tabId);

	if (idx != KErrNotFound) iTabGroup->SetActiveTabByIndex(idx);

}

void CContextMediaAppAppUi::CodeSelected(const CCodeInfo& aCode)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("CodeSelected"));

	TInt64 id = aCode.code->ToInt64();
	CodeSelected(id);
}

void CContextMediaAppAppUi::CodeSelected(TInt64 id)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("CodeSelected"));

	CCMPost * aPost = 0;
	TBool activate_by_last_view=EFalse;

	TRAPD(err, aPost=iThreadStorage.GetByPostIdL(0, id));
        if (err!=KErrNotFound) User::LeaveIfError(err);

        if (!aPost ) {
		// we haven't seen this code before
		TRAPD(err, iCMNetwork.FetchThread(id));
		if (err!=KErrNone) {
			_LIT(KErrorText, "Incorrect IAP, Check connection settings.");
			CAknErrorNote* note = new(ELeave) CAknErrorNote;
			note->ExecuteLD(KErrorText());
		} else {
			activate_by_last_view=ETrue;
		}
	} else {
		// we have seen this code before, refresh
		iCMNetwork.FetchThread(id);
		iThreadStorage.SetThreadVisibleL(id, ETrue);
		TBool is_placeholder=EFalse;
		TRAPD(err, is_placeholder=iThreadStorage.IsPlaceHolderL(aPost->iPostId()));
		if (is_placeholder) {
			// display all threads
			activate_by_last_view=ETrue;
			
		} else {
			//display the target thread
			iThreadView->SetNodeId(id);
			ActivateLocalViewL(KThreadViewId);
		}
		iThreadStorage.Release(aPost, 0);
	}

	if (!activate_by_last_view) return;

	// set current index in view to the item representing thread id
	TInt i=-1;
	TBool ok = iThreadStorage.FirstL(CPostStorage::RootId(), CPostStorage::EByLastPost, CPostStorage::EDescending, EFalse);
	while (ok) {
		i++;
		if (iThreadStorage.GetCurrentIdL() == id) {
			ok=EFalse;
		} else {
			ok=iThreadStorage.NextL();
		}
	}
        
	TInt top = i-3;
	if (top<0) top=0;
	iThreadsByLastPostView->SetTopIndex(top);
	iThreadsByLastPostView->SetCurrentIndex(i);
	ActivateLocalViewL(KThreadsByLastPostViewId);
}

void CContextMediaAppAppUi::Cancelled()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("Cancelled"));

	// from visual code, no implementation 
}

void CContextMediaAppAppUi::AddMediaPublisher(CPicturePublisher* aPublisher)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("AddMediaPublisher"));

	auto_ptr<CPicturePublisher> p(aPublisher);
	iMediaPublishers->AppendL(aPublisher);
	p.release();
}

void CContextMediaAppAppUi::success(CBase * /*source*/)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("success"));
}

void CContextMediaAppAppUi::error(CBase * /*source*/,TInt /*code*/,const TDesC& /*aReason*/)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("error"));
}

void CContextMediaAppAppUi::info(CBase * /*source*/, const TDesC &msg)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("info"));

	if (msg.Compare(_L("all files transfered"))==0) {
		iCMNetwork.FetchThreads();
	}
}

void CContextMediaAppAppUi::Prompt(const TDesC& FileName, MUploadCallBack* CallBack)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("Prompt"));

	TBuf<200> msg=_L("AppUi:Prompt ");
	msg.Append(FileName.Left(150));
	Reporting().DebugLog(msg);

	if (!CallBack) User::Leave(KErrArgument);
	
	if (!iCallBack) {
		iNextView=TVwsViewId();
		iFileName=FileName;
		iCallBack=CallBack;
		iCurrentPrompt = KEditorViewId;
		iEditorView->Prompt(iFileName, this);
	} else {
		iCallBacks->AppendL(TCallBackItem(FileName, CallBack));
	}
}

TFileOpStatus CContextMediaAppAppUi::Back(bool Upload, bool DeleteFromPhone, MBBData* Packet)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppAppUi"), _CL("Back"));
	Reporting().DebugLog(_L("AppUi:Back"));

	TFileOpStatus ret;
	iNext=false;
	TBool done = EFalse;

	if (Packet == 0) return ret;

	if (iCurrentPrompt == KEditorViewId) {
		//save param for later 
		iUpload=Upload;
		iDelete=DeleteFromPhone;
		delete iPacket; iPacket=0;
		iPacket=bb_cast<CCMPost>(Packet->CloneL(KNullDesC));

		if (iUpload) {
			/* parent not already known -> need vc*/
			if (iPacket->iParentId() == CPostStorage::MediaPoolId()) {
				iCurrentPrompt=KThreadsByDatePromptId/*KVisualCodeViewId*/;
				iThreadsByDatePrompt->Prompt(KNullDesC, this);
				return ret;
			} else {
				/* parent already known -> let's upload*/
				if (iDelete) { /* Remove traces from strorage */
					iThreadStorage.RemovePostL(iPacket);
				}
				ret = iCallBack->Back(iUpload, iDelete, iPacket);
				done = ETrue;
			}
		} else {
			ret = iCallBack->Back(iUpload, iDelete, iPacket);
			done = ETrue;
		}
	} else if (iCurrentPrompt == KThreadsByDatePromptId/*KVisualCodeViewId*/) {
		if (Upload) {
			CCMPost * aPost = bb_cast<CCMPost>(Packet);
			iPacket->iParentId()=aPost->iParentId();

			iCMNetwork.FetchThread(aPost->iParentId());

			if (iDelete) iThreadStorage.MarkAsRead(iPacket);
			ret = iCallBack->Back(iUpload, iDelete, iPacket);

		} else {
			ret = iCallBack->Back(Upload, DeleteFromPhone, iPacket);
		}
		done = ETrue;
	} else {
		//FIXME:Report Error ?
	}

	// update iMediaUrl for current Packet and also corresponding Post in Storage
	if (done && (ret.err == KErrNone) ) {
		if (iPacket) {
			iPacket->iMediaUrl() = ret.fn;
			iPacket->iMediaFileName() = ret.fn;
			TRAPD(ignore, iThreadStorage.UpdatePostL(iPacket));
		}
	}

	if (done && Upload) {
		iNote->ShowNoteL (EAknGlobalConfirmationNote, _L("Queued for Publishing"));
	}

	Reporting().DebugLog(_L("Back:reset"));
	iCallBack=0;
	iCurrentPrompt=KNullUid;

	if (iCallBacks->iCount > 0) {
		Reporting().DebugLog(_L("Back:more"));
		TCallBackItem i=iCallBacks->Pop();
		Prompt(i.iFileName, i.iCallBack);
		return ret;
	}
	Reporting().DebugLog(_L("Back:activatethreadview"));
	ActivateLocalViewL(iLastViewBeforePrompt);
	return ret;
}

void CContextMediaAppAppUi::GetVideoMbmPath(TFileName &aFilename)
{
	aFilename.Copy(iVideoMbmPath);
}

void CContextMediaAppAppUi::GetAudioMbmPath(TFileName &aFilename)
{
	aFilename.Copy(iAudioMbmPath);
}

void CContextMediaAppAppUi::GetUnknownMbmPath(TFileName &aFilename)
{
	aFilename.Copy(iUnknownMbmPath);
}

void CContextMediaAppAppUi::ShowBusy(TBool aIsBusy)
{
	RWsSession& wsSession=CEikonEnv::Static()->WsSession();
	TInt id = CEikonEnv::Static()->RootWin().Identifier();
	TApaTask task(wsSession);
	task.SetWgId(id);
	if ( wsSession.GetFocusWindowGroup() != id ) return;

	CEikStatusPane* sp=CEikonEnv::Static()->AppUiFactory()->StatusPane();
	if (sp->IsVisible()) {
		// non-full screen view
		iBusyNotifier->SetPosition(TPoint(38,7));
	} else {
		// full screen view
		iBusyNotifier->SetPosition(TPoint(165,1));
	}
	iBusyNotifier->MakeVisible(aIsBusy);
	iBusyNotifier->DrawNow();
}
