#include "ContextMediaAppContainer.h"
#include <akntitle.h>
#include <aknnavi.h>
#include "ContextMediaAppView2.h"
#include "ContextMediaAppView.h"
#include <aknviewappui.h> 
#include "contextmediaapp.hrh"
#include <contextmediaapp.rsg>
#include <txtrich.h>
#include "cm_post.h"
#include "cl_settings.h"
#include <avkon.rsg>
#include <aknnotewrappers.h>
#include <eiksbfrm.h>
#include <akncontext.h>
#include <contextmediaapp.mbg>
#include <bautils.h>
#include "contextmediaappappui.h"
#include <plpvariant.h>
#include "Contextnotifyclientsession.h"

// Some display constants

#define KTextColor TRgb(0,0,0)
#define KFocusedBgColor TRgb(205,205,255)
#define KUnfocusedBgColor TRgb(255, 255, 255)
#define KTagsBgColor TRgb(255, 255, 255)

#define KPictureSize TSize(174,131)
#define KVideoSize   TSize(174,139)

#define KPictureRectangle TRect(TPoint(1,5), KPictureSize)
#define KVideoRectangle TRect(TPoint(1,1), KVideoSize)


void GetIMEI(TDes& aInto)
{
#ifndef __WINS__
	TPlpVariantMachineId machineId;
	PlpVariant::GetMachineIdL(machineId);
	aInto=machineId;
#else
	// Return a fake IMEI when working on emulator
	_LIT(KEmulatorImsi, "244050000000000");
	aInto=KEmulatorImsi;
#endif
}

void CopyFbsBitmapL(CFbsBitmap * orig, CFbsBitmap * dest)
{
	TSize s = orig->SizeInPixels();
	User::LeaveIfError(dest->Create(s, orig->DisplayMode()));

	TBitmapUtil orig_util(orig);
	TBitmapUtil dest_util(dest);
	orig_util.Begin(TPoint(0,0)); 
	dest_util.Begin(TPoint(0,0), orig_util); 

	TInt xPos;
	for (TInt yPos=0;yPos<s.iHeight;yPos++) {
		orig_util.SetPos(TPoint(0,yPos));
		dest_util.SetPos(TPoint(0,yPos));
		for (xPos=0;xPos<s.iWidth;xPos++) {
			dest_util.SetPixel(orig_util);
			orig_util.IncXPos();
			dest_util.IncXPos();
		}
	}
	orig_util.End();
	dest_util.End();
}

void AddBusyToBitmap(CFbsBitmap * bitmap)
{
	TRgb target_colour=KRgbRed;
	if (bitmap->DisplayMode() == EGray2) {
		target_colour=KRgbBlack;
	}

	TDisplayMode m = bitmap->DisplayMode();
	if (m>=EColor4K) m=EColor256;
	auto_ptr<CPalette> p (CPalette::NewDefaultL(m));
	TInt colour_idx = p->NearestIndex(KRgbRed);

	TBitmapUtil util(bitmap);
	util.Begin(TPoint(0,0));
	TInt xPos,yPos;
	for (yPos=5; yPos<20; yPos++) {
		for (xPos=5; xPos<20; xPos++) {
			util.SetPos(TPoint(xPos,yPos));
			util.SetPixel(colour_idx);
			util.IncXPos();
		}
	}
	util.End();
}

//-------------------------------------------------------------------------------------

CContextMediaAppGeneralContainer::~CContextMediaAppGeneralContainer()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppGeneralContainer"), _CL("~CContextMediaAppGeneralContainer"));
}

CContextMediaAppListboxContainer::CContextMediaAppListboxContainer(CCMNetwork &aCMNetwork, CPostStorage &aStorage, TInt64 aNode, 
				 CPostStorage::TSortBy aSort, CPostStorage::TOrder aOrder, CAknView * aView) : 
				CContextMediaAppGeneralContainer(aCMNetwork, aStorage, aNode, aSort, aOrder, aView)
{
	CALLSTACKITEM_N(_CL("CPostStorage"), _CL("TSortBy"));

}

TBool CContextMediaAppListboxContainer::IsCurrentPlayableMedia()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("IsCurrentPlayableMedia"));

	return EFalse;
}

void CContextMediaAppListboxContainer::expired(CBase * /*Source*/)
{
	if (iListbox) {
		iListbox->HandleItemAdditionL();
		iListbox->DrawNow();
	}
}

void CContextMediaAppListboxContainer::ConstructL(const TRect& aRect)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("ConstructL"));

	CreateWindowL();

	iTimer = CTimeOut::NewL(*this);

	// Bufs from resource
	iNoTitleBuf = CEikonEnv::Static()->AllocReadResourceL(R_NO_TITLE);
	iNoItemBuf = CEikonEnv::Static()->AllocReadResourceL(R_NO_ITEM);
	iNoVisibleItemBuf = CEikonEnv::Static()->AllocReadResourceL(R_NO_ITEM_VISIBLE);
	iNewThreadBuf = CEikonEnv::Static()->AllocReadResourceL(R_NEW_THREAD);
        
	// Create array and necessary additions
	CContextMediaArray::TAdditionalItem aItem = CContextMediaArray::ENone;
	if (iView->Id()==KThreadViewId) {
		aItem = CContextMediaArray::EAddReply;
	} else if (iView->Id()==KThreadsByDatePromptId){
		aItem = CContextMediaArray::EUseVCode;
	}
	iMediaTextArray = CContextMediaArray::NewL(iCMNetwork, iStorage, iNode, iSort, iOrder, *this, aItem);

	// CREATE A NEW TITLE PANEL IF NECESSARY
	CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
	CAknNavigationControlContainer *np = (CAknNavigationControlContainer *)sp->ControlL(TUid::Uid(EEikStatusPaneUidNavi)); 
	CAknTitlePane* tp=CLocalNotifyWindow::Global();
	CAknContextPane *cp =(CAknContextPane*)sp->ControlL(TUid::Uid(EEikStatusPaneUidContext));

	if (iView->Id()==KThreadsByDatePromptId) {
		np->PushDefaultL();	
		HBufC * t = iEikonEnv->AllocReadResourceL(R_SELECT_THREAD);
		tp->SetText(t);
	} else if (iNode != CPostStorage::RootId()) {
		np->PushDefaultL();
		TInt count = ((MDesCArray*)iMediaTextArray)->MdcaCount();
		CCMPost * aPost =0;
		if (count) aPost = iMediaTextArray->GetPostAt(count-1);
		//FIXME!
		if (0) {
		if (aPost) {
			if (aPost->iBodyText->Value().Length()==0) {
				tp->SetText((*iNoTitleBuf).AllocL());
			} else {
				tp->SetText(aPost->iBodyText->Value().AllocL());
			}
			CGulIcon * icon = iStorage.IconArray()->At(aPost->GetThumbnailIndex());
			CFbsBitmap * aBitmap = new (ELeave) CFbsBitmap;
			aBitmap->Duplicate(icon->Bitmap()->Handle());
			cp->SetPicture(aBitmap);
		} else {
			CGulIcon * icon = iStorage.IconArray()->At(4); // FIXME: dirty
			CFbsBitmap * aBitmap = new (ELeave) CFbsBitmap;
			aBitmap->Duplicate(icon->Bitmap()->Handle());
			cp->SetPicture(aBitmap);
			tp->SetText((*iNewThreadBuf).AllocL());
		}
		}
	} else {
		cp->SetPictureToDefaultL();
		HBufC * t = iEikonEnv->AllocReadResourceL(R_TITLE);
		tp->SetText(t);
	}
	
	iListbox = new (ELeave) CContextMediaBox(iMediaTextArray);
	iListbox->SetContainerWindowL(*this);
	iListbox->ConstructL(this, EAknListBoxSelectionList|EAknListBoxLoopScrolling );
	iListbox->View()->SetMatcherCursor(EFalse);
	iListbox->ItemDrawer()->FormattedCellData()->SetIconArray(iStorage.IconArray());
	iListbox->Model()->SetItemTextArray(iMediaTextArray);
	iListbox->SetItemHeightL(48);
	iListbox->Model()->SetOwnershipType(ELbmDoesNotOwnItemArray);
	iListbox->SetListBoxObserver(this);
	iListbox->CreateScrollBarFrameL(ETrue);
	iListbox->ScrollBarFrame()->SetScrollBarVisibilityL( CEikScrollBarFrame::EOff, CEikScrollBarFrame::EAuto);

	iNoItemLabel = new (ELeave) CEikLabel;
	iNoItemLabel->SetPosition(TPoint(20,20));
	
	SetRect(aRect);
	ActivateL();
}


void CContextMediaAppListboxContainer::PostEvent(CCMPost* /*aParent*/, CCMPost* aChild, TEvent aEvent)
{
	if (aEvent==EChildAdded) {
		TInt count = iMediaTextArray->MdcaCount();
		if ((iView->Id()==KThreadViewId) && (aChild==iMediaTextArray->GetPostAt(count-1))) {
			CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
			CAknTitlePane* tp=CLocalNotifyWindow::Global();;
			if (aChild->iBodyText->Value().Length()==0) {
				tp->SetText((*iNoTitleBuf).AllocL());
			} else {
				tp->SetText(aChild->iBodyText->Value().AllocL());
			}
			iListbox->HandleItemAdditionL();
			iListbox->DrawNow();
		} else {
			iTimer->Wait(1);
		}		
	} else if ((aEvent==EPostVisible) || (aEvent==EPostUpdated) || (aEvent==ELastPostChanged)) {
		iTimer->Wait(1);
	} else if (aEvent==EThumbnailLoaded ) {
		TInt count = iMediaTextArray->MdcaCount();
		if ((iView->Id()==KThreadViewId) && (aChild==iMediaTextArray->GetPostAt(count-1))) {
			//change current status pane bitmap
			CGulIcon * icon = iStorage.IconArray()->At(aChild->GetThumbnailIndex());
			CFbsBitmap * aBitmap = new (ELeave) CFbsBitmap;
			aBitmap->Duplicate(icon->Bitmap()->Handle());
			CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
			CAknContextPane *cp =(CAknContextPane*)sp->ControlL(TUid::Uid(EEikStatusPaneUidContext));
			cp->SetPicture(aBitmap);
			// reset busy/free icons
			//SetupFreeBusyBitmaps();
			cp->DrawNow();
		} 
		iListbox->DrawNow();
	} else {
		iListbox->DrawDeferred();
	}
}


CContextMediaAppListboxContainer::~CContextMediaAppListboxContainer()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("~CContextMediaAppListboxContainer"));
	
	iTimer->Reset();
	delete iTimer;
	//Reporting().RemoveBusyIndicator(this);

	if (iView->Id()==KThreadsByDatePromptId) {
		CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
		CAknNavigationControlContainer *np = (CAknNavigationControlContainer *)sp->ControlL(TUid::Uid(EEikStatusPaneUidNavi)); 
		np->Pop(NULL);	
	} else if (iNode != CPostStorage::RootId()) {
		CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
		CAknContextPane *cp =(CAknContextPane*)sp->ControlL(TUid::Uid(EEikStatusPaneUidContext));
		CAknNavigationControlContainer* np = (CAknNavigationControlContainer *)sp->ControlL(TUid::Uid(EEikStatusPaneUidNavi));
		np->Pop(NULL);
		cp->SetPictureToDefaultL();
	}
	iListbox->MakeVisible(EFalse);
	iListbox->ItemDrawer()->FormattedCellData()->SetIconArray(0);
	
	delete iListbox;
	delete iNoItemLabel;

	delete iMediaTextArray;
	
	delete iNoTitleBuf;
	delete iNoItemBuf;
	delete iNoVisibleItemBuf;
	delete iNewThreadBuf;
}

void CContextMediaAppListboxContainer::SizeChanged()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("SizeChanged"));

	if (iListbox) iListbox->SetRect(Rect());
}

TInt CContextMediaAppListboxContainer::CountComponentControls() const
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("CountComponentControls"));

	return 2; 
}

CCoeControl* CContextMediaAppListboxContainer::ComponentControl(TInt aIndex) const
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("ComponentControl"));

	switch ( aIndex ) {
		case 0:	 return iListbox;
		case 1:  return iNoItemLabel;
		default: return NULL;
        }
}

void CContextMediaAppListboxContainer::Draw(const TRect& aRect) const
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("Draw"));

	// handling visibility of listbox and default empty text
	if (iListbox->Model()->NumberOfItems() == 0) {
		if (iStorage.HasHiddenThreads()) {
			iNoItemLabel->SetTextL(*iNoVisibleItemBuf);
		} else {
			iNoItemLabel->SetTextL(*iNoItemBuf);
		}
		iNoItemLabel->SetSize(iNoItemLabel->MinimumSize());
		iNoItemLabel->SetPosition(TPoint( (176-iNoItemLabel->MinimumSize().iWidth)/2, 50));
	} else {
		iNoItemLabel->SetSize(TSize(0,0));
	}

	CWindowGc& gc = SystemGc();
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbWhite);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);
}

/*
void CContextMediaAppListboxContainer::ShowBusy(TBool aIsBusy)
{
	if (iView->Id()==KPostViewId) {
		if (aIsBusy) {
			ActivateGc();
			TPoint p(Rect().Width()-20, 20);
			TSize s(20, 20);
			TRect r( p, s);
			CWindowGc& gc = SystemGc();
			gc.SetPenStyle(CGraphicsContext::ENullPen);
			gc.SetBrushColor(KRgbRed);
			gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
			gc.DrawRect(r);
			iEikonEnv->Flush();
			DeactivateGc();
		} else {
			DrawNow();
		}
	} else {
		CEikStatusPane* sp=iEikonEnv->AppUiFactory()->StatusPane();
		CAknContextPane *cp =(CAknContextPane*)sp->ControlL(TUid::Uid(EEikStatusPaneUidContext));
		if (aIsBusy) {
			CFbsBitmap * b = new (ELeave) CFbsBitmap;
			b->Duplicate(iCPBitmapBusy->Handle());
			CFbsBitmap * m = 0;
			if (iCPBitmapBusyMask) {
				m = new (ELeave) CFbsBitmap;
				m->Duplicate(iCPBitmapBusyMask->Handle());
			}
			cp->SetPicture(b, m);
			cp->DrawNow();
		} else {
			CFbsBitmap * b = new (ELeave) CFbsBitmap;
			b->Duplicate(iCPBitmapFree->Handle());
			CFbsBitmap * m = 0;
			if (iCPBitmapFreeMask) {
				m = new (ELeave) CFbsBitmap;
				m->Duplicate(iCPBitmapFreeMask->Handle());
			}
			cp->SetPicture(b, m);
			cp->DrawNow();
		}
	}
}
*/

void CContextMediaAppListboxContainer::HandleListBoxEventL(CEikListBox* aListBox, TListBoxEvent aEventType)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("HandleListBoxEventL"));

	if(aListBox == iListbox) {
		switch(aEventType) {
			case EEventEnterKeyPressed: {
				if (get_current_post()) {
					TBool is_placeholder=EFalse;
					TRAPD(err, is_placeholder=iStorage.IsPlaceHolderL(get_current_post()->iPostId()));
					if ((err== KErrNone) && !is_placeholder) { 
						iView->HandleCommandL(EcontextmediaappCmdOpenItem);
					}
				}
				break;
			}
			default:
				break;
		}
	}
}

void CContextMediaAppGeneralContainer::mark_as_read()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppGeneralContainer"), _CL("mark_as_read"));

	CCMPost * aPost = get_current_post();
	if (aPost) iStorage.MarkAsRead(aPost);
}

TKeyResponse CContextMediaAppListboxContainer::OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("OfferKeyEventL"));

	if ((aKeyEvent.iCode == EKeyLeftArrow )|| (aKeyEvent.iCode == EKeyRightArrow )) {
		if (iView->Id()==KThreadsByDatePromptId) {
			return EKeyWasConsumed;
		} else {
			return EKeyWasNotConsumed;
		}
	}

	if ( iListbox ) {
                if ((aKeyEvent.iCode ==EKeyOK) && !get_current_post() ) {
			if (iView->Id()==KThreadsByDatePromptId) {
				iView->HandleCommandL(EAknSoftkeySelect);
				return EKeyWasConsumed;
			} else {
				if (iListbox->Model()->NumberOfItems()!=0) iView->HandleCommandL(EcontextmediaappCmdReply);
				return EKeyWasConsumed;
			}
		} else if (aKeyEvent.iCode == EKeyYes){
			if (iView->Id()==KThreadViewId) iView->HandleCommandL(EcontextmediaappCmdReply);
			return EKeyWasConsumed;
		} else {
			return iListbox->OfferKeyEventL(aKeyEvent, aType);
		}
	} else {
		return EKeyWasNotConsumed;
        }
}

TInt CContextMediaAppListboxContainer::get_current_idx()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("get_current_idx"));

	if (iListbox->Model()->NumberOfItems()) {
		return iListbox->CurrentItemIndex();
	}
	return -1;
}

TInt CContextMediaAppListboxContainer::get_top_idx()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("get_top_idx"));

	if (this->iListbox->Model()->NumberOfItems()) {
		return iListbox->TopItemIndex();
	}
	return -1;
}

TInt CContextMediaAppListboxContainer::get_item_count()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("get_item_count"));

	return iListbox->Model()->NumberOfItems();
}


void CContextMediaAppListboxContainer::set_current_idx(TInt idx)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("set_current_idx"));

	if (iListbox && (idx!=-1) && (iListbox->Model()->NumberOfItems()>idx)) {
		iListbox->SetCurrentItemIndex(idx);
	}
}

void CContextMediaAppListboxContainer::set_top_idx(TInt idx)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("set_top_idx"));

	if (iListbox && (idx!=-1) && (iListbox->Model()->NumberOfItems()>idx)) {
		iListbox->SetTopItemIndex(idx);
	}
}


CCMPost * CContextMediaAppListboxContainer::get_current_post()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppListboxContainer"), _CL("get_current_post"));

	TInt idx = get_current_idx();
	
	if (idx>-1) return iMediaTextArray->GetPostAt(idx);
	return 0;
}

//_---------------------------------------------------------------------------------
//_---------------------------------------------------------------------------------
//_---------------------------------------------------------------------------------
//_---------------------------------------------------------------------------------
//_---------------------------------------------------------------------------------

CContextMediaAppPostContainer::CContextMediaAppPostContainer(CCMNetwork &aCMNetwork, CPostStorage &aStorage, TInt64 aNode, 
				 CPostStorage::TSortBy aSort, CPostStorage::TOrder aOrder, CAknView * aView, 
				 const TDesC& aFileName, CBBDataFactory * aFactory) : 
CContextMediaAppGeneralContainer(aCMNetwork, aStorage, aNode,aSort,aOrder,aView), iFileName(aFileName), iFactory(aFactory) {}

void CContextMediaAppPostContainer::ConstructL(const TRect& aRect )
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("ConstructL"));

	iLoadingMedia=EFalse;
	iPlayingMedia=EFalse;
	iMediaReady=EFalse;
	iMediaBrowsingOn = (iFileName.Length()==0);

	iVideoEngine = CVideoEngine::NewL();
	iAudioEngine = CAudioEngine::NewL();
	iDisplayTimeOut = CTimeOut::NewL(*this);
	iPostArray = new (ELeave) CArrayFixFlat<TUint>(50);
	iControls=new (ELeave) CArrayPtrFlat< CCoeControl >(10);

// array of post ids
	if (iView->Id()==KPostViewId) {
		iPost = iStorage.GetByPostIdL(this, iNode); 
		iParentPost = iStorage.GetByPostIdL(this, iPost->iParentId());
		TBool ok = iStorage.FirstL(iPost->iParentId(), iSort, iOrder, EFalse);
		int i=0;
		while (ok) {
			TUint idx=iStorage.GetCurrentIndexL();
			iPostArray->AppendL(idx);
			if (idx == iPost->iLocalDatabaseId()) {
				iCurrentPostIndex = i;
			}
			i++;
			ok = iStorage.NextL();
		}
	} else {
		if (iMediaBrowsingOn) {
			// we get posts from the thread mediapool
			TBool ok = iStorage.FirstL(CPostStorage::MediaPoolId(), iSort, iOrder, ETrue /*important!*/);
			while (ok) {
				TUint idx=iStorage.GetCurrentIndexL();
				iPostArray->AppendL(idx);
				ok = iStorage.NextL();
			}
		} else {
			// we create a single post from the given iFileName
			TTime t; t=GetTime();
			auto_ptr<CFbsBitmap> bm;
			refcounted_ptr<CCMPost>  aPost(CCMPost::NewL(iFactory, 0));
			aPost->iParentId = CPostStorage::MediaPoolId(); 
			aPost->iMediaUrl = iFileName; 
			aPost->iMediaFileName = iFileName;
			TBuf<40> mime; GetMimeTypeL(iFileName, mime);
			aPost->iContentType() = mime;
			aPost->iPostId = CPostStorage::AddMeToMediaPoolId();
			aPost->iUnreadCounter = 1; // IMPORTANT, cause a read post doesn't appear in the list
			aPost->iTimeStamp = t;

			TBuf<50> buf;
			if ( Settings().GetSettingL(SETTING_PUBLISH_AUTHOR, buf ) && buf.Length() != 0) {
				aPost->iSender.iName().Append(buf);
			}
			if ( Settings().GetSettingL(SETTING_JABBER_NICK, buf ) && buf.Length() != 0) {
				aPost->iSender.iJabberNick().Append(buf);
			}
			if ( Settings().GetSettingL(SETTING_PHONENO, buf ) && buf.Length() != 0) {
				aPost->iSender.iPhoneNo().Append(buf);
			}
			GetIMEI(aPost->iSender.iImei()); 
			// FIX ME: BT ADDR HERE
			iStorage.AddLocalL(aPost.get(), bm);

			TBool ok = iStorage.FirstL(CPostStorage::MediaPoolId(), iSort, iOrder, ETrue);
			if (ok) {
				TUint idx=iStorage.GetCurrentIndexL();
				iPostArray->AppendL(idx);
			}
		}
		iCurrentPostIndex=0;
		iPost=iStorage.GetByIndexL( this, (*iPostArray)[iCurrentPostIndex] );
	}

// BEGIN: Graphic components-----------------------------------------------

	CreateWindowL();

	iLoadingBuf = iEikonEnv->AllocReadResourceL(R_LOADING);
	iDownloadingBuf = iEikonEnv->AllocReadResourceL(R_DOWNLOADING);
	iDefaultCommentBuf = iEikonEnv->AllocReadResourceL(R_DEFAULT_COMMENT);
	iDefaultSignatureBuf = iEikonEnv->AllocReadResourceL(R_DEFAULT_SIGNATURE);

	iMediaDisplay = CPAlbImageViewerBasic::NewL(this, KPictureRectangle);
	
	iSBFrame = new (ELeave) CEikScrollBarFrame(this, 0, ETrue);
	iSBFrame->SetScrollBarVisibilityL(CEikScrollBarFrame::EOn, CEikScrollBarFrame::EOn);
	iSBFrame->SetScrollBarManagement(CEikScrollBar::EVertical, CEikScrollBarFrame::EFloating);

	iLeftArrow = new (ELeave) CEikLabel;
	iLeftArrow->SetContainerWindowL(*this);
	iLeftArrow->SetFont(CEikonEnv::Static()->NormalFont());
	iLeftArrow->SetTextL(_L("<"));
	iLeftArrow->SetAlignment(TGulAlignment(EHLeftVCenter));
	iLeftArrow->OverrideColorL(EColorLabelText, KTextColor);
	iLeftArrow->SetPosition(TPoint(2,65));
	iLeftArrow->SetSize(iLeftArrow->MinimumSize());
	iLeftArrow->SetAllMarginsTo(0);
	iLeftArrow->SetFocusing(EFalse);

	iLeftArrowBg = new (ELeave) CEikLabel;
	iLeftArrowBg->SetContainerWindowL(*this);
	iLeftArrowBg->SetTextL(KNullDesC);
	iLeftArrowBg->SetExtent(TPoint(1,65), TSize(8,12));
	iLeftArrowBg->SetEmphasis(CEikLabel::EFullEmphasis);
	iLeftArrowBg->OverrideColorL(EColorLabelHighlightFullEmphasis, KTagsBgColor);
	iLeftArrowBg->SetAllMarginsTo(0);
	iLeftArrowBg->SetFocusing(EFalse);
                
	iLeftArrowBlackBg = new (ELeave) CEikLabel;
	iLeftArrowBlackBg->SetContainerWindowL(*this);
	iLeftArrowBlackBg->SetTextL(KNullDesC);
	iLeftArrowBlackBg->SetExtent(TPoint(1,64), TSize(9,14));
	iLeftArrowBlackBg->SetEmphasis(CEikLabel::EFullEmphasis);
	iLeftArrowBlackBg->OverrideColorL(EColorLabelHighlightFullEmphasis, KTextColor);
	iLeftArrowBlackBg->SetAllMarginsTo(0);
	iLeftArrowBlackBg->SetFocusing(EFalse);

	iRightArrow = new (ELeave) CEikLabel;
	iRightArrow->SetContainerWindowL(*this);
	iRightArrow->SetFont(CEikonEnv::Static()->NormalFont());
	iRightArrow->SetTextL(_L(">"));
	iRightArrow->SetAlignment(TGulAlignment(EHRightVCenter));
	iRightArrow->OverrideColorL(EColorLabelText, KTextColor);
	iRightArrow->SetPosition(TPoint(168,65));
	iRightArrow->SetSize(iRightArrow->MinimumSize());
	iRightArrow->SetAllMarginsTo(0);
	iRightArrow->SetFocusing(EFalse);

	iRightArrowBg = new (ELeave) CEikLabel;
	iRightArrowBg->SetContainerWindowL(*this);
	iRightArrowBg->SetTextL(KNullDesC);
	iRightArrowBg->SetExtent(TPoint(167,65), TSize(8,12));
	iRightArrowBg->SetEmphasis(CEikLabel::EFullEmphasis);
	iRightArrowBg->OverrideColorL(EColorLabelHighlightFullEmphasis, KTagsBgColor);
	iRightArrowBg->SetAllMarginsTo(0);
	iRightArrowBg->SetFocusing(EFalse);

	iRightArrowBlackBg = new (ELeave) CEikLabel;
	iRightArrowBlackBg->SetContainerWindowL(*this);
	iRightArrowBlackBg->SetTextL(KNullDesC);
	iRightArrowBlackBg->SetExtent(TPoint(166,64), TSize(9,14));
	iRightArrowBlackBg->SetEmphasis(CEikLabel::EFullEmphasis);
	iRightArrowBlackBg->OverrideColorL(EColorLabelHighlightFullEmphasis, KTextColor);
	iRightArrowBlackBg->SetAllMarginsTo(0);
	iRightArrowBlackBg->SetFocusing(EFalse);

	iTimeLabel = new (ELeave) CEikLabel;
	iTimeLabel->SetContainerWindowL(*this);
	iTimeLabel->SetFont(LatinPlain12());
	iTimeLabel->SetAlignment(TGulAlignment(EHCenterVCenter));
	iTimeLabel->OverrideColorL(EColorLabelText, KTextColor);
	iTimeLabel->SetAllMarginsTo(0);
	iTimeLabel->SetPosition(TPoint(120, 129));
	iTimeLabel->SetSize(TSize(30, 12));
	iTimeLabel->SetFocusing(EFalse);
	
	iTimeLabelBg = new (ELeave) CEikLabel;
	iTimeLabelBg->SetContainerWindowL(*this);
	iTimeLabelBg->SetTextL(KNullDesC);
	iTimeLabelBg->SetPosition(TPoint(119, 128));
	iTimeLabelBg->SetSize(TSize(32, 12));
	iTimeLabelBg->SetEmphasis(CEikLabel::EFullEmphasis);
	iTimeLabelBg->OverrideColorL(EColorLabelHighlightFullEmphasis, KTagsBgColor);
	iTimeLabelBg->SetAllMarginsTo(0);
	iTimeLabelBg->SetFocusing(EFalse);

	iTimeLabelBlackBg = new (ELeave) CEikLabel;
	iTimeLabelBlackBg->SetContainerWindowL(*this);
	iTimeLabelBlackBg->SetTextL(KNullDesC);
	iTimeLabelBlackBg->SetPosition(TPoint(118, 127));
	iTimeLabelBlackBg->SetSize(TSize(34, 13));
	iTimeLabelBlackBg->SetEmphasis(CEikLabel::EFullEmphasis);
	iTimeLabelBlackBg->OverrideColorL(EColorLabelHighlightFullEmphasis, KTextColor);
	iTimeLabelBlackBg->SetAllMarginsTo(0);
	iTimeLabelBlackBg->SetFocusing(EFalse);

	iCountLabel = new (ELeave) CEikLabel;
	iCountLabel->SetContainerWindowL(*this);
	iCountLabel->SetFont(LatinPlain12());
	iCountLabel->SetAlignment(TGulAlignment(EHCenterVCenter));
	iCountLabel->OverrideColorL(EColorLabelText, KTextColor);
	iCountLabel->SetAllMarginsTo(0);
	iCountLabel->SetPosition(TPoint(73, 2));
	iCountLabel->SetSize(TSize(30, 12));
	iCountLabel->SetFocusing(EFalse);
	
	iCountLabelBg = new (ELeave) CEikLabel;
	iCountLabelBg->SetContainerWindowL(*this);
	iCountLabelBg->SetTextL(KNullDesC);
	iCountLabelBg->SetPosition(TPoint(72, 1));
	iCountLabelBg->SetSize(TSize(32, 12));
	iCountLabelBg->SetEmphasis(CEikLabel::EFullEmphasis);
	iCountLabelBg->OverrideColorL(EColorLabelHighlightFullEmphasis, KTagsBgColor);
	iCountLabelBg->SetAllMarginsTo(0);
	iCountLabelBg->SetFocusing(EFalse);

	iCountLabelBlackBg = new (ELeave) CEikLabel;
	iCountLabelBlackBg->SetContainerWindowL(*this);
	iCountLabelBlackBg->SetTextL(KNullDesC);
	iCountLabelBlackBg->SetPosition(TPoint(71, 1));
	iCountLabelBlackBg->SetSize(TSize(34, 13));
	iCountLabelBlackBg->SetEmphasis(CEikLabel::EFullEmphasis);
	iCountLabelBlackBg->OverrideColorL(EColorLabelHighlightFullEmphasis, KTextColor);
	iCountLabelBlackBg->SetAllMarginsTo(0);
	iCountLabelBlackBg->SetFocusing(EFalse);

	iLoadingLabel=new (ELeave) CEikLabel;
	iLoadingLabel->SetContainerWindowL( *this );
	iLoadingLabel->SetFont(LatinBold17());
	iLoadingLabel->SetRect(KVideoRectangle);
	iLoadingLabel->SetAlignment(TGulAlignment(EHCenterVCenter));
	iLoadingLabel->SetEmphasis(CEikLabel::EFullEmphasis);
	iLoadingLabel->OverrideColorL(EColorLabelText, KTextColor);
	iLoadingLabel->OverrideColorL(EColorLabelHighlightFullEmphasis, KUnfocusedBgColor);
	iLoadingLabel->SetFocusing(EFalse);

	if (iView->Id()==KPostViewId) {
		iComment = new (ELeave) OurOwnRichTextEditor(0);;
		iComment->ConstructL(this, 3, 178, 0);
		iComment->SetContainerWindowL(*this);
		iComment->SetExtent(TPoint(1,141), TSize(174, 46));
		iComment->SetBackgroundColorL(KUnfocusedBgColor);
		iComment->SetReadOnly(ETrue);
		iComment->SetFocusing(EFalse);
		
		iSignature = new (ELeave) OurOwnRichTextEditor(iDefaultSignatureBuf);
		iSignature->ConstructL(this, 1, 20, 0);
		iSignature->SetContainerWindowL(*this);
		iSignature->SetExtent(TPoint(1,171), TSize(174, 16));
		iSignature->MakeVisible(EFalse);
	} else {
		iLoadingLabel->SetFocusing(ETrue);
		iControls->AppendL(iLoadingLabel);

		iComment = new (ELeave) OurOwnRichTextEditor(iDefaultCommentBuf);
		iComment->SetAknEditorAllowedInputModes(EAknEditorAllInputModes);
		iComment->ConstructL(this, 2, 128, EAknEditorFlagDefault);
		iComment->SetContainerWindowL(*this);
		iComment->SetExtent(TPoint(1,141), TSize(174, 29));
		iComment->SetBackgroundColorL(KUnfocusedBgColor);
		iControls->AppendL(iComment);

		iSignature = new (ELeave) OurOwnRichTextEditor(iDefaultSignatureBuf);
		iSignature->SetAknEditorAllowedInputModes(EAknEditorAllInputModes);
		iSignature->ConstructL(this, 1, 20, 0);
		iSignature->SetContainerWindowL(*this);
		iSignature->SetExtent(TPoint(1,171), TSize(174, 16));
		iSignature->SetBackgroundColorL(KUnfocusedBgColor);
		iControls->AppendL(iSignature);
	}

	iNotifyControl=new (ELeave) CNotifyWindowControl;
	iNotifyControl->ConstructL(this);
	iNotifyControl->SetContainerWindowL(*this);
	iNotifyControl->SetExtent(TPoint(176-19,0), TSize(9, 30));
	iControls->AppendL(iNotifyControl);

// END: Graphic components-----------------------------------------------
	RestoreOriginalCBAL();

	SetRect(aRect);
	ActivateL();
	display_current();
}

CContextMediaAppPostContainer::~CContextMediaAppPostContainer()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("~CContextMediaAppPostContainer"));
	
	iDisplayTimeOut->Reset(); 
	delete iDisplayTimeOut;

	delete iMediaDisplay;
	
	iVideoEngine->CloseController();
	iAudioEngine->CloseController();
	delete iAudioEngine;
	delete iVideoEngine;

	iStorage.Release(iPost, this);
	iStorage.Release(iParentPost, this);
	delete iPostArray;
	
	delete iLoadingLabel;
	delete iLeftArrow;
	delete iLeftArrowBg;
	delete iLeftArrowBlackBg;
	delete iRightArrow;
	delete iRightArrowBg;
	delete iRightArrowBlackBg;
	delete iTimeLabel;
	delete iTimeLabelBg;
	delete iTimeLabelBlackBg;
	delete iCountLabel;
	delete iCountLabelBg;
	delete iCountLabelBlackBg;
	delete iComment;
	delete iSignature;

	delete iControls;
	
	delete iLoadingBuf;
	delete iDownloadingBuf;
	delete iDefaultSignatureBuf;
	delete iDefaultCommentBuf;
	delete iNotifyControl;

	delete iSBFrame;
}

void CContextMediaAppPostContainer::SizeChanged()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("SizeChanged"));

	// no impl
}

TInt CContextMediaAppPostContainer::CountComponentControls() const
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("CountComponentControls"));

	return 17; 
}

CCoeControl* CContextMediaAppPostContainer::ComponentControl(TInt aIndex) const
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("ComponentControl"));

	switch ( aIndex ) {
		case 0: return iLoadingLabel;
		case 1: return iMediaDisplay;
		case 2: return iLeftArrowBlackBg;
		case 3: return iLeftArrowBg;
		case 4:	return iLeftArrow;
		case 5: return iRightArrowBlackBg;
		case 6: return iRightArrowBg;
		case 7: return iRightArrow;
		case 8:	return iTimeLabelBlackBg;
		case 9: return iTimeLabelBg;
		case 10: return iTimeLabel;
		case 11: return iCountLabelBlackBg;
		case 12: return iCountLabelBg;
		case 13: return iCountLabel;
		case 14: return iComment;
		case 15: return iSignature;
		case 16: return iNotifyControl;
		
		default: return 0;
        }
}

void CContextMediaAppPostContainer::Draw(const TRect& aRect) const
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("Draw"));

	if ((iView->Id()==KPostViewId) && (iCurrentScrollPos==0)) 
		//necessary to display the comment properly. Reset the cursor position to beginning of text
		//makes it readable!
		iComment->MoveCursorL(TCursorPosition::EFPageUp, EFalse); 

	iMediaDisplay->MakeVisible(iMediaReady);
	
	CWindowGc& gc = SystemGc();
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbBlack);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);
		
	if (iView->Id()!=KPostViewId) {
		TInt isfocused=0;
		for (int i=0; i<iControls->Count();i++) {
			if (iControls->At(i)->IsFocused()) {
				isfocused=i;
				iControls->At(i)->OverrideColorL(EColorControlBackground, KFocusedBgColor);
				iControls->At(i)->OverrideColorL(EColorLabelHighlightFullEmphasis, KFocusedBgColor);
			} else {
				iControls->At(i)->OverrideColorL(EColorControlBackground, KUnfocusedBgColor);
				iControls->At(i)->OverrideColorL(EColorLabelHighlightFullEmphasis, KUnfocusedBgColor);
			}	
		}
		TRect re = iControls->At(isfocused)->Rect();
		re.Resize(2, 2);
		re.Move(-1, -1);
		
		gc.SetBrushColor(KRgbBlue);
		gc.DrawRect(re);
		gc.SetBrushColor(KRgbBlack);
	}
}

TKeyResponse CContextMediaAppPostContainer::OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("OfferKeyEventL"));

	if (aType != EEventKey) return EKeyWasNotConsumed;

	if (aKeyEvent.iCode == EKeyYes){
		if (iView->Id()==KPostViewId) {
			if ((!iPlayingMedia)&& (!iLoadingMedia)) iView->HandleCommandL(EcontextmediaappCmdReply);
		} else {
			if (!iLoadingMedia) iView->HandleCommandL(EcontextmediaappCmdPublish);
		}
		return EKeyWasConsumed;
	}

	if (aKeyEvent.iCode == EKeyUpArrow) {
		if (iPlayingMedia) {
			if (iMediaFileType==EAudio) {
				iAudioEngine->IncreaseVolume();
			} else if (iMediaFileType==EVideo) {
				iVideoEngine->IncreaseVolume();
			}
		} else {
			if (iView->Id()==KPostViewId) {
				if (iCurrentScrollPos>0) {
					iSBFrame->MoveThumbsBy(0, -1);
					iComment->MoveDisplayL(TCursorPosition::EFLineUp);
					iSBFrame->DrawScrollBarsNow();
					iCurrentScrollPos--;
				}  
			} else {
				if (iComment->IsFocused() ) {
					if (iComment->CursorPos() == 0) {			
						FocusPrevious();
					} else {
						iComment->MoveCursorL(TCursorPosition::EFLineUp, EFalse);
					}
				} else if (iSignature->IsFocused()) {
					if (iSignature->CursorPos() == 0) {			
						FocusPrevious();
					} else {
						iSignature->MoveCursorL(TCursorPosition::EFLineUp, EFalse);
					}
				} else {
					FocusPrevious();
				}
			}
		}
		return EKeyWasConsumed;
	}

	if (aKeyEvent.iCode == EKeyDownArrow) {
		if (iPlayingMedia) {
			if (iMediaFileType==EAudio) {
				iAudioEngine->DecreaseVolume();
			} else if (iMediaFileType==EVideo) {
				iVideoEngine->DecreaseVolume();
			}
		} else {
			if (iView->Id()==KPostViewId) {
				if (iCurrentScrollPos+1<iMaxScrollPos) {
					iSBFrame->MoveThumbsBy(0, 1);
					iComment->MoveDisplayL(TCursorPosition::EFLineDown);
					iSBFrame->DrawScrollBarsNow();
					iCurrentScrollPos++;
				}
			} else {
				if (iComment->IsFocused() ) {
					if (iComment->CursorPos() == iComment->TextLength()) {			
						FocusNext();
					} else {
						iComment->MoveCursorL(TCursorPosition::EFLineDown, EFalse);
					}
				} else if (iSignature->IsFocused()) {
					if (iSignature->CursorPos() == iSignature->TextLength()) {			
						FocusNext();
					} else {
						iSignature->MoveCursorL(TCursorPosition::EFLineDown, EFalse);
					}
				} else {
					FocusNext();
				}
			}
			
		}
		return EKeyWasConsumed;
	}
	
	if (aKeyEvent.iCode==EKeyLeftArrow) {
		if (iView->Id()==KPostViewId) {
                        if (!iLoadingMedia && !iPlayingMedia && has_previous()) {
				display_previous();
			}
		} else if (!iPlayingMedia) {
			if (iComment->IsFocused()) {
				return iComment->OfferKeyEventL(aKeyEvent, aType);
			} else if (iSignature->IsFocused()) {
				return iSignature->OfferKeyEventL(aKeyEvent, aType);
			} else if (iMediaBrowsingOn && !iLoadingMedia && !iPlayingMedia && has_previous()) {
				display_previous();
			}
		}
		return EKeyWasConsumed;
	}

	if (aKeyEvent.iCode==EKeyRightArrow) {
		if (iView->Id()==KPostViewId) {
			if (!iLoadingMedia && !iPlayingMedia && has_next()) display_next();
		} else if (!iPlayingMedia){
			if (iComment->IsFocused()) {
				return iComment->OfferKeyEventL(aKeyEvent, aType);
			} else if (iSignature->IsFocused()) {
				return iSignature->OfferKeyEventL(aKeyEvent, aType);
			} else if (iMediaBrowsingOn && !iLoadingMedia && !iPlayingMedia && has_next()) {
				display_next();
			}
		}
		return EKeyWasConsumed;
	}

	if ( aKeyEvent.iCode == EKeyBackspace) {
		if (iPlayingMedia) {
			return EKeyWasConsumed;
		} else 	if (iView->Id()==KPostViewId) {
			return EKeyWasNotConsumed;
		} else {
			if (iComment->IsFocused()) {
				return iComment->OfferKeyEventL(aKeyEvent, aType);
			} else if (iSignature->IsFocused()) {
				return iSignature->OfferKeyEventL(aKeyEvent, aType);
			} else if (iLoadingLabel->IsFocused()){
				iView->HandleCommandL(EcontextmediaappCmdDelete);
				return EKeyWasConsumed;
			} else {
				return EKeyWasNotConsumed;
			}
		}
	}

	if ( (aKeyEvent.iCode == EKeyOK) && IsCurrentPlayableMedia()){
		if (iView->Id()==KPostViewId) {
			if (!iPlayingMedia) {
				Play();
			} else {
				if (iMediaFileType==EVideo) {
					if ( iVideoEngine->GetEngineState() == CVideoEngine::EPPlaying ) {
						Pause();
					} else if (iVideoEngine->GetEngineState() == CVideoEngine::EPPaused) {
						Resume();
					} 
				} else if (iMediaFileType==EAudio){
					if ( iAudioEngine->GetEngineState() == CAudioEngine::EPPlaying ) {
						Pause();
					} else if (iAudioEngine->GetEngineState() == CAudioEngine::EPPaused) {
						Resume();
					} 
				}
			}
		} else {
			if ((iLoadingLabel->IsFocused())) {
				if (!iPlayingMedia) {
					Play();
				} else {
					if (iMediaFileType==EVideo) {
						if ( iVideoEngine->GetEngineState() == CVideoEngine::EPPlaying ) {
							Pause();
						} else if (iVideoEngine->GetEngineState() == CVideoEngine::EPPaused) {
							Resume();
						} 
					} else if (iMediaFileType==EAudio){
						if ( iAudioEngine->GetEngineState() == CAudioEngine::EPPlaying ) {
							Pause();
						} else if (iAudioEngine->GetEngineState() == CAudioEngine::EPPaused) {
							Resume();
						} 
					}
				}
			}
		}
		return EKeyWasConsumed;
	}
	return EKeyWasNotConsumed;
}

void CContextMediaAppPostContainer::PostEvent(CCMPost* /*aParent*/, CCMPost* aChild, TEvent aEvent)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("PostEvent"));

	if (aChild==iPost) {
		if ( (aEvent == EMediaLoaded) || (aEvent == EErrorUpdated) ) {
			DisplayPictureL();
			DrawNow();
		}
	} 
}

TBool CContextMediaAppPostContainer::has_next()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("has_next"));

	return (iPostArray->Count() > iCurrentPostIndex+1);
}

TBool CContextMediaAppPostContainer::has_previous()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("has_previous"));

	return (iCurrentPostIndex>=1);	
}

void CContextMediaAppPostContainer::display_next()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("display_next"));

	if (iView->Id()!=KPostViewId) {
		save_contribution_to_post();
		iStorage.UpdatePostL(iPost); // save post to storage
	}

	iCurrentPostIndex++;

	iStorage.Release(iPost, this); iPost=0;
	iPost=iStorage.GetByIndexL( this, (*iPostArray)[iCurrentPostIndex] );
	display_current();
	DrawNow();
}

void CContextMediaAppPostContainer::display_previous()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("display_previous"));

	if (iView->Id()!=KPostViewId) {
		save_contribution_to_post();
		iStorage.UpdatePostL(iPost); // save post to storage
	}
	iCurrentPostIndex--;

	iStorage.Release(iPost, this); iPost=0;
	iPost=iStorage.GetByIndexL(this, (*iPostArray)[iCurrentPostIndex]);
	display_current();
	DrawNow();
}

void CContextMediaAppPostContainer::display_current()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("display_current"));

	/* get current post */
	CCMPost * aPost = iPost;
	
	/* reset visual components */
	iLoadingLabel->SetTextL(KNullDesC);

	TBuf<10> count;
	count.AppendFormat(_L("%d/%d"), iCurrentPostIndex+1,iPostArray->Count());
	iCountLabel->SetTextL(count);
	iMediaReady = EFalse;
	iMediaFileType = EUnknown;
	iMediaDisplay->ReleaseImageLoader();
	iMediaDisplay->ReleaseMemoryAndVisibleBitmap();
	iRightArrow->MakeVisible(has_next());
	iRightArrowBg->MakeVisible(has_next());
	iRightArrowBlackBg->MakeVisible(has_next());
	iLeftArrow->MakeVisible(has_previous());
	iLeftArrowBg->MakeVisible(has_previous());
	iLeftArrowBlackBg->MakeVisible(has_previous());

	if (iView->Id()==KPostViewId) {
		/* set previous view indices to reflect browsing movement */
		CAknViewAppUi * appui = (CAknViewAppUi *)(iEikonEnv->AppUi());
		CContextMediaAppThreadView * view = (CContextMediaAppThreadView *)(appui->View(KThreadViewId));
		view->SetCurrentIndex(get_current_idx()+1);
		view->SetTopIndex(get_top_idx()+1);
	}

	/* update text */
	TInt lines=0;
	if (aPost) {
		TBuf<5> time;
		TTime now=GetTime();
		if ((now.DateTime().Year()==aPost->iTimeStamp().DateTime().Year()) 
			&& (now.DateTime().Month()==aPost->iTimeStamp().DateTime().Month())
			&& (now.DateTime().Day()==aPost->iTimeStamp().DateTime().Day()) ) {
			
			aPost->iTimeStamp().FormatL(time, _L("%F%H:%T"));
		} else {
			aPost->iTimeStamp().FormatL(time, _L("%F%D/%M"));
		}
		iTimeLabel->SetTextL(time);

		if (iView->Id()==KPostViewId) {
			CRichText * aRichText = iComment->RichText();
			aRichText->Reset();
			aRichText->InsertL(aRichText->DocumentLength(), aPost->iBodyText->iPtr);
			aRichText->InsertL(aRichText->DocumentLength(), CEditableText::EParagraphDelimiter);
			aRichText->InsertL(aRichText->DocumentLength(), aPost->iSender.iName());

			CParaFormat paraFormat;
			TParaFormatMask paraFormatMask;
			TFontSpec fontspec = LatinPlain12()->FontSpecInTwips();
			TCharFormat charFormat( fontspec.iTypeface.iName, fontspec.iHeight );
			TCharFormatMask charFormatMask;

			aRichText->GetParaFormatL(&paraFormat, paraFormatMask, 0, aPost->iBodyText->iPtr.Length());
			paraFormatMask.SetAttrib(EAttLineSpacingControl);
			paraFormatMask.SetAttrib(EAttLineSpacing);
			paraFormatMask.SetAttrib(EAttAlignment);
			paraFormat.iLineSpacingControl = CParaFormat::ELineSpacingExactlyInTwips;
			paraFormat.iLineSpacingInTwips = 115;
			paraFormat.iHorizontalAlignment = CParaFormat::EJustifiedAlign;
			aRichText->ApplyParaFormatL(&paraFormat, paraFormatMask, 0, aPost->iBodyText->iPtr.Length());
			charFormat.iFontPresentation.iTextColor=KRgbBlack;
			charFormatMask.SetAttrib(EAttColor);
			charFormatMask.SetAttrib(EAttFontTypeface);
			charFormatMask.SetAttrib(EAttFontHeight);
			aRichText->ApplyCharFormatL(charFormat, charFormatMask, 0, aPost->iBodyText->iPtr.Length());

			aRichText->GetParaFormatL(&paraFormat, paraFormatMask, aPost->iBodyText->iPtr.Length()+1, aPost->iSender.iName().Length());
			paraFormatMask.SetAttrib(EAttLineSpacingControl);
			paraFormatMask.SetAttrib(EAttLineSpacing);
			paraFormatMask.SetAttrib(EAttAlignment);
			paraFormat.iLineSpacingControl = CParaFormat::ELineSpacingExactlyInTwips;
			paraFormat.iLineSpacingInTwips = 115;
			paraFormat.iHorizontalAlignment = CParaFormat::ERightAlign;
			aRichText->ApplyParaFormatL(&paraFormat, paraFormatMask, aPost->iBodyText->iPtr.Length()+1, aPost->iSender.iName().Length());
			charFormat.iFontPresentation.iTextColor=KRgbBlue;
			charFormatMask.SetAttrib(EAttColor);
			charFormatMask.SetAttrib(EAttFontTypeface);
			charFormatMask.SetAttrib(EAttFontHeight);
			aRichText->ApplyCharFormatL(charFormat, charFormatMask, aPost->iBodyText->iPtr.Length()+1, aPost->iSender.iName().Length());

		} else {
			iComment->Reset();
			CRichText * aRichText = iComment->RichText();
             		if (aPost->iBodyText->iPtr.Length()) {
				aRichText->Reset();
				aRichText->InsertL(0, aPost->iBodyText->iPtr);
			}

			CParaFormat paraFormat;
			TParaFormatMask paraFormatMask;
			TFontSpec fontspec = LatinPlain12()->FontSpecInTwips();
			TCharFormat charFormat( fontspec.iTypeface.iName, fontspec.iHeight );
			TCharFormatMask charFormatMask;

			aRichText->GetParaFormatL(&paraFormat, paraFormatMask, 0, aRichText->DocumentLength());
			paraFormatMask.SetAttrib(EAttLineSpacingControl);
			paraFormatMask.SetAttrib(EAttLineSpacing);
			paraFormatMask.SetAttrib(EAttAlignment);
			paraFormat.iLineSpacingControl = CParaFormat::ELineSpacingExactlyInTwips;
			paraFormat.iLineSpacingInTwips = 115;
			paraFormat.iHorizontalAlignment = CParaFormat::EJustifiedAlign;
			aRichText->ApplyParaFormatL(&paraFormat, paraFormatMask, 0, aRichText->DocumentLength());
			charFormat.iFontPresentation.iTextColor=KRgbBlack;
			charFormatMask.SetAttrib(EAttColor);
			charFormatMask.SetAttrib(EAttFontTypeface);
			charFormatMask.SetAttrib(EAttFontHeight);
			aRichText->ApplyCharFormatL(charFormat, charFormatMask, 0, aRichText->DocumentLength());
		
			iSignature->Reset();
			aRichText = iSignature->RichText();
			if (aPost->iSender.iName().Length()) {
				aRichText->Reset();
				aRichText->InsertL(0, aPost->iSender.iName());
			}
			aRichText->GetParaFormatL(&paraFormat, paraFormatMask, 0, aRichText->DocumentLength());
			paraFormatMask.SetAttrib(EAttLineSpacingControl);
			paraFormatMask.SetAttrib(EAttLineSpacing);
			paraFormatMask.SetAttrib(EAttAlignment);
			paraFormat.iLineSpacingControl = CParaFormat::ELineSpacingExactlyInTwips;
			paraFormat.iLineSpacingInTwips = 115;
			paraFormat.iHorizontalAlignment = CParaFormat::EJustifiedAlign;
			aRichText->ApplyParaFormatL(&paraFormat, paraFormatMask, 0, aRichText->DocumentLength());
			charFormat.iFontPresentation.iTextColor=KRgbBlack;
			charFormatMask.SetAttrib(EAttColor);
			charFormatMask.SetAttrib(EAttFontTypeface);
			charFormatMask.SetAttrib(EAttFontHeight);
			aRichText->ApplyCharFormatL(charFormat, charFormatMask, 0, aRichText->DocumentLength());
		}
		iComment->HandleTextChangedL();
		iSignature->HandleTextChangedL();
	}
	
	// adjust up&down arrow indicators to scroll text, if necessary
	if (iView->Id()==KPostViewId) {
		/* little hack to know how many scrolling positions we should have for the scroll bars */
		iComment->MoveCursorL(TCursorPosition::EFPageUp, EFalse);
		while (iComment->CursorPos()!=iComment->TextLength()) {
			iComment->MoveCursorL(TCursorPosition::EFLineDown, EFalse);
			lines++;
		}
		
		// Handling of the textbox+up/down arrow below
		iCurrentScrollPos=0;
		iMaxScrollPos=lines-3; // 3lines displayed on screen
		if (iMaxScrollPos>0) {
			iMaxScrollPos++;
			iModel = TEikScrollBarModel(iMaxScrollPos, 0, 0);
			iSBFrame->SetScrollBarVisibilityL(CEikScrollBarFrame::EOff,CEikScrollBarFrame::EAuto);
			iSBFrame->Tile(&iModel);
		} else {
			iModel = TEikScrollBarModel(0, 0, 0);
			iSBFrame->SetScrollBarVisibilityL(CEikScrollBarFrame::EOff,CEikScrollBarFrame::EOff);
			iSBFrame->Tile(&iModel);
		}
		iSBFrame->DrawScrollBarsNow();
	}

	// set default focus
	if (iView->Id()==KPostViewId) {
		iLoadingLabel->SetFocus(ETrue);
	} else {
		int i=0;
		for(i=0; i<iControls->Count();i++) {
			iControls->At(i)->SetFocus(EFalse);
		}
	
		if (!iMediaBrowsingOn) {
			iComment->PrepareForFocusGainL();
			iComment->SetFocus(ETrue);
		} else {
			iLoadingLabel->SetFocus(ETrue);
		}
	}

	// make the display asynchronous but with no delay
	iDisplayTimeOut->Wait(0);
}

void CContextMediaAppPostContainer::DisplayPictureL()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("DisplayPictureL"));

	if (!iMediaDisplay) return;

	iLoadingMedia=ETrue;
	iMediaReady=EFalse;

	iMediaDisplay->MakeVisible(EFalse);
	DrawNow();

	const CCMPost * aPost = iPost;
	TBuf<255> msg;

	CContextMediaAppAppUi * appui = (CContextMediaAppAppUi*)(iEikonEnv->AppUi());

	if (!aPost) {
		if (iView->Id()==KPostViewId) {
			msg.Append(_L("err: no post!\n")); //FIX ME
			iLoadingLabel->SetTextL(msg);
			iLoadingMedia=EFalse;
		} else {
			msg.Append(_L("No media found!\n")); // FIX ME
			iLoadingLabel->SetTextL(msg);
			iLoadingMedia=EFalse;
			CEikButtonGroupContainer * cba = CEikButtonGroupContainer::Current();
			if( cba) {
				cba->SetCommandSetL( R_AVKON_SOFTKEYS_BACK );
				cba->DrawNow();
			}
		}
		return;
	} else if (aPost->iErrorCode()!=0) {
		msg.AppendFormat(_L("err %d:\n"), aPost->iErrorCode());
		msg.Append(aPost->iErrorDescr());
		iLoadingLabel->SetTextL(msg);
	} else if (aPost->iMediaFileName().Length()==0) {
		msg.Append(*iDownloadingBuf);
		iLoadingLabel->SetTextL(msg);	
		iCMNetwork.FetchMedia(aPost);
	} else if (aPost->iMediaFileName().Length()!=0) {
		iLoadingLabel->SetTextL(*iLoadingBuf);
		iLoadingLabel->DrawNow();
		TFileName fn;
		if (aPost->iContentType().FindF(_L("image/"))!=KErrNotFound) {
			fn = aPost->iMediaFileName();
			iMediaFileType = EImage;
		} else if (aPost->iContentType().FindF(_L("video/"))!=KErrNotFound){
			appui->GetVideoMbmPath(fn);
			iMediaFileType = EVideo;
		} else if (aPost->iContentType().FindF(_L("audio/"))!=KErrNotFound){
			msg=_L("Audio not supported");
			iLoadingLabel->SetTextL(msg);
			/*
			appui->GetAudioMbmPath(fn);
			iMediaFileType = EAudio;
			*/
		} else {
			appui->GetUnknownMbmPath(fn);
			iMediaFileType = EUnknown;
		}

		TInt err=KErrNone;
		if (!iMediaDisplay->IsBusy()) {
			iMediaDisplay->ReleaseImageLoader();
			iMediaDisplay->ReleaseMemoryAndVisibleBitmap();
			RDebug::Print(_L("Release mem, about to load"));
#ifdef __S60V2__
			TRAPD(errd, err=iMediaDisplay->LoadImageL(fn, EColor64K));
#else 
			TRAPD(errd, err=iMediaDisplay->LoadImageL(fn, EColor4K));
#endif
			if (errd) err=errd;
			if (err==KErrNone) iMediaDisplay->FreeScaleL(KPictureSize, EFalse);
		} else {
			iDisplayTimeOut->Wait(1);
		}

		if (err!=KErrNone) {
			msg.AppendFormat(_L("Err %d:\n can't open\n"), err);
			msg.Append(fn);
			iLoadingLabel->SetTextL(msg);
		} else {
			if (iView->Id()==KPostViewId) {
				mark_as_read();
			}
			iMediaReady=ETrue;
		}
	}
	iLoadingMedia=EFalse;
	DrawNow();
}

void CContextMediaAppPostContainer::expired(CBase * /*source*/)
{
	DisplayPictureL();
}

void CContextMediaAppPostContainer::Play()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("Play"));

	if (!iMediaReady) return;
	if (!IsCurrentPlayableMedia()) return;
	CCMPost * aPost = iPost;

	TRAPD(ignore, PlayMediaFileL(aPost->iMediaFileName());)
}

void CContextMediaAppPostContainer::PlayMediaFileL(const TDesC& aFilename)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("PlayMediaFileL"));

	if (!IsCurrentPlayableMedia()) return;
	iPlayingMedia = ETrue;
	iRightArrow->MakeVisible(EFalse);
	iRightArrowBlackBg->MakeVisible(EFalse);
	iRightArrowBg->MakeVisible(EFalse);
	iLeftArrow->MakeVisible(EFalse);
	iLeftArrowBlackBg->MakeVisible(EFalse);
	iLeftArrowBg->MakeVisible(EFalse);
	iTimeLabel->MakeVisible(EFalse);
	iTimeLabelBg->MakeVisible(EFalse);
	iTimeLabelBlackBg->MakeVisible(EFalse);
	iCountLabel->MakeVisible(EFalse);
	iCountLabelBg->MakeVisible(EFalse);
	iCountLabelBlackBg->MakeVisible(EFalse);

	if (iMediaFileType==EVideo) {
		iMediaReady=EFalse;
		iMediaDisplay->MakeVisible(EFalse);
		iLoadingLabel->SetTextL(*iLoadingBuf);

		iMediaDisplay->DrawNow();
		iLoadingLabel->DrawNow();
		
		TRect r = KVideoRectangle;
		iVideoEngine->SetNewFileL( aFilename );
		iVideoEngine->InitControllerL(this, ControlEnv()->WsSession(), 
						*(ControlEnv()->ScreenDevice()),
						Window(), r, r );
	} else if (iMediaFileType==EAudio) {
		iAudioEngine->SetNewFileL(aFilename);
		iAudioEngine->InitControllerL(this);
	} 
}

void CContextMediaAppPostContainer::PauseMediaFileL()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("PauseMediaFileL"));

	if (iMediaFileType==EVideo) {
		iVideoEngine->DoPauseL();
	} else if (iMediaFileType==EAudio){
		iAudioEngine->DoPauseL();
	}

	CEikButtonGroupContainer * cba = CEikButtonGroupContainer::Current();
	if( cba) {
		cba->SetCommandSetL( R_CONTINUE_STOP );
		cba->DrawNow();
	}
}

void CContextMediaAppPostContainer::StopMediaFileL()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("StopMediaFileL"));

	if (iMediaFileType==EVideo) {
		iVideoEngine->DoStopL();
	} else if (iMediaFileType==EAudio){
		iAudioEngine->DoStopL();
	}
}	

void CContextMediaAppPostContainer::ResumeMediaFileL()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("ResumeMediaFileL"));

	if (iMediaFileType==EVideo) {
		if ( iVideoEngine->GetEngineState() != CVideoEngine::EPPaused ) return;
		iVideoEngine->DoPlayL();
	} else if (iMediaFileType==EAudio){
		if ( iAudioEngine->GetEngineState() != CAudioEngine::EPPaused ) return;
		iAudioEngine->DoPlayL();
	}
	
	CEikButtonGroupContainer * cba = CEikButtonGroupContainer::Current();
	if( cba) {
		cba->SetCommandSetL( R_PAUSE_STOP );
		cba->DrawNow();
	}		
}

void CContextMediaAppPostContainer::PlayCompletedL(TInt aError)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("PlayCompletedL"));

	if (aError != KErrNone) {
		CAknWarningNote * aNote  = new (ELeave) CAknWarningNote(EFalse);
		CleanupStack::PushL(aNote);
		aNote->SetTone( CAknNoteDialog::ENoTone  );
		aNote->ExecuteLD(_L("Error play media file!"));
		CleanupStack::Pop();
	}
	iRightArrow->MakeVisible(has_next());
	iRightArrowBg->MakeVisible(has_next());
	iRightArrowBlackBg->MakeVisible(has_next());
	iLeftArrow->MakeVisible(has_previous());
	iLeftArrowBg->MakeVisible(has_previous());
	iLeftArrowBlackBg->MakeVisible(has_previous());
	iTimeLabel->MakeVisible(ETrue);
	iTimeLabelBg->MakeVisible(ETrue);
	iTimeLabelBlackBg->MakeVisible(ETrue);
	RestoreOriginalCBAL();
	if (iMediaFileType==EVideo) {
		iMediaReady=ETrue;
		DrawNow();
	}
	iPlayingMedia=EFalse;
}

void CContextMediaAppPostContainer::InitControllerCompletedL(TInt aError)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("InitControllerCompletedL"));

	if (aError==KErrNone) {
		CEikButtonGroupContainer * cba = CEikButtonGroupContainer::Current();
		if( cba)  {
			cba->SetCommandSetL( R_PAUSE_STOP );
			cba->DrawNow();
		}

		if (iMediaFileType==EVideo) {
			iMediaDisplay->MakeVisible(EFalse);
			iLoadingLabel->MakeVisible(EFalse);
			iVideoEngine->DoPlayL();
		} else if (iMediaFileType==EAudio){
			iAudioEngine->DoPlayL();
		}
	} else {
		// FIX ME: popup warning note 'couldn't initialise'
	}
}

void CContextMediaAppPostContainer::RestoreOriginalCBAL()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("RestoreOriginalCBAL"));

	CEikButtonGroupContainer * cba = CEikButtonGroupContainer::Current();
	if (cba) {
		if (iView->Id()!=KPostViewId) {
			if (iMediaBrowsingOn) {
				cba->SetCommandSetL( R_AVKON_SOFTKEYS_SELECT_BACK );
			} else {
				if (iNode != CPostStorage::MediaPoolId()) {
					cba->SetCommandSetL( R_CBA_POST_CANCEL);
				} else {
					cba->SetCommandSetL( R_AVKON_SOFTKEYS_OPTIONS_BACK);
				}
			}
		} else {
			cba->SetCommandSetL( R_AVKON_SOFTKEYS_OPTIONS_BACK);
		}
		cba->DrawNow();
	}
}

void CContextMediaAppPostContainer::Pause()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("Pause"));

	TRAPD(ignore, PauseMediaFileL();)
}

void CContextMediaAppPostContainer::Resume()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("Resume"));

	TRAPD(ignore, ResumeMediaFileL();)
}

void CContextMediaAppPostContainer::Stop()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("Stop"));

	TRAPD(ignore, StopMediaFileL();)
}

CCMPost * CContextMediaAppPostContainer::get_current_post()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("get_current_post"));

	return iPost; // here, no need to query the storage...
}

TInt CContextMediaAppPostContainer::get_current_idx()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("get_current_idx"));

	return iCurrentPostIndex;
}

TInt CContextMediaAppPostContainer::get_top_idx()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("get_top_idx"));

	if (iCurrentPostIndex<=2) {
		return 0;
	} else {
		return (iCurrentPostIndex-2);
	}
}

void CContextMediaAppPostContainer::set_current_idx(TInt idx)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("set_current_idx"));

	iCurrentPostIndex = idx;
}

void CContextMediaAppPostContainer::set_top_idx(TInt /*idx*/)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("set_top_idx"));

	// no impl
}

TBool CContextMediaAppPostContainer::IsCurrentPlayableMedia()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("IsCurrentPlayableMedia"));

	return ( (iMediaFileType==EVideo) || (iMediaFileType==EAudio) );
}

TInt CContextMediaAppPostContainer::get_item_count()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("get_item_count"));

	return 0;
}

void CContextMediaAppPostContainer::save_contribution_to_post()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppContainer2"), _CL("save_contribution_to_post"));

	CCMPost * aPost = get_current_post();
	if (aPost) {
		const TDesC& comment = iComment->RichText()->Read(0, iComment->TextLength());
		if (comment.CompareF(*iDefaultCommentBuf)!=0) aPost->iBodyText->iPtr = comment;

		const TDesC& sign = iSignature->RichText()->Read(0, iSignature->TextLength());
		if (sign.CompareF(*iDefaultSignatureBuf)!=0) {
			aPost->iSender.iName().Copy(sign);
			TRAPD(ignore, Settings().WriteSettingL(SETTING_PUBLISH_AUTHOR, sign));
		}
		TTime t; t=GetTime();
		aPost->iTimeStamp() = t;
	}
}

void CContextMediaAppPostContainer::FocusNext()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("FocusNext"));

        for (int i=0;i<iControls->Count();i++) {
		if (iControls->At(i)->IsFocused()) {
			if (i+1<iControls->Count()) {
				iControls->At(i)->PrepareForFocusLossL();
				iControls->At(i)->SetFocus(EFalse);
				iControls->At(i+1)->PrepareForFocusGainL();
				iControls->At(i+1)->SetFocus(ETrue);
				iSBFrame->MoveThumbsBy(0, 1);
				DrawNow();
				return;
			}
		}
	}
}

void CContextMediaAppPostContainer::FocusPrevious()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppPostContainer"), _CL("FocusPrevious"));

	for (int i=iControls->Count()-1;i>=0;i--) {
		if (iControls->At(i)->IsFocused()) {
			if ((i-1)>=0 ) {
				iControls->At(i)->PrepareForFocusLossL();
				iControls->At(i)->SetFocus(EFalse);
				iControls->At(i-1)->PrepareForFocusGainL();
				iControls->At(i-1)->SetFocus(ETrue);
				iSBFrame->MoveThumbsBy(0, -1);
				DrawNow();
				return;
			}
		}
	}	
}

TBool CContextMediaAppPostContainer::IsLoadingMedia()
{
	return iLoadingMedia;
}

///--------------------------------------------------------------------------------------------

void OurOwnRichTextEditor::HandleTextChangedL()
{
	CALLSTACKITEM_N(_CL("OurOwnRichTextEditor"), _CL("HandleTextChangedL"));

	CEikRichTextEditor::HandleTextChangedL();

	CParaFormat paraFormat;
	TParaFormatMask paraFormatMask;

	RichText()->GetParaFormatL(&paraFormat, paraFormatMask, 0, TextLength());
	paraFormatMask.SetAttrib(EAttLineSpacingControl);
	paraFormatMask.SetAttrib(EAttLineSpacing);
	paraFormatMask.SetAttrib(EAttAlignment);
	paraFormat.iLineSpacingControl = CParaFormat::ELineSpacingExactlyInTwips;
	paraFormat.iLineSpacingInTwips = 115;
	paraFormat.iHorizontalAlignment = CParaFormat::ELeftAlign;
	RichText()->ApplyParaFormatL(&paraFormat, paraFormatMask, 0, TextLength());
}

void OurOwnRichTextEditor::Reset()
{
	CALLSTACKITEM_N(_CL("OurOwnRichTextEditor"), _CL("Reset"));

	RichText()->Reset();
	TRAPD(err, RichText()->InsertL(0, *iDefaultValue));
}

void OurOwnRichTextEditor::PrepareForFocusGainL()
{
	CALLSTACKITEM_N(_CL("OurOwnRichTextEditor"), _CL("PrepareForFocusGainL"));

	/*const TDesC& desc = RichText()->Read(0, TextLength());
	RDebug::Print(desc);
	if (desc.Compare(*iDefaultValue) == 0) {
		TBool has_changed;
		SelectAllL();
		DeleteL(has_changed,Selection() , ETrue, EFalse);
		HandleTextChangedL();
	}*/
	SetCursorPosL(0, EFalse);
	SetCursorPosL(TextLength(), ETrue);

	//TRgb blue = TRgb(205,205,255);
	//OverrideColorL(EColorControlBackground, blue);
}

void OurOwnRichTextEditor::PrepareForFocusLossL()
{
	CALLSTACKITEM_N(_CL("OurOwnRichTextEditor"), _CL("PrepareForFocusLossL"));

	/*if (TextLength()==0) {
		RichText()->InsertL(0, *iDefaultValue);
		SetCursorPosL(TextLength(), EFalse);
		HandleTextChangedL();
	}*/
	//OverrideColorL(EColorControlBackground, KRgbWhite);
}