#include "ContextMediaAppView.h"
#include "ContextMediaAppAppUi.h"

#include <ContextMediaApp.rsg>
#include "ContextMediaApp.hrh"
#include <cntdb.h>
#include <aknpopup.h> 
#include <apgcli.h> 
#include <eikdll.h>

TBool AppExists(TUid aAppUid) 
{
	RApaLsSession appList;
	CleanupClosePushL(appList);

	User::LeaveIfError(appList.Connect());
	TApaAppInfo dummy;
	TInt ret = appList.GetAppInfo(dummy, aAppUid);
	CleanupStack::PopAndDestroy(); 
	return (ret==KErrNone);
}

//_-----------------------------------------------------


void CContextMediaAppThreadView::ConstructL()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("ConstructL"));

	iEngine=CPbkContactEngine::Static();
	if (iEngine) {
		owns_engine=false;
	} else {
		iEngine=CPbkContactEngine::NewL();
		owns_engine=true;
	}

	if (Id() == KThreadsByDatePromptId) {
		BaseConstructL( R_CONTEXTMEDIAAPP_THREADSPROMPT );
	} else if (Id() == KPostViewId) {
		BaseConstructL( R_CONTEXTMEDIAAPP_POSTVIEW);
        } else if (is_single_thread_view) {
                BaseConstructL( R_CONTEXTMEDIAAPP_THREADVIEW );
	} else {
		BaseConstructL( R_CONTEXTMEDIAAPP_THREADSVIEW );
	}
	
	iCameraAppFound=AppExists(KCameraUid);
	iCameraApp2Found=AppExists(KCamera2Uid);
	iVideoAppFound=AppExists(KVideoUid);
	iVideoApp2Found=AppExists(KVideo2Uid);
	iAudioAppFound=AppExists(KRecorderUid);
}

CContextMediaAppThreadView::~CContextMediaAppThreadView()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("~CContextMediaAppThreadView"));

	if ( iContainer ) AppUi()->RemoveFromViewStack( *this, iContainer );
	delete iContainer;
	if (owns_engine) delete iEngine;
}

TUid CContextMediaAppThreadView::Id() const
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("Id"));

	return iViewId;
}

void CContextMediaAppThreadView::HandleCommandL(TInt aCommand)
{   
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("HandleCommandL"));

	CAknViewAppUi * appui = (CAknViewAppUi *)AppUi();

	/* Normal use of view */
	if (this->iCallBack == 0) {
		switch ( aCommand )
		{
			case EAknSoftkeyBack:{
				if (is_single_thread_view) {
					AppUi()->ActivateViewL(iPrevViewId);
				} else {
					AppUi()->HandleCommandL( aCommand );
				}
				break;
			}
			case EcontextmediaappCmdReFetch:{
				CCMPost * aPost = iContainer->get_current_post();
				if (aPost) {
					aPost->iMediaFileName().Zero();
					aPost->iErrorCode() = 0;
					aPost->iErrorDescr().Zero();
					TRAPD(ignore, iStorage.UpdatePostL(aPost));// save post to storage
					iCMNetwork.FetchMedia(aPost, ETrue /*force refetch*/);
					((CContextMediaAppPostContainer*)iContainer)->display_current();
				}
				break;
			}
			case EcontextmediaappCmdHide:{
				CCMPost * aPost = iContainer->get_current_post();
				if (aPost) {
					TInt idx = iContainer->get_current_idx();
					TInt top = iContainer->get_top_idx();
					//TInt count = iContainer->get_item_count();
                                        iStorage.SetThreadVisibleL(aPost->iPostId(), EFalse);
					top--; if (top<0) top=0;
					idx--; if (idx<0) idx=0;
					iContainer->set_top_idx(top);
					iContainer->set_current_idx(idx);
				}
				break;
			}

			case EcontextmediaappCmdUnhideAll:{
				iStorage.SetAllThreadsVisibleL();
				break;
			}

			case EcontextmediaappCmdOpenItem:{
				CCMPost * aPost = iContainer->get_current_post();
				if (aPost && iNextViewId.iUid) {
					CContextMediaAppThreadView * view = (CContextMediaAppThreadView *)(appui->View(iNextViewId));
					view->SetNodeId(aPost->iPostId());
					if (aPost->iParentId() == iStorage.RootId() ) { 
						//FIX ME: performance pb, we shouldn't fetch each time
						//iCMNetwork.FetchThread(aPost->iPostId());
					}
					AppUi()->ActivateLocalViewL(view->Id());
				}
				break;
			}
			case EcontextmediaappCmdRefresh:{
				if (iNode!=CPostStorage::RootId()) {
					iCMNetwork.FetchThread(iNode);
				} else {
					iCMNetwork.FetchThreads();
				}
				break;
			}

			case EcontextmediaappCmdMarkAsRead:{
				iContainer->mark_as_read();
				break;
			}

			case EcontextmediaappCmdFirstPost:
			case EcontextmediaappCmdReply:{
				auto_ptr<CEikTextListBox> list (new(ELeave) CAknSinglePopupMenuStyleListBox);
				CAknPopupList * popupList = CAknPopupList::NewL(list.get(), R_AVKON_SOFTKEYS_OK_BACK, AknPopupLayouts::EMenuWindow);
				CleanupStack::PushL(popupList);

				list->ConstructL(popupList, CEikListBox::ELeftDownInViewRect);
				list->CreateScrollBarFrameL(ETrue);
				list->ScrollBarFrame()->SetScrollBarVisibilityL(CEikScrollBarFrame::EOff, CEikScrollBarFrame::EAuto);

				auto_ptr<CArrayFixFlat<TInt> > commands (new (ELeave) CArrayFixFlat<TInt>(5));
				auto_ptr<CDesCArrayFlat> items (new (ELeave) CDesCArrayFlat(5));
				
				if (iStorage.FirstL(CPostStorage::MediaPoolId(), CPostStorage::EByDate, CPostStorage::EDescending, ETrue)) {
					TBuf<50> buf;
					iCoeEnv->ReadResource(buf, R_CAPTURED);
					items->AppendL(buf);
					commands->AppendL(EcontextmediaappCmdReplyWithCaptured);
				}
	                        
				if (iCameraAppFound) {
					TBuf<50> buf;
					iCoeEnv->ReadResource(buf, R_CAMERA);
					items->AppendL(buf);
					commands->AppendL(EcontextmediaappCmdCamera);
				}

				if (iCameraApp2Found) {
					TBuf<50> buf;
					iCoeEnv->ReadResource(buf, R_CAMERA);
					items->AppendL(buf);
					commands->AppendL(EcontextmediaappCmdCamera2);
				}

				if (iVideoAppFound) {
					TBuf<50> buf;
					iCoeEnv->ReadResource(buf, R_VIDEO);
					items->AppendL(buf);
					commands->AppendL(EcontextmediaappCmdVideo);
				}

				if (iVideoApp2Found) {
					TBuf<50> buf;
					iCoeEnv->ReadResource(buf, R_VIDEO);
					items->AppendL(buf);
					commands->AppendL(EcontextmediaappCmdVideo2);
				}

				if (iAudioAppFound) {
					TBuf<50> buf;
					iCoeEnv->ReadResource(buf, R_AUDIO);
					items->AppendL(buf);
					commands->AppendL(EcontextmediaappCmdAudio);
				}

				CTextListBoxModel* model = list->Model();
				model->SetItemTextArray(items.release());
				model->SetOwnershipType(ELbmOwnsItemArray);

				TBuf<50> title;
				iCoeEnv->ReadResource(title, R_REPLY);
				popupList->SetTitleL(title);

				
				TInt popupOk = popupList->ExecuteLD();
				CleanupStack::Pop();
				if (popupOk) {
					TInt index = list->CurrentItemIndex();
					HandleCommandL(commands->At(index));
				}
				break;
			}

			case EcontextmediaappCmdReplyWithCaptured: {
				CContextMediaEditorView * view = (CContextMediaEditorView*)(appui->View(KEditorViewId));
				if (Id() == KPostViewId) {
					CCMPost * aPost = iContainer->get_current_post();
					if (aPost) view->SetThreadTarget(aPost->iParentId());
				} else {
					view->SetThreadTarget(iNode);
				}
				AppUi()->ActivateLocalViewL(view->Id());
				break;
			}
			case EcontextmediaappCmdCamera:{
				CContextMediaEditorView * view = (CContextMediaEditorView*)(appui->View(KEditorViewId));
				if (Id() == KPostViewId) {
					CCMPost * aPost = iContainer->get_current_post();
					if (aPost) view->SetThreadTarget(aPost->iParentId());
				} else {
					view->SetThreadTarget(iNode);
				}
				ActivateViewL(TVwsViewId(KCameraUid, KCameraViewUid));
				break;
			}
		        case EcontextmediaappCmdCamera2:{
				CContextMediaEditorView * view = (CContextMediaEditorView*)(appui->View(KEditorViewId));
				if (Id() == KPostViewId) {
					CCMPost * aPost = iContainer->get_current_post();
					if (aPost) view->SetThreadTarget(aPost->iParentId());
				} else {
					view->SetThreadTarget(iNode);
				}
				ActivateViewL(TVwsViewId(KCamera2Uid, KCamera2ViewUid));
				break;
			}
			case EcontextmediaappCmdVideo:{
				CContextMediaEditorView * view = (CContextMediaEditorView*)(appui->View(KEditorViewId));
				if (Id() == KPostViewId) {
					CCMPost * aPost = iContainer->get_current_post();
					if (aPost) view->SetThreadTarget(aPost->iParentId());
				} else {
					view->SetThreadTarget(iNode);
				}
				ActivateViewL(TVwsViewId(KVideoUid, KVideoViewUid));
				break;
			}
		      case EcontextmediaappCmdVideo2:{
				CContextMediaEditorView * view = (CContextMediaEditorView*)(appui->View(KEditorViewId));
				if (Id() == KPostViewId) {
					CCMPost * aPost = iContainer->get_current_post();
					if (aPost) view->SetThreadTarget(aPost->iParentId());
				} else {
					view->SetThreadTarget(iNode);
				}
				ActivateViewL(TVwsViewId(KVideo2Uid, KVideo2ViewUid));
				break;
			}
			case EcontextmediaappCmdAudio:{
				CContextMediaEditorView * view = (CContextMediaEditorView*)(appui->View(KEditorViewId));
				if (Id() == KPostViewId) {
					CCMPost * aPost = iContainer->get_current_post();
					if (aPost) view->SetThreadTarget(aPost->iParentId());
				} else {
					view->SetThreadTarget(iNode);
				}
				//ActivateViewL(TVwsViewId(KRecorderUid, KRecorderViewUid), KRecorderMessageUid, KNullDesC8);
				auto_ptr<CApaCommandLine> cmd(CApaCommandLine::NewL(_L("z:\\system\\apps\\voicerecorder\\voicerecorder.app")));
				cmd->SetCommandL(EApaCommandRun);
				TRAPD(err, EikDll::StartAppL(*cmd));
				break;
			}

			case EcontextmediaappCmdCall: {
				CCMPost * aPost = iContainer->get_current_post();
				if (aPost && aPost->iSender.iPhoneNo().Length()>0) {
					TRAPD(err, iPhoneHelper.make_callL(aPost->iSender.iPhoneNo()));
				}
				break;
			}

			case EcontextmediaappCmdSms: {
				CCMPost * aPost = iContainer->get_current_post();
				if (aPost && aPost->iSender.iPhoneNo().Length()>0) {
					CDesCArrayFlat* recip=new CDesCArrayFlat(1);
					CleanupStack::PushL(recip);
					
					CDesCArrayFlat* alias=new CDesCArrayFlat(1);
					CleanupStack::PushL(alias);
					
					recip->AppendL(aPost->iSender.iPhoneNo());
					alias->AppendL(aPost->iSender.iName());
					
					iPhoneHelper.send_sms(recip, alias);

					CleanupStack::PopAndDestroy(2); // recip, alias, title
				}
				break;
			}
			case EcontextmediaappCmdPlay: 
				{
					CContextMediaAppPostContainer * c = (CContextMediaAppPostContainer*)iContainer;
					if ( ((c->iMediaFileType==CContextMediaAppPostContainer::EAudio) && iAudioAppFound) || ((c->iMediaFileType==CContextMediaAppPostContainer::EVideo) && iVideoAppFound) ) {
						c->Play();
					} else {
						//FIX ME: Message here
					}
				}
				break;
			case EcontextmediaappCmdContinue: 
				((CContextMediaAppPostContainer*)iContainer)->Resume();
				break;
			case EcontextmediaappCmdStop: 
				((CContextMediaAppPostContainer*)iContainer)->Stop();
				break;
			case EcontextmediaappCmdPause: 
				((CContextMediaAppPostContainer*)iContainer)->Pause();
				break;
			default: {
				AppUi()->HandleCommandL( aCommand );
				break;
			}
		 }
	} else {
		MUploadCallBack* cb=iCallBack;
		iCallBack=0;
		/* Prompt use of the view */
		switch ( aCommand )
		{
			case EAknSoftkeyCancel:
				cb->Back(false, false, 0);
				break;
			case EcontextmediaappCmdOpenItem:
			case EAknSoftkeySelect: {
				CCMPost * aPost = iContainer->get_current_post();
				if (aPost) {
					auto_ptr<CCMPost> buf(CCMPost::NewL(0));
					buf->iParentId()=aPost->iPostId();
					cb->Back(true, true, buf.get());
				} else {
					if (iVisualPrompt) {
						iVisualPrompt->Prompt(KNullDesC, cb);
					} else {
						cb->Back(false, false, 0);
					}
				}
				break;
			}
			default:
				break;
		}
	}
}

void CContextMediaAppThreadView::HandleClientRectChange()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("HandleClientRectChange"));

	if ( iContainer ) iContainer->SetRect(ClientRect());
}

void CContextMediaAppThreadView::DynInitMenuPaneL(TInt aResourceId, CEikMenuPane* aMenuPane)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("DynInitMenuPaneL"));

	const CCMPost * aPost = iContainer->get_current_post();
	TBool is_placeholder=EFalse;
	if (aPost) {
		TRAPD(ignore, is_placeholder=iStorage.IsPlaceHolderL(aPost->iPostId()));
	}

	//multi-thread view menu
	if (aResourceId == R_CONTEXTMEDIA_THREADS_PANE) {
		if (aPost ) {
			aMenuPane->SetItemDimmed(EcontextmediaappCmdOpenItem, is_placeholder);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdRefresh, EFalse);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdHide, is_placeholder);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdMarkAsRead, !(aPost->iUnreadCounter()>0));
			aMenuPane->SetItemDimmed(EcontextmediaappCmdUnhideAll, !iStorage.HasHiddenThreads());
		} else {
			aMenuPane->SetItemDimmed(EcontextmediaappCmdOpenItem, ETrue);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdMarkAsRead, ETrue);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdRefresh, ETrue);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdHide, ETrue);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdUnhideAll, ETrue);
		}
	} else if (aResourceId == R_CONTEXTMEDIA_THREAD_PANE) {
		// 1-thread view menu
		
		aMenuPane->SetItemDimmed(EcontextmediaappCmdRefresh, EFalse);
		if (iContainer->get_item_count() == 1) {
			aMenuPane->SetItemDimmed(EcontextmediaappCmdFirstPost, EFalse);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdReply, ETrue);
		} else {
			aMenuPane->SetItemDimmed(EcontextmediaappCmdFirstPost, ETrue);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdReply, EFalse);
		}

		if (aPost) {
			aMenuPane->SetItemDimmed(EcontextmediaappCmdOpenItem, EFalse);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdMarkAsRead, !(aPost->iUnreadCounter()>0));
			aMenuPane->SetItemDimmed(EcontextmediaappCmdContact, !IsKnownContact(aPost->iSender.iPhoneNo()));
		} else {
			aMenuPane->SetItemDimmed(EcontextmediaappCmdOpenItem, ETrue);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdMarkAsRead, ETrue);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdContact, ETrue);
		}
	} else if (aResourceId == R_CONTEXTMEDIA_MENUBAR_POST_MENU) {
		if (aPost) {
			aMenuPane->SetItemDimmed(EcontextmediaappCmdReFetch, (aPost->iErrorCode()==KErrNone));
			aMenuPane->SetItemDimmed(EcontextmediaappCmdPlay, !iContainer->IsCurrentPlayableMedia());
			aMenuPane->SetItemDimmed(EcontextmediaappCmdContact, !IsKnownContact(aPost->iSender.iPhoneNo()));
			aMenuPane->SetItemDimmed(EcontextmediaappCmdMarkAsRead, !(aPost->iUnreadCounter()>0));
		} else {
			aMenuPane->SetItemDimmed(EcontextmediaappCmdReFetch, ETrue);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdPlay, ETrue);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdContact, ETrue);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdMarkAsRead, ETrue);
		}
	} else if (aResourceId == R_REPLY_MENU) {
		if (!iStorage.FirstL(CPostStorage::MediaPoolId(), 
			CPostStorage::EByDate, CPostStorage::EDescending, ETrue)) aMenuPane->SetItemDimmed(EcontextmediaappCmdReplyWithCaptured, ETrue);
		if (!iCameraAppFound) aMenuPane->SetItemDimmed(EcontextmediaappCmdCamera, ETrue);
		if (!iCameraApp2Found) aMenuPane->SetItemDimmed(EcontextmediaappCmdCamera2, ETrue);
		if (!iVideoAppFound) aMenuPane->SetItemDimmed(EcontextmediaappCmdVideo, ETrue);
		if (!iVideoApp2Found) aMenuPane->SetItemDimmed(EcontextmediaappCmdVideo2, ETrue);
		if (!iAudioAppFound) aMenuPane->SetItemDimmed(EcontextmediaappCmdAudio, ETrue);
	} 
}


void CContextMediaAppThreadView::DoActivateL(
   const TVwsViewId& aPrevViewId,TUid aCustomMessageId,
   const TDesC8& aCustomMessage)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("DoActivateL"));

      	if (Id() != KThreadsByDatePromptId){
		CContextMediaEditorView * view = (CContextMediaEditorView*)(AppUi()->View(KEditorViewId));
		view->ResetThreadTarget();
		((CContextMediaAppAppUi*)AppUi())->iLastViewBeforePrompt=Id();
	}
		
	StatusPane()->MakeVisible(!is_full_screen);
	TRect r = ClientRect();

	// managing previous view
	if ( (aPrevViewId.iAppUid==KUidContextMediaApp)  // remember previous view from same app only
		&& (aPrevViewId.iViewUid != KEditorViewId) // for prompt
		&& (aPrevViewId.iViewUid != KThreadsByDatePromptId)
		&& (aPrevViewId.iViewUid != KPostViewId))
	{
		iPrevViewId = aPrevViewId;
	}
		
	// managing previous indices
	if (aPrevViewId.iViewUid == KThreadViewId) {
		if (Id()==KPostViewId) iCurrentIndex=iTopIndex=0;
	} else if (aPrevViewId.iViewUid == KPostViewId) {
	} else if (aPrevViewId.iViewUid == KVisualCodeViewId) {
	} else {
		iCurrentIndex=iTopIndex=0;
	}

	if (Id() != KThreadsByDatePromptId) {
		TVwsViewId v = ((CContextMediaAppAppUi*)AppUi())->iNextView;
		if ( v != TVwsViewId()) {
			if (v.iAppUid == KCameraUid) {
				TRAPD(err, ActivateViewL(TVwsViewId(KCameraUid, KCameraViewUid)));
			} else if (v.iAppUid == KVideoUid) {
				TRAPD(err, ActivateViewL(TVwsViewId(KVideoUid, KVideoViewUid)));
			} else if (v.iAppUid == KRecorderUid) {
				auto_ptr<CApaCommandLine> cmd(CApaCommandLine::NewL(_L("z:\\system\\apps\\voicerecorder\\voicerecorder.app")));
				cmd->SetCommandL(EApaCommandRun);
				TRAPD(err, EikDll::StartAppL(*cmd));			
			} else {
				TRAPD(err, ActivateViewL(((CContextMediaAppAppUi*)AppUi())->iNextView, aCustomMessageId, aCustomMessage));
			}
			((CContextMediaAppAppUi*)AppUi())->iNextView=TVwsViewId();
		}
	} 

	// Normal display        
	((CContextMediaAppAppUi*)AppUi())->SetTab(Id().iUid);  // it's safe even if no tab

        if (Id() == KPostViewId) {
		if (!iContainer) {
			iContainer = new (ELeave) CContextMediaAppPostContainer(iCMNetwork, iStorage, iNode, iSort, iOrder, this);
			iContainer->SetMopParent(this);
			iContainer->ConstructL( r );
			AppUi()->AddToStackL( *this, iContainer);
		}
	} else {
		if (!iContainer) {
			iContainer = new (ELeave) CContextMediaAppListboxContainer(iCMNetwork, iStorage, iNode, iSort, iOrder, this);
			iContainer->SetMopParent(this);
			iContainer->ConstructL( r );
			iContainer->set_top_idx(iTopIndex);
			iContainer->set_current_idx(iCurrentIndex);
			AppUi()->AddToStackL( *this, iContainer);
		}
		iContainer->DrawNow();
	}
	
	/*if (Id() != KThreadsByDatePromptId) {
		TVwsViewId v = ((CContextMediaAppAppUi*)AppUi())->iNextView;
		if ( v != TVwsViewId()) {
			if (v.iAppUid == KCameraUid) {
				ActivateViewL(TVwsViewId(KCameraUid, KCameraViewUid));
			} else if (v.iAppUid == KVideoUid) {
				ActivateViewL(TVwsViewId(KVideoUid, KVideoViewUid));
			} else if (v.iAppUid == KRecorderUid) {
				ActivateViewL(TVwsViewId(KRecorderUid, KRecorderViewUid));
			} else {
				TRAPD(err, ActivateViewL(((CContextMediaAppAppUi*)AppUi())->iNextView, aCustomMessageId, aCustomMessage));
			}
			((CContextMediaAppAppUi*)AppUi())->iNextView=TVwsViewId();
		}
	} */

	//AppUi()->AddToStackL( *this, iContainer);
}

void CContextMediaAppThreadView::DoDeactivate()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("DoDeactivate"));

	if ( iContainer ) {
		iCurrentIndex = iContainer->get_current_idx();
		iTopIndex = iContainer->get_top_idx();
		AppUi()->RemoveFromViewStack( *this, iContainer );
		iContainer->MakeVisible(EFalse);
        }
    	delete iContainer;
	iContainer = NULL;
}

void CContextMediaAppThreadView::SetNodeId(TInt64 aNode)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("SetNodeId"));

	iNode = aNode;
}

void CContextMediaAppThreadView::SetTopIndex(TInt idx)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("SetTopIndex"));

	iTopIndex = idx;
}

void CContextMediaAppThreadView::SetCurrentIndex(TInt idx)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("SetCurrentIndex"));

	iCurrentIndex = idx;
}

TBool CContextMediaAppThreadView::IsKnownContact(const TDesC& phone_number)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("IsKnownContact"));

	if (phone_number.Length() <=0) return EFalse;
	TInt nbDigits, phoneno, errorCode = 0;
	
	phoneno = iEngine->Database().TextToPhoneMatchNumber(iContainer->get_current_post()->iSender.iPhoneNo(), nbDigits, 8);
	if (phoneno == 0) return EFalse;
	CContactIdArray * matching_contact_ids = 0;	
	TRAP(errorCode, matching_contact_ids = iEngine->Database().MatchPhoneNumberL(phoneno) );
	
	TBool ret = ((errorCode!=KErrNotFound) && (matching_contact_ids->Count()>0));
	delete matching_contact_ids; matching_contact_ids=0;
	return ret;
}

TBool CContextMediaAppThreadView::IsSingleThreadView()
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("IsSingleThreadView"));

	return this->is_single_thread_view;
}

void CContextMediaAppThreadView::Prompt(const TDesC& /*FileName*/, MUploadCallBack* CallBack)
{
	CALLSTACKITEM_N(_CL("CContextMediaAppThreadView"), _CL("Prompt"));

	iCallBack = CallBack;
	
	AppUi()->ActivateLocalViewL(this->Id());
}

