#include  <aknviewappui.h>
#include  <avkon.hrh>
#include  <ContextMediaApp.rsg>
#include  "ContextMediaAppView2.h"
#include  "view_ids.h"
#include  "contextmediaapp.hrh"
#include  <eikdialg.h>
#include  "cl_settings.h"
#include  <flogger.h>
#include  "reporting.h"
#include  <eikmenup.h>
#include  <aknmessagequerydialog.h> 
#include  <sendui.h>
#include  "cm_sendui.h"
#include  <SENDNORM.RSG>

void CContextMediaEditorView::ConstructL()
{
	CALLSTACKITEM_N(_CL("CContextMediaEditorView"), _CL("ConstructL"));

	iOrder=CPostStorage::EDescending;
	iSort=CPostStorage::EByDate;
	iNode=CPostStorage::MediaPoolId();
	iSendUi = CSendAppUi::NewL(EcontextmediaappCmdSendAppUi, 0);

	BaseConstructL( R_CONTEXTMEDIAAPP_EDITORVIEW );
	ResetThreadTarget();
}

CContextMediaEditorView::~CContextMediaEditorView()
{
	CALLSTACKITEM_N(_CL("CContextMediaEditorView"), _CL("~CContextMediaEditorView"));

	if (iContainer) AppUi()->RemoveFromViewStack( *this, iContainer );
	delete iContainer;
	delete iSendUi;
}

TUid CContextMediaEditorView::Id() const
{
	CALLSTACKITEM_N(_CL("CContextMediaEditorView"), _CL("Id"));

	return iViewId;
}

void CContextMediaEditorView::HandleCommandL(TInt aCommand)
{   
	CALLSTACKITEM_N(_CL("CContextMediaEditorView"), _CL("HandleCommandL"));

	if (iContainer->IsLoadingMedia()) return;

	MUploadCallBack* cb=iCallBack; iCallBack=0; 
	TFileName f =iFileName; iFileName=KNullDesC;
	if (cb) {
		/* prompt mode */
		switch(aCommand) {
			case EcontextmediaappCmdPublish: {
				iContainer->save_contribution_to_post();
				CCMPost * aPost = iContainer->get_current_post();
				if (aPost) {
					if (iThreadTarget!=CPostStorage::MediaPoolId()) {
						aPost->iParentId() = iThreadTarget;
						ResetThreadTarget();
					}				
					iStorage.UpdatePostL(aPost); 
				}

				TBool del=ETrue;
				Settings().GetSettingL(SETTING_DELETE_UPLOADED, del);

				auto_ptr<CCMPost> buf(bb_cast<CCMPost>(iContainer->get_current_post()->CloneL(KNullDesC)));
				Reporting().DebugLog(_L("editor:call_back"));
				
				cb->Back(true, del, buf.get());
			}
			break;

			case EcontextmediaappCmdPlay: {
				CContextMediaAppPostContainer * c = (CContextMediaAppPostContainer*)iContainer;
				c->Play();
				// no real action, so we do:
				iCallBack=cb; 
				iFileName=f;
			}
			break;
		
			case EAknSoftkeyBack: 
			case EcontextmediaappCmdNewImage:
			case EcontextmediaappCmdPostpone: {
				ResetThreadTarget();
				iContainer->save_contribution_to_post(); // save fields to post
				CCMPost * aPost = iContainer->get_current_post();
				if (aPost) {
					iStorage.UpdatePostL(aPost); // save post to storage
					Reporting().DebugLog(_L("editor:call_cancel"));
					cb->Back(false, false, aPost);			
				}
			}
			break;

			case EcontextmediaappCmdDelete: {
				ResetThreadTarget();
				HBufC * message = CEikonEnv::Static()->AllocReadResourceLC(R_DELETE_MESSAGE);
				CAknMessageQueryDialog * dlg = CAknMessageQueryDialog::NewL(*message);
				CleanupStack::PushL(dlg);
				dlg->PrepareLC(R_CONFIRMATION_QUERY);
				CleanupStack::Pop(dlg);
				if ( dlg->RunLD() ) {
					CCMPost * aPost = iContainer->get_current_post();
					if (aPost) cb->Back(false, true, aPost);
				} else {
					// no action taken -> back to initial state before command
					iCallBack=cb; 
					iFileName=f;
				}
				CleanupStack::PopAndDestroy(); //message
			}
			break;

			case EAknSoftkeyCancel: {
				//ResetThreadTarget(); keep this commented out! 
				CCMPost * aPost = iContainer->get_current_post();
				if (aPost) cb->Back(false, true, aPost);
			}
			break;
			
			default:
				// no action taken, or outside command : restore callback and filename;
				iCallBack=cb; 
				iFileName=f;
				if ((aCommand > EcontextmediaappCmdSendAppUi) && (aCommand < EcontextmediaappCmdSendAppUi+5)) {
					iContainer->save_contribution_to_post();
					CCMPost * aPost = iContainer->get_current_post();
					if (! aPost) return;
					OpenPostInMessageEditorL(AppContext(),
						*iSendUi, *aPost,
						aCommand);
				} 
				return;
				break;
		}
		if (iNextViewId) {*iNextViewId=iPrevViewId;}
	} else {
		/*normal view mode*/
		switch(aCommand) {
			case EAknSoftkeySelect:
			case EcontextmediaappCmdPublish:
				{
					CCMPost * aPost = iContainer->get_current_post();
					if (aPost) {
						aPost->iParentId() = iThreadTarget;
						ResetThreadTarget();
						iContainer->save_contribution_to_post();
						TBool del=ETrue;
						Settings().GetSettingL(SETTING_DELETE_UPLOADED, del);
						TRAPD(err, iTransferer->AddFileToQueueL(aPost->iMediaUrl(), SETTING_PUBLISH_URLBASE, 
							SETTING_PUBLISH_SCRIPT, del, _L("dummy"), aPost));
						if (err!=KErrNone) User::Leave(err);
						
						auto_ptr<CAknGlobalNote> note (CAknGlobalNote::NewL());
						note->ShowNoteL (EAknGlobalConfirmationNote, _L("Queued for Publishing"));
						
						if (del) {
							iStorage.MarkAsRead(aPost);
							TRAPD(ignore, iStorage.RemovePostL(aPost));
						}
					}
				}
				break;
			case EAknSoftkeyBack:
			case EcontextmediaappCmdPostpone:
			case EAknSoftkeyCancel:
				{
					iContainer->save_contribution_to_post();
					CCMPost * aPost = iContainer->get_current_post();
					if (aPost) iStorage.UpdatePostL(aPost);// save post to storage
					ResetThreadTarget();
				}
				break;
			case EcontextmediaappCmdPlay:
				{
					CContextMediaAppPostContainer * c = (CContextMediaAppPostContainer*)iContainer;
					c->Play();
				}
				break;
			default:
				if (aCommand > EcontextmediaappCmdSendAppUi) {
					iContainer->save_contribution_to_post();
					CCMPost * aPost = iContainer->get_current_post();
					if (! aPost) return;
					OpenPostInMessageEditorL(AppContext(),
						*iSendUi, *aPost,
						aCommand);
				} 
				break;
		}
		AppUi()->ActivateViewL(iPrevViewId);
	}
}

void CContextMediaEditorView::HandleClientRectChange()
{
	CALLSTACKITEM_N(_CL("CContextMediaEditorView"), _CL("HandleClientRectChange"));

	if ( iContainer ) iContainer->SetRect( TRect(TPoint(0,0),TSize(176,188)) );
}


void CContextMediaEditorView::DoActivateL(const TVwsViewId& aPrevViewId, TUid, const TDesC8&)
{
	CALLSTACKITEM_N(_CL("CContextMediaEditorView"), _CL("DoActivateL"));

	StatusPane()->MakeVisible(EFalse);

	iMediaBrowsingOn=(iCallBack!=0);
	iPrevViewId = aPrevViewId;
	if (!iContainer) {
		TRect re = ClientRect();
		iContainer = new (ELeave) CContextMediaAppPostContainer(iCMNetwork, iStorage, iThreadTarget, iSort, iOrder, this, iFileName);
		iContainer->SetMopParent(this);
		iContainer->ConstructL(re);
		AppUi()->AddToStackL(*this, iContainer );
        }

	if (iCallBack!=0) {
		if ((iPrevViewId.iAppUid == KCameraUid) 
			|| (iPrevViewId.iAppUid == KVideoUid) 
			|| (iPrevViewId.iAppUid == KRecorderUid) ) {
                
			RWsSession ws;
			User::LeaveIfError( ws.Connect() );
			TApaTaskList taskList( ws );
			TApaTask task = taskList.FindApp(iPrevViewId.iAppUid);
			if(task.Exists()) task.KillTask();
			ws.Close();
		}
	}
}

void CContextMediaEditorView::DoDeactivate()
{
	CALLSTACKITEM_N(_CL("CContextMediaEditorView"), _CL("DoDeactivate"));

	if (iContainer) AppUi()->RemoveFromViewStack( *this, iContainer );
	delete iContainer;
	iContainer = NULL;
	if (iCallBack) iCallBack->Back(false, false, 0);
	iCallBack=0;
}

void CContextMediaEditorView::SetThreadTarget(TInt64 aCodeId)
{
	CALLSTACKITEM_N(_CL("CContextMediaEditorView"), _CL("SetThreadTarget"));

	iThreadTarget = aCodeId;
}

void CContextMediaEditorView::ResetThreadTarget()
{
	CALLSTACKITEM_N(_CL("CContextMediaEditorView"), _CL("ResetThreadTarget"));

	iThreadTarget = CPostStorage::MediaPoolId();;
}

void CContextMediaEditorView::Prompt(const TDesC& FileName, MUploadCallBack* CallBack)
{
	Reporting().DebugLog(_L("editor:prompt"));

	iCallBack = CallBack;
	iFileName=FileName;

	if (iContainer) {
		DoDeactivate();
		TUid dummy={0};
		DoActivateL(iPrevViewId, dummy, _L8(""));
	} else {
		AppUi()->ActivateLocalViewL(Id());
	}
}

void CContextMediaEditorView::DynInitMenuPaneL(TInt aResourceId, CEikMenuPane* aMenuPane)
{
	CALLSTACKITEM_N(_CL("CContextMediaEditorView"), _CL("DynInitMenuPaneL"));

	if (aResourceId == R_SENDUI_MENU) {
		iSendUi->DisplaySendCascadeMenuL(*aMenuPane);
	} else if (aResourceId == R_CONTEXTMEDIA_MENUBAR_EDITOR_MENUBAR_MENU) {
		
		CCMPost * aPost = iContainer->get_current_post();
		TInt size=0;
		TInt flags=TSendingCapabilities::ESupportsAttachmentsOrBodyText;
		if (aPost->iMediaFileName().Length()>0) {
			size=32*1024;
			flags|=TSendingCapabilities::ESupportsAttachments;
			//flags|=TSendingCapabilities::ESupportsAttachmentsOrBodyText;
		}
		TSendingCapabilities c( (*(aPost->iBodyText))().Length()+2+aPost->iSender.iName().Length(), 
			size, flags);
		
		if (iCallBack==0) {
			aMenuPane->SetItemDimmed(EcontextmediaappCmdPlay, !iContainer->IsCurrentPlayableMedia());
			aMenuPane->SetItemDimmed(EAknSoftkeySelect, EFalse);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdPublish, ETrue);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdDelete, ETrue); //FIXME: check this
			aMenuPane->SetItemDimmed(EcontextmediaappCmdNewImage, ETrue);
			iSendUi->DisplaySendMenuItemL(*aMenuPane, 1, c);
			
		} else {
			aMenuPane->SetItemDimmed(EcontextmediaappCmdPlay, !iContainer->IsCurrentPlayableMedia());
			aMenuPane->SetItemDimmed(EAknSoftkeySelect, ETrue);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdPublish, EFalse);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdDelete, EFalse);
			aMenuPane->SetItemDimmed(EcontextmediaappCmdNewImage, EFalse);
			iSendUi->DisplaySendMenuItemL(*aMenuPane, 4, c);
		}
	}
}
