#include "audioengine.h"
#include "app_context.h"

CAudioEngine* CAudioEngine::NewL()
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("NewL"));

	CAudioEngine* self = NewLC();
	CleanupStack::Pop(self);
	return self;
}

    
CAudioEngine* CAudioEngine::NewLC()
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("NewLC"));

	CAudioEngine* self = new (ELeave) CAudioEngine();
	CleanupStack::PushL(self);
	self->ConstructL();
	return self;
}

CAudioEngine::CAudioEngine()
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("CAudioEngine"));

}


CAudioEngine::~CAudioEngine()
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("~CAudioEngine"));

	delete iMediaFile;
	delete iMdaPlayer;    
	iMdaPlayer = NULL;
}


void CAudioEngine::ConstructL()
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("ConstructL"));

	iMediaFile = HBufC::NewL(0);
	iEngineState = EPNotInitialised; 
}

void CAudioEngine::SetNewFileL(const TDesC &aFileName)
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("SetNewFileL"));

	HBufC* newFile = aFileName.AllocL();
	delete iMediaFile;		 
	iMediaFile = newFile;
}

void CAudioEngine::InitControllerL( MPlayerUIControllerListener* aCallback )   
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("InitControllerL"));

	iEngineState = EPInitialising;
	iListener = aCallback;
    
	delete iMdaPlayer;
	iMdaPlayer = NULL;
	iMdaPlayer=CMdaAudioPlayerUtility::NewFilePlayerL(*iMediaFile,*this);
	iMdaPlayer->SetVolume(5);
}

void CAudioEngine::DoPlayL()
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("DoPlayL"));

	iMdaPlayer->Play();
	iEngineState = EPPlaying;
}


void CAudioEngine::DoStopL()
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("DoStopL"));

	iMdaPlayer->Stop();
	iEngineState = EPStopped;
	MapcPlayComplete(KErrNone);
}


void CAudioEngine::MapcInitComplete(TInt aError, const TTimeIntervalMicroSeconds& /*aDuration*/)
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("MapcInitComplete"));

	if (aError == KErrNone) {
		if ( iListener ) {TRAPD( ignore, iListener->InitControllerCompletedL( aError ) ); }
        } else {
		// acts as playing is over
		MapcPlayComplete(aError);
	}
}

void CAudioEngine::DoPauseL()
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("DoPauseL"));

	if ( iEngineState == EPPlaying ) {
		iMdaPlayer->Stop();
		iEngineState = EPPaused;
	}
}

void CAudioEngine::CloseController()
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("CloseController"));

	iListener=0;
	delete iMdaPlayer;
	iMdaPlayer = 0;
}

void CAudioEngine::MapcPlayComplete(TInt aError)
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("MapcPlayComplete"));

	iListener->PlayCompletedL(aError);
	iEngineState = EPStopped;
}

TInt CAudioEngine::GetEngineState()
{
	CALLSTACKITEM_N(_CL("CAudioEngine"), _CL("GetEngineState"));

	return iEngineState;
}

TInt CAudioEngine::IncreaseVolume()
{
	TInt vol=0;
	iMdaPlayer->GetVolume(vol);
	if ( vol< iMdaPlayer->MaxVolume()) {
		iMdaPlayer->SetVolume(++vol);
	}
	return vol;
}

TInt CAudioEngine::DecreaseVolume()
{
	TInt vol = 0;
	iMdaPlayer->GetVolume(vol);
	if ( vol> 0) {
		iMdaPlayer->SetVolume(--vol);
	}
	return vol;
}