#include "cm_oldprompt.h"
#include "cl_settings.h"
#include <fbs.h>


TCMOldPrompt::TCMOldPrompt(CPostStorage &aStorage, CCMNetwork &aNetwork) : iStorage(aStorage), iNetwork(aNetwork)
{
}

void TCMOldPrompt::Prompt(const TDesC& FileName, MUploadCallBack* CallBack)
{
	auto_ptr<CFbsBitmap> bm;
	auto_ptr<CCMPost> b(CCMPost::NewL(0));
	TFileOpStatus ret;
	TTime t; t=GetTime();

	b->iPostId() = CPostStorage::AddMeToMediaPoolId();
	b->iParentId() = CPostStorage::MediaPoolId();
	b->iMediaUrl() = FileName;

	TBuf<40> mime;
	GetMimeTypeL(FileName, mime);
	

	b->iContentType() = mime;
	b->iUnreadCounter() = 1;
	b->iTimeStamp() = t;

	TBuf<50> buf;
	if ( Settings().GetSettingL(SETTING_PUBLISH_AUTHOR, buf ) && buf.Length() != 0) {
		b->iSender.iName() = buf;
	}

	iStorage.AddLocalL(b.get(), bm);

	ret = CallBack->Back(false, false, b.get());
	
	TBool ok = iStorage.FirstL(CPostStorage::MediaPoolId(), CPostStorage::EByDate, CPostStorage::EDescending, EFalse);
	if (ok) {
		CCMPost * anotherPost = iStorage.GetCurrentL(0);
		if (ret.err == KErrNone) {
			anotherPost->iMediaUrl() = ret.fn;
			TRAPD(ignore, iStorage.UpdatePostL(anotherPost));
		}
		iNetwork.FetchMedia(anotherPost);
		iStorage.Release(anotherPost, 0);
	} 
}