#include "codeprompt.h"

#include "checkedactive.h"
#include <recognizerview.h>
#include "symbian_auto_ptr.h"
#include "cm_post.h"
#include "reporting.h"

class CVisualCodePromptImpl : public CVisualCodePrompt, public CCheckedActive, 
	public MRecognizerCallback, public MContextBase {
public:
	virtual ~CVisualCodePromptImpl();
private:
	CVisualCodePromptImpl(MApp_context& Context, 
		CAknViewAppUi *ViewAppUi, TUid LocalDefaultView, TVwsViewId* NextViewId);
	void ConstructL(TUid aViewId);

	virtual void Prompt(const TDesC& FileName, MUploadCallBack* CallBack);

	virtual void CodeSelected(const CCodeInfo& aCode);
	virtual void Cancelled();

	void Async();

	void CheckedRunL();
	void DoCancel();

	CRecognizerView*	iView;
	MUploadCallBack*	iCallBack;
	CAknViewAppUi		*iViewAppUi;
	TInt64			iCode;
	TBool			iGotCode;
	TUid			iDefaultView;
	TVwsViewId* iNextViewId;

	friend class CVisualCodePrompt;
};

CVisualCodePrompt* CVisualCodePrompt::NewL(MApp_context& Context, 
					   CAknViewAppUi *ViewAppUi, TUid aViewId, 
					   TUid LocalDefaultView, TVwsViewId* NextViewId)
{
	CALLSTACKITEM_N(_CL("CVisualCodePrompt"), _CL("NewL"));

	auto_ptr<CVisualCodePromptImpl> ret(new (ELeave) 
		CVisualCodePromptImpl(Context, ViewAppUi, LocalDefaultView, NextViewId));
	ret->ConstructL(aViewId);
	return ret.release();
}

CVisualCodePrompt::~CVisualCodePrompt()
{
	CALLSTACKITEM_N(_CL("CVisualCodePrompt"), _CL("~CVisualCodePrompt"));

}

CVisualCodePromptImpl::CVisualCodePromptImpl(MApp_context& Context,
					     CAknViewAppUi *ViewAppUi, 
					     TUid LocalDefaultView, TVwsViewId* NextViewId) : 
					CCheckedActive(EPriorityIdle, _L("CVisualCodePromptImpl")),
					MContextBase(Context),
					iViewAppUi(ViewAppUi), iDefaultView(LocalDefaultView), 
					iNextViewId(NextViewId)
{
	CALLSTACKITEM_N(_CL("CVisualCodePromptImpl"), _CL("CVisualCodePromptImpl"));

}

CVisualCodePromptImpl::~CVisualCodePromptImpl()
{
	CALLSTACKITEM_N(_CL("CVisualCodePromptImpl"), _CL("~CVisualCodePromptImpl"));

}

void CVisualCodePromptImpl::ConstructL(TUid aViewId)
{
	CALLSTACKITEM_N(_CL("CVisualCodePromptImpl"), _CL("ConstructL"));

//#ifdef USE_VISUALCODES
	iView=CRecognizerView::NewL(AppContext(), this, aViewId, iDefaultView, iNextViewId);
//#endif
	iViewAppUi->AddViewL(iView);

	CActiveScheduler::Add(this);
}

void CVisualCodePromptImpl::Prompt(const TDesC& /*FileName*/, MUploadCallBack* CallBack)
{
	CALLSTACKITEM_N(_CL("CVisualCodePromptImpl"), _CL("Prompt"));
	Reporting().DebugLog(_L("code:Prompt"));

	iCallBack=CallBack;
	iViewAppUi->ActivateLocalViewL(iView->Id());
}

void CVisualCodePromptImpl::CheckedRunL()
{
	CALLSTACKITEM_N(_CL("CVisualCodePromptImpl"), _CL("CheckedRunL"));
	Reporting().DebugLog(_L("code:CheckedRunL"));

	if (!iCallBack) return;

	MUploadCallBack* cb=iCallBack;
	iCallBack=0;
	if (!iGotCode) {
		cb->Back(false, false, 0);
	} else {

		auto_ptr<CCMPost> buf(CCMPost::NewL(0));

		buf->iParentId()=iCode;

		cb->Back(true, true, buf.get());
	}
}

void CVisualCodePromptImpl::CodeSelected(const CCodeInfo& aCode)
{
	CALLSTACKITEM_N(_CL("CVisualCodePromptImpl"), _CL("CodeSelected"));
	Reporting().DebugLog(_L("CodeSelected"));

//#ifdef USE_VISUALCODES
	iGotCode=ETrue;
	iCode=aCode.code->ToInt64();
//#endif
	Async();
}

void CVisualCodePromptImpl::Cancelled()
{
	CALLSTACKITEM_N(_CL("CVisualCodePromptImpl"), _CL("Cancelled"));

	iGotCode=EFalse;
	Async();
}

void CVisualCodePromptImpl::DoCancel()
{
	CALLSTACKITEM_N(_CL("CVisualCodePromptImpl"), _CL("DoCancel"));

	return;
}

void CVisualCodePromptImpl::Async()
{
	CALLSTACKITEM_N(_CL("CVisualCodePromptImpl"), _CL("Async"));

	if (IsActive()) return;

	TRequestStatus *s=&iStatus;
	User::RequestComplete(s, KErrNone);
	SetActive();
}