#include "medialistbox.h"
#include <eikfrlbd.h> 
#include <eikenv.h>
#include <aknviewappui.h> 
#include <aknutils.h>
#include <contextmediaapp.rsg>
#include <timeout.h>
#include <e32math.h>
#include <bautils.h>
#include <contextmedia.rsg>

void GetTimeString(TTime t, TDes& aBuf)
{
	TBuf<5> time; 
	TTime now; now=GetTime();
	if ((now.DateTime().Year()==t.DateTime().Year()) 
	   && (now.DateTime().Month()==t.DateTime().Month())
	   && (now.DateTime().Day()==t.DateTime().Day()) ) {
		
		t.FormatL(time, _L("%F%H:%T"));
	} else {
		t.FormatL(time, _L("%F%D/%M"));
	}
	aBuf.Copy(time);
}


class CContextMediaArrayImpl : public CContextMediaArray {
public:
	CContextMediaArrayImpl(CCMNetwork &aNetwork, CPostStorage &aStorage, TInt64 aNode, CPostStorage::TSortBy aSort, 
		CPostStorage::TOrder aOrder, MPostNotify& aObserver, TAdditionalItem aItem);
	void ConstructL();
	~CContextMediaArrayImpl();
private:
	virtual CCMPost*  GetPostAt(TInt aIndex);
private:
	void ReadFromStorage();
	void ReleasePosts();
	virtual TInt MdcaCount() const;
	virtual TPtrC16 MdcaPoint(TInt aIndex) const;

private:
	virtual void PostEvent(CCMPost* aParent, CCMPost* aChild, TEvent aEvent);
public:
	CArrayFixFlat<CCMPost*>* iPostArray;
	CArrayFixFlat<TInt64>* iPostIdArray;
	CCMPost*		iParentPost;
private:
	CPostStorage	&iStorage;
	CCMNetwork	&iNetwork;
	TInt64 iNode;
	CPostStorage::TSortBy iSort;
	CPostStorage::TOrder iOrder;

	HBufC * iBuf;
	MPostNotify& iObserver;

	HBufC * iBy;
	HBufC * iFirstBy;
	HBufC * iLastBy;

	HBufC * iNoTitle;
	HBufC * iNewThread;
	HBufC * iUseCode;
	HBufC * iAddReply;
	HBufC * iFirstPost;
	HBufC * iLoading;
	HBufC * iError;
	TAdditionalItem iItem;
	TInt	iResource;

};

CCMPost*  CContextMediaArrayImpl::GetPostAt(TInt aIndex)
{
	CALLSTACKITEM_N(_CL("CContextMediaArrayImpl"), _CL("GetPostAt"));

	if (aIndex<0) return 0;
	if ((iItem!=ENone) && (aIndex==0)) return 0;

	if (iOrder==CPostStorage::EDescending) {
		aIndex=MdcaCount()-aIndex-1;
	}

	if (!iPostArray->At(aIndex)) {
		iPostArray->At(aIndex)=iStorage.GetByPostIdL(0, iPostIdArray->At(aIndex));
	}

	return iPostArray->At(aIndex);
}

CContextMediaArray* CContextMediaArray::NewL(CCMNetwork &aNetwork, CPostStorage &aStorage, TInt64 aNode, 
					     CPostStorage::TSortBy aSort, 
					     CPostStorage::TOrder aOrder,
					     MPostNotify& aObserver, TAdditionalItem aItem)
{
	CALLSTACKITEM_N(_CL("CPostStorage"), _CL("TOrder"));

	CContextMediaArrayImpl * ret=new (ELeave) 
		CContextMediaArrayImpl(aNetwork, aStorage, aNode, aSort, aOrder, aObserver, aItem);
	CleanupStack::PushL(ret);
	ret->ConstructL();
	CleanupStack::Pop();
	return ret;
}

CContextMediaArrayImpl::CContextMediaArrayImpl( CCMNetwork &aNetwork,
						CPostStorage&aStorage, 
					       TInt64 aNode, CPostStorage::TSortBy aSort, 
					       CPostStorage::TOrder aOrder,
					       MPostNotify& aObserver, TAdditionalItem aItem) : 
	iNetwork(aNetwork), iStorage(aStorage), iNode(aNode), iSort(aSort), iOrder(aOrder), iObserver(aObserver), iItem(aItem)
{
	CALLSTACKITEM_N(_CL("CPostStorage"), _CL("TOrder"));

}

void CContextMediaArrayImpl::ReleasePosts()
{
	if (iPostArray) {
		int i;
		for (i=0;i<iPostArray->Count();i++) {
			CCMPost * aPost = (*iPostArray)[i];
			if (aPost) {
				TRAPD(err, iStorage.Release( aPost, 0 ));
			}
		}
	}
}

CContextMediaArrayImpl::~CContextMediaArrayImpl()
{
	CALLSTACKITEM_N(_CL("CContextMediaArrayImpl"), _CL("~CContextMediaArrayImpl"));

	if (iResource) CEikonEnv::Static()->DeleteResourceFile(iResource);

	ReleasePosts();
	if (iParentPost) iStorage.Release(iParentPost, this);
	delete iPostIdArray;
	delete iPostArray;
	delete iBuf;
	delete iNoTitle;
	
	delete iBy;
	delete iFirstBy;
	delete iLastBy;

	delete iNewThread;
	delete iLoading;
	delete iError;
	delete iUseCode;
	delete iAddReply;
	delete iFirstPost;
}

void CContextMediaArrayImpl::ReadFromStorage()
{
	iPostIdArray->Reset();
	ReleasePosts();
	iPostArray->Reset();

	TBool ok = iStorage.FirstL(iNode, iSort, CPostStorage::EAscending, EFalse);
	while (ok) {
		TInt64 id = iStorage.GetCurrentIdL();
		iPostIdArray->AppendL(id);
		iPostArray->AppendL(0);
		ok = iStorage.NextL();
	}
}

void CContextMediaArrayImpl::ConstructL()
{
	CALLSTACKITEM_N(_CL("CContextMediaArrayImpl"), _CL("ConstructL"));

#ifndef __WINS__
	TFileName resfile=_L("c:\\System\\data\\contextmedia.rsc");
	if (! BaflUtils::FileExists(CEikonEnv::Static()->FsSession(), resfile) ) {
		resfile.Replace(0, 1, _L("e"));
	}
#else
	TFileName resfile=_L("z:\\System\\data\\contextmedia.rsc");
	BaflUtils::NearestLanguageFile(CEikonEnv::Static()->FsSession(), resfile); //for localization
#endif
	TRAPD(err, iResource=CEikonEnv::Static()->AddResourceFileL(resfile));
	User::LeaveIfError(err);

	iBuf = HBufC::NewL(256);
	iBy = CEikonEnv::Static()->AllocReadResourceL(R_BY);
	iFirstBy = CEikonEnv::Static()->AllocReadResourceL(R_FIRST_BY);
	iLastBy = CEikonEnv::Static()->AllocReadResourceL(R_LAST_BY);
	iNoTitle = CEikonEnv::Static()->AllocReadResourceL(R_NO_TITLE);

	iUseCode =CEikonEnv::Static()->AllocReadResourceL(R_USE_CODE);
	iAddReply =CEikonEnv::Static()->AllocReadResourceL(R_ADD_REPLY);
	iFirstPost =CEikonEnv::Static()->AllocReadResourceL(R_FIRST_POST);

	iLoading=CEikonEnv::Static()->AllocReadResourceL(R_LOADING_TITLE);
	iError=CEikonEnv::Static()->AllocReadResourceL(R_ERROR_TITLE);
	iNewThread=CEikonEnv::Static()->AllocReadResourceL(R_NEW_THREAD_TITLE);
	//iNewThread =CEikonEnv::Static()->AllocReadResourceL(R_NEW_THREAD);

	iPostArray = new (ELeave) CArrayFixFlat<CCMPost*>(50);
	iPostIdArray = new (ELeave) CArrayFixFlat<TInt64>(50);

	iParentPost = iStorage.GetByPostIdL(this, iNode);
        
	ReadFromStorage();

}

TInt CContextMediaArrayImpl::MdcaCount() const
{
	CALLSTACKITEM_N(_CL("CContextMediaArrayImpl"), _CL("MdcaCount"));

	if (iItem == ENone) {
		return iPostArray->Count();
	} else {
		return iPostArray->Count()+1;
	}
}

TPtrC16 CContextMediaArrayImpl::MdcaPoint(TInt aIndex) const
{
	CALLSTACKITEM_N(_CL("CContextMediaArrayImpl"), _CL("MdcaPoint"));

	if (aIndex>iPostArray->Count()) {
		User::Leave(KErrArgument);
	}
	
	// ----- case first item in list ---------
	if (aIndex == 0) {
		if (iItem == EUseVCode) {
			iBuf->Des().Zero();
			iBuf->Des().AppendFormat(_L("%d\t"), KUseCodeIconIndex);
			iBuf->Des().Append(*iUseCode);
			iBuf->Des().Append(_L("\t\t\t"));
			return iBuf->Des();
		} else if (iItem == EAddReply) {
			iBuf->Des().Zero();
			if (iPostArray->Count()==0) {
				iBuf->Des().AppendFormat(_L("%d\t"), KReplyIconIndex);
				iBuf->Des().Append(*iFirstPost);
				iBuf->Des().Append(_L("\t\t\t"));
			} else {
				iBuf->Des().AppendFormat(_L("%d\t"), KReplyIconIndex);
				iBuf->Des().Append(*iAddReply);
				iBuf->Des().Append(_L("\t\t\t"));
			}
			return iBuf->Des();
		}
	}

	// ---- normal case --------------------
	if (iOrder==CPostStorage::EDescending) {
		aIndex=MdcaCount()-aIndex-1;
	}

	if (iPostArray->At(aIndex) == 0) {
		iPostArray->At(aIndex) = iStorage.GetByPostIdL(0, iPostIdArray->At(aIndex));
	}
	
	iBuf->Des().Zero();
	const CCMPost * aPost = (*iPostArray)[aIndex];

	TInt iconidx=aPost->GetThumbnailIndex();
	if (iconidx<0) User::Panic(_L("ContextMediaApp"), 1);
	
	if (aPost->iBodyText->Value().Compare(*iLoading) == 0) {
		iconidx = KUnknownIconIndex;
	} else if (aPost->iBodyText->Value().Compare(*iError)==0) {
		iconidx=KErrorIconIndex;
	}

// First Line of the list box: icon_id, title, nb_unread
	iBuf->Des().AppendFormat(_L("%d\t"), iconidx);

	// Loading indicator for thread ...
	TInt64 id = iPostIdArray->At(aIndex);
	TBool loading = ( (iNode == CPostStorage::RootId()) && 
		( (iNetwork.GetFetchStatus(id)==MNetworkStatus::EConnecting) ||
		(iNetwork.GetFetchStatus(id)==MNetworkStatus::EFetching) ) );

	if (loading) {
		if (aPost->iBodyText->Value().Length() == 0) {
			iBuf->Des().Append(*iNoTitle);
		} else {
			iBuf->Des().Append(aPost->iBodyText->Value().Left(15));
		}
		TTime now; now=GetTime(); 
		TInt sec = now.DateTime().Second();
		TInt dots = 6;
		TInt nb_dots = sec - ( dots*int(sec/dots));
		for (int i=0; i<=nb_dots; i++) {
			iBuf->Des().Append(_L("."));
		}
		iObserver.PostEvent(0, 0, EPostUpdated);
	} else {
		if (aPost->iBodyText->Value().Length() == 0) {
			iBuf->Des().Append(*iNoTitle);
		} else {
			iBuf->Des().Append(aPost->iBodyText->Value().Left(40));
		}
	}

	iBuf->Des().Append(_L("\t"));
	TInt unread = aPost->iUnreadCounter();
	if (unread==0) {
		iBuf->Des().AppendFormat(_L("\t"));
	} else  {
		iBuf->Des().AppendFormat(_L("%d\t"), unread );
        }

// Second and third Lines of the listbox
	if (aPost->iSender.iName().Compare(_L("?")) == 0) {
		iBuf->Des().Append(_L(" \t \t \t"));
	} else {
		if (iNode==CPostStorage::RootId()) {
			// second line
			iBuf->Des().Append(*iFirstBy);
			iBuf->Des().Append(_L(" "));
			iBuf->Des().Append(aPost->iSender.iName());
			iBuf->Des().Append(_L(",\t"));
			TBuf<5> time; GetTimeString(aPost->iTimeStamp(), time);
			iBuf->Des().Append(time);
			//third line
			if (aPost->LastPostAuthor().Length()==0)  {
				iBuf->Des().Append(_L("\t\t"));
			} else {
				iBuf->Des().Append(_L("\t"));
				iBuf->Des().Append(*iLastBy);
				iBuf->Des().Append(_L(" "));
				iBuf->Des().Append(aPost->LastPostAuthor());
				iBuf->Des().Append(_L(",\t"));
				GetTimeString(aPost->LastPostDate(), time);
				iBuf->Des().Append(time);
			}
		} else {
			// second line
			iBuf->Des().Append(*iBy);
			iBuf->Des().Append(_L(" "));
			iBuf->Des().Append(aPost->iSender.iName());
			iBuf->Des().Append(_L(",\t"));
			TBuf<5> time; GetTimeString(aPost->iTimeStamp(), time);
			iBuf->Des().Append(time);
			// third line
			iBuf->Des().Append(_L("\t\t"));
		}
	}
	RDebug::Print(iBuf->Des());
	return iBuf->Des();
}

void CContextMediaArrayImpl::PostEvent(CCMPost* aParent, CCMPost* aChild, TEvent aEvent)
{
	CALLSTACKITEM_N(_CL("CContextMediaArrayImpl"), _CL("PostEvent"));
	
	if (aParent != iParentPost) return;

	if (aEvent==EChildAdded) {
		iPostIdArray->AppendL(aChild->iPostId());
		iPostArray->AppendL(0);
		iObserver.PostEvent(aParent, aChild, aEvent);
	}

	if (aEvent==EPlaceholderFilled) {
		TInt i;
		for (i=0; i<iPostIdArray->Count();i++) {
			if (iPostIdArray->At(i) == aChild->iPostId()) {
				TRAPD(ignore, iStorage.Release(iPostArray->At(i), 0));
				iPostArray->At(i) = 0;
				iObserver.PostEvent(aParent, aChild, aEvent);
				return;
			}
		}
	}

	if (aEvent==EPostHidden) {
		ReadFromStorage();
		iObserver.PostEvent(aParent, aChild, aEvent);
	}

	if (aEvent==EPostVisible) {
		ReadFromStorage();
		iObserver.PostEvent(aParent, aChild, aEvent);
	}

	if (aEvent==EPostUpdated) {
		iObserver.PostEvent(aParent, aChild, aEvent);
	} 

	if ((aEvent==EThumbnailLoaded) || (aEvent==EUnreadChanged)) {
		iObserver.PostEvent(aParent, aChild, aEvent);
	}

	if (aEvent==ELastPostChanged) {
		iObserver.PostEvent(aParent, aChild, aEvent);
	}
	
	//do nothing for:
	//	EMediaLoaded,
	//	EErrorUpdated,
}

//------------------------
void CContextMediaBox::CreateItemDrawerL(void)
{
	CALLSTACKITEM_N(_CL("CContextMediaBox"), _CL("CreateItemDrawerL"));

	CFormattedCellListBoxData* itemd=CFormattedCellListBoxData::NewL();
	CleanupStack::PushL(itemd);

	TMargins no_marg, image_marg, text_marg, text_marg_2;
	
	no_marg.iBottom=no_marg.iTop=no_marg.iLeft=no_marg.iRight=0;

	image_marg.iTop = 5;
	image_marg.iLeft = 2;
	image_marg.iRight = 2;
	image_marg.iBottom=4;

	text_marg.iBottom=2;
	text_marg.iTop=0;
	text_marg.iLeft=2;
	text_marg.iRight=3;

	text_marg_2.iBottom=2;
	text_marg_2.iTop=0;
	text_marg_2.iLeft=0;
	text_marg_2.iRight=2;
	
	TFontSpec fontSpec = LatinPlain12()->FontSpecInTwips();
	fontSpec.iFontStyle.SetPosture(EPostureItalic );
	CEikonEnv::Static()->ScreenDevice()->GetNearestFontInTwips(iLatinPlainItalic12, fontSpec);

	//Thumbnail (image size = 48*36)
	itemd->SetSubCellMarginsL(0, image_marg);		
	itemd->SetSubCellSizeL(0, TSize(52, 48) );
	itemd->SetSubCellPositionL(0, TPoint(0, 0) );
	itemd->SetSubCellFontL(0, iEikonEnv->DenseFont() );
	itemd->SetSubCellAlignmentL(0, CGraphicsContext::ECenter);
	itemd->SetGraphicsSubCellL(0,ETrue);

	//Title of thread
	itemd->SetSubCellMarginsL(1, text_marg);		
	itemd->SetSubCellSizeL(1, TSize(104, 15) );
	itemd->SetSubCellPositionL(1, TPoint(52, 0) );
	itemd->SetSubCellBaselinePosL(1, 13); 
	itemd->SetSubCellFontL(1, LatinPlain12());
	itemd->SetSubCellAlignmentL(1, CGraphicsContext::ELeft);

	//nb unread
	itemd->SetSubCellMarginsL(2, text_marg);		
	itemd->SetSubCellSizeL(2, TSize(20, 15) );
	itemd->SetSubCellPositionL(2, TPoint(156, 0) );
	itemd->SetSubCellBaselinePosL(2, 13); // ?
	itemd->SetSubCellFontL(2, LatinBold12() );
	itemd->SetSubCellAlignmentL(2, CGraphicsContext::ERight);

	//text line 1 box 1
	itemd->SetSubCellMarginsL(3, text_marg_2);		
	itemd->SetSubCellSizeL(3, TSize(94, 16) );
	itemd->SetSubCellPositionL(3, TPoint(50, 18) );
	itemd->SetSubCellBaselinePosL(3, 29); // ?
	itemd->SetSubCellFontL(3, iLatinPlainItalic12);
	itemd->SetSubCellAlignmentL(3, CGraphicsContext::ERight);

	//text line 1 box 2
	itemd->SetSubCellMarginsL(4, text_marg_2);		
	itemd->SetSubCellSizeL(4, TSize(32, 16) );
	itemd->SetSubCellPositionL(4, TPoint(144, 18) );
	itemd->SetSubCellBaselinePosL(4, 29); // ?
	itemd->SetSubCellFontL(4, iLatinPlainItalic12);
	itemd->SetSubCellAlignmentL(4, CGraphicsContext::ERight);

	//text line 2 box 1
	itemd->SetSubCellMarginsL(5, text_marg_2);		
	itemd->SetSubCellSizeL(5, TSize(94, 14) );
	itemd->SetSubCellPositionL(5, TPoint(50, 33) );
	itemd->SetSubCellBaselinePosL(5, 43); // ?
	itemd->SetSubCellFontL(5, iLatinPlainItalic12);
	itemd->SetSubCellAlignmentL(5, CGraphicsContext::ERight);

	//text line 2 box 2
	itemd->SetSubCellMarginsL(6, text_marg_2);		
	itemd->SetSubCellSizeL(6, TSize(32, 14) );
	itemd->SetSubCellPositionL(6, TPoint(144, 33) );
	itemd->SetSubCellBaselinePosL(6, 43); // ?
	itemd->SetSubCellFontL(6, iLatinPlainItalic12);
	itemd->SetSubCellAlignmentL(6, CGraphicsContext::ERight);
	
	iItemDrawer=new (ELeave) CContextMediaBoxDrawer(Model(), LatinPlain12(), itemd, iPostArray);

	CleanupStack::Pop();	
}

CContextMediaBox::~CContextMediaBox()
{
	CALLSTACKITEM_N(_CL("CContextMediaBox"), _CL("~CContextMediaBox"));

	CEikonEnv::Static()->ScreenDevice()->ReleaseFont(iLatinPlainItalic12);
}


CContextMediaBoxDrawer::CContextMediaBoxDrawer(MTextListBoxModel *aTextListBoxModel, 
					 const CFont *aFont, 
					 CFormattedCellListBoxData *aFormattedCellData,
					 CContextMediaArray * aPostArray) :
		CFormattedCellListBoxItemDrawer(aTextListBoxModel, aFont, aFormattedCellData)
		{
			itemd=aFormattedCellData;
			iTextListBoxModel=aTextListBoxModel;
			iPostArray = aPostArray;
		}


void CContextMediaBoxDrawer::DrawItemText (TInt aItemIndex, const TRect &aItemTextRect, 
		TBool aItemIsCurrent, TBool aViewIsEmphasized, TBool aItemIsSelected) const 
{	
	CALLSTACKITEM_N(_CL("CContextMediaBoxDrawer"), _CL("DrawItemText"));

	TInt unread = 0;
	TInt64 parentId=CPostStorage::RootId();

	const CCMPost* post=iPostArray->GetPostAt(aItemIndex);

	if (post) {
		unread = post->iUnreadCounter();
		parentId = post->iParentId();
	}

	if ((parentId != CPostStorage::RootId()) || (unread==0)) {
		itemd->SetSubCellSizeL(1, TSize(124, 20) );
		itemd->SetSubCellPositionL(2, TPoint(176, 0) );
	} else {
		itemd->SetSubCellSizeL(1, TSize(104, 20) );
		itemd->SetSubCellPositionL(2, TPoint(156, 0) );
	}

	TListItemProperties prop;
	if (!post){
		itemd->SetSubCellFontL(1, LatinBold12() );
		prop.SetUnderlined(EFalse);
	} else {
		prop.SetUnderlined(ETrue);
		if (unread) {
			itemd->SetSubCellFontL(1, LatinBold12() );
		} else {
			itemd->SetSubCellFontL(1, LatinPlain12() );
		}
	}
	((CFormattedCellListBoxItemDrawer*)this)->SetPropertiesL(aItemIndex, prop);

	CFormattedCellListBoxItemDrawer::DrawItemText(aItemIndex, aItemTextRect,
			aItemIsCurrent, aViewIsEmphasized, aItemIsSelected);
}

