#include <eiklabel.h>
#include <aknconsts.h>
#include <akncontext.h>
#include "popup_notifier.h"
#include <symbian_auto_ptr.h>

CPopupNotifier::CPopupNotifier() 
{
}


void CPopupNotifier::ConstructL(const TRect& aRect)
{
    iMyWindowGroup=RWindowGroup(iCoeEnv->WsSession());
    
    User::LeaveIfError(iMyWindowGroup.Construct((TUint32)&iMyWindowGroup));
    
    iMyWindowGroup.SetOrdinalPosition(0, ECoeWinPriorityAlwaysAtFront);
    iMyWindowGroup.EnableReceiptOfFocus(EFalse);
    
    CreateWindowL(&iMyWindowGroup);
    SetRect(aRect);
    EnableDragEvents();
    MakeVisible(EFalse);
    ActivateL();
}

CPopupNotifier::~CPopupNotifier()
{	
	iMyWindowGroup.Close();
}

void CPopupNotifier::Draw(const TRect& aRect) const
{
	CWindowGc& gc = SystemGc();
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.SetBrushColor(KRgbRed);
	gc.DrawEllipse(aRect);
}