#ifndef CONTEXT_BB_INCOMING_H_INCLUDED
#define CONTEXT_BB_INCOMING_H_INCLUDED 1

#include <bbdata.h>
#include <concretedata.h>
#include <context_uids.h>
#include <app_context.h>

const TTypeName KAckType = { { CONTEXT_UID_CONTEXTNETWORK }, 1, 1, 0 };
const TTypeName KStreamType = { { CONTEXT_UID_CONTEXTNETWORK }, 2, 1, 0 };

class MIncomingObserver {
public:
	// if aErrors==ETrue, the errors have been communicated
	// via StreamError() previously. The receiver must decide themselves
	// whether the data is complete enough to use
	virtual void IncomingData(const MBBData* aData, TBool aErrors) = 0;
	virtual void StreamOpened() = 0;
	virtual void StreamClosed() = 0;
	virtual void StreamError(TInt aError, const TDesC& aDescr) = 0; // Leave to interrupt processing
};

_LIT(KAck, "ack");

class TBBAck : public TBBCompoundData {
public:
	TBBUint		iId;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;
	IMPORT_C TBBAck();
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C bool operator==(const TBBAck& aRhs) const;
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
};

class CStreamXml : public CBase, public MNestedXmlHandler
{
public:
	IMPORT_C static CStreamXml* NewL(MBBData* aData, MIncomingObserver& aObserver,
		bool aCheckType=true);
	virtual CXmlParser* Parser() = 0;
};

class MBBStream : public TBBCompoundData
{
protected:
/* you must implement:
	const MBBData* Part(TUint aPartNo) const;
        virtual const TTypeName& Type() const;
	and ResetPart
*/
	virtual void ResetPart(TUint aPart) = 0;

	IMPORT_C MBBStream(const TDesC& aName, MIncomingObserver& aObserver);
	IMPORT_C void ConstructL();

	IMPORT_C virtual void ReadPart(TUint aPart, TBool aErrors);
	IMPORT_C virtual void Reset();

	MIncomingObserver& iObserver;

	CStreamXml* iStreamXml;
private:
	IMPORT_C virtual const TDesC& StringSep(TUint aBeforePart) const;
	IMPORT_C virtual MBBData* CloneL(const TDesC& Name) const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

public:
	IMPORT_C void ParseL(const TDesC8& aXml);
	IMPORT_C virtual ~MBBStream();
};

class CStream : public CBase, public MBBStream {
public:
	static CStream* NewL(MIncomingObserver& aObserver, MApp_context& aContext);
protected:
	CStream(MIncomingObserver& aObserver);
};

#endif