#ifndef CONTEXT_BB_PROTOCOL_H_INCLUDED
#define CONTEXT_BB_PROTOCOL_H_INCLUDED 1

#include "enginenotifier.h"
#include <app_context.h>
#include <checkedactive.h>
#include <csd_event.h>

class MBBNotifier {
public:
	virtual void Acked(TUint id) = 0;
	virtual void IncomingTuple(const CBBTuple* aTuple) = 0;
	virtual void Error(TInt aError, TInt aOrigError, const TDesC& aDescr) = 0;
	virtual void ReadyToWrite(TBool aReady) = 0;
	virtual void Disconnected() = 0;
};

class CBBProtocol : public CCheckedActive {
public:
	IMPORT_C static CBBProtocol* NewL(MApp_context& aContext);
	CBBProtocol();

	virtual void AddObserverL(MBBNotifier* aObserver) = 0;

	virtual void ConnectL(TUint aAccessPoint, const TDesC& aServerName, TUint port, const TDesC& aAuthorName) = 0;

	virtual void Disconnect(TBool closeConnection) = 0;

	virtual void WriteL(const TDesC16& aData) = 0;

	virtual void SendXMLStreamHeaderL() = 0;

	virtual void SendDisconnectionL() = 0;
	virtual void SendIdentificationL() = 0;
	virtual void SendXmlPacketL(const TDesC& aPacket) = 0; // data has to live until acked

	virtual void Read() = 0;
	virtual TBool Connected() const = 0;

};

#endif
