#if !defined(CN_BT_OBEX_H_INCLUDED)

#define CN_BT_OBEX_H_INCLUDED

#include <app_context.h>
#include <checkedactive.h>
#include <bttypes.h>
#include <obex.h>

class MObexNotifier {
public:
	enum TState {
		EInitializing,
		EGettingService,
		EConnecting,
		ESending
	};

	virtual void	Error(TInt aError, TState  aAtState) = 0;
	virtual void	Cancelled(TState aStateBeforeCancel) = 0;
	virtual void	Success() = 0;
};

class CBtObex : public CCheckedActive {
public:
	IMPORT_C static CBtObex* NewL(MApp_context& aContext, MObexNotifier& aNotifier);
	virtual void SendMessage(const TBTDevAddr& aAddr, 
		CObexBaseObject* aObject,
		TInt	aConnectCount) = 0; // doesn't take ownership

	virtual void CancelSend() = 0; // calls Cancelled() when done
	IMPORT_C CBtObex();
};


#endif
