#ifndef CONTEXT_HTTP_H_INCLUDED
#define CONTEXT_HTTP_H_INCLUDED 1

#include "socketsengine.h"
#include <app_context.h>
#include <raii_f32file.h>
#include <list.h>

class CHttpHeader : public CBase
{
public:
	IMPORT_C static CHttpHeader * NewL();
	IMPORT_C static CHttpHeader * NewLC();
	IMPORT_C void Copy(const CHttpHeader &aHeader);
	IMPORT_C void Reset();

private:
	CHttpHeader () {}
	void ConstructL();

public:
	TReal iHttpVersion;
	TInt iHttpReplyCode;
	TBuf<KMaxServerNameLength> iServername;
        TTime iServerTime;
	TBuf<256> iFilename;
	TTime iLastMod;
	TBuf<128> iContentType;
	TInt iSize;
	TInt iChunkStart;
	TInt iChunkEnd;

	//TBuf<50> iETag;
	//TBuf<200> iServerDescription;
	//TBuf<200> iMime;
};

class CPostPart : public CBase
{
public:
	IMPORT_C CPostPart(const TDesC& aName, const TDesC& aMimeType);
	IMPORT_C void SetFileName(const TDesC& aFileName); // sets the filename used in the post
	virtual TInt	Size() = 0;
	TBuf<128>	iName;
	TBuf<128>	iMimeType;
	TBuf<128>	iFileName;
	IMPORT_C virtual const TDesC&  FileName();

	virtual void ReadChunkL(TDes8& aIntoBuffer) = 0; // zero length at EOF
};

class CFilePart : public CPostPart
{
public:
	IMPORT_C static CFilePart* NewL(RFs& aFs, const TDesC& aFileName, 
		const TDesC& aName, const TDesC& aMimeType);
	IMPORT_C ~CFilePart();
private:
	CFilePart(const TDesC& aName, const TDesC& aMimeType);
	void ConstructL(RFs& aFs, const TDesC& aFileName);
	RFile	iFile; TBool iFileIsOpen;
	TInt	iSize;
	TInt	iRead;
	virtual TInt	Size();
	virtual void ReadChunkL(TDes8& aIntoBuffer);
};

class CBufferPart : public CPostPart
{
public:
	IMPORT_C static CBufferPart* NewL(HBufC8* aBuffer, TBool aTakeOwnership,
		const TDesC& aName, const TDesC& aMimeType);
	IMPORT_C static CBufferPart* NewL(const TDesC8& aBuffer,
		const TDesC& aName, const TDesC& aMimeType);
	IMPORT_C ~CBufferPart();
private:
	CBufferPart(const TDesC& aName, const TDesC& aMimeType);
	void ConstructL(const TDesC8& aBuffer);
	void ConstructL(HBufC8* aBuffer, TBool aTakeOwnership);
	virtual TInt	Size();
	virtual void ReadChunkL(TDes8& aIntoBuffer);
	HBufC8*	iBuffer;
	TInt	iPos;
	TInt	iRead;
	TBool	iOwnsBuffer;
};

class MHttpObserver 
{
public:
	enum THttpStatus
        {
		EHttpConnected=0,
		EHttpDisconnected=1,
		EHttpError=2
	};

	virtual void NotifyHttpStatus(THttpStatus st, TInt aError)=0;
	virtual void NotifyNewHeader(const CHttpHeader &aHeader)=0;
	virtual void NotifyNewBody(const TDesC8 &chunk)=0;
};

class CHttp : public CBase, public MContextBase, /*public MTimeOut,*/ public MEngineObserver
{
public:
	IMPORT_C static CHttp * NewL(MHttpObserver& aObserver, MApp_context& Context);
	IMPORT_C static CHttp * NewLC(MHttpObserver& aObserver, MApp_context& Context);
	IMPORT_C ~CHttp();

public:
	IMPORT_C void GetL(const TUint& iAP, const TDesC &url, const TTime &modified_since = TTime(0), 
		const TUint &chunkStart=0, const TUint &chunkEnd=0);
	
	IMPORT_C void PostL(const TUint& iAP, const TDesC &url, CPtrList<CPostPart>* aBodyParts);
		// guarantees to take ownership of parts even if Leaves

	//void HeadL(const TDesC &url, const TTime &modified_since);
	IMPORT_C void ReleaseParts();
	IMPORT_C void Disconnect();

	IMPORT_C static void AppendUrlEncoded(TDes& into, const TDesC& str);
private:
	virtual void NotifyEngineStatus(TInt st, TInt aError);
	virtual void NotifyNewData(const TDesC8& aBuffer);
	virtual void NotifyCanWrite();

	void ConstructL();
	CHttp(MHttpObserver& aObserver, MApp_context& Context);
	void ConnectL();
	TBool ParseUrl(const TDesC &url);

private:
	MHttpObserver& iObserver;
	enum THttpError {EServerError, EParseError };
	void ReportError(TInt aErrorType, TInt errorCode);

private:
	TBool Parse(const TDesC8 &aBuffer);
	TBool ParseLine(const TDesC8 &aLine);
	void ResetParser();

private:
	TTime InternetTimeIntoTime(const TDesC8 &aInternetTimeString);
	void TimeIntoInternetTime(TDes8 &buf, const TTime &time);

	void MakeBoundary();
	void DeleteParts();
private:
	static const TInt KDefaultPortNumber;

        CSocketsEngine * iEngine;

	enum THttpState { ENotConnected, EConnecting, EConnected, EDisconnectForNew };
	THttpState iHttpStatus;
	void ChangeStatus(THttpState aNewStatus, TInt aError);

	enum TParsingState { EUndefined, EHeader, EBody, EError };
	TParsingState iParsingState;
	
	TInt                          iPort;
	TBuf16<KMaxServerNameLength>  iServerName;
	TUint32			      iAccessPoint;

	enum TMethod {
		EGet,
		EPost
	};
	TMethod			iMethod;
	TBuf8<256>		      iUrl;
        HBufC8	* iCommand;

	enum TPartState {
		ESendingHeader,
		ESendingBody,
	};
	TPartState		iPartState;

	CPtrList<CPostPart>*	iParts;
	CPtrList<CPostPart>::Node* iCurrentPartNode;

	HBufC8		*iParseBuffer;
	TBuf8<128>	iBoundary;

	CHttpHeader * iHeader;
	RFile		iDebugFile; TBool iDebugFileIsOpen;
};

#endif
