#ifndef CONTEXT_DOWNLOADER_H_INCLUDED
#define CONTEXT_DOWNLOADER_H_INCLUDED 1

#include <app_context.h>
#include <db.h>

class MDownloadObserver {
public:
	virtual void DownloadFinished(TInt64 aRequestId, const TDesC& aFileName,
		const TDesC& aContentType) = 0;
	virtual void DownloadError(TInt64 aRequestId, TInt aCode, const TDesC& aDescr) = 0;
};

class CDownloader : public CCheckedActive {
public:
	IMPORT_C static CDownloader* NewL(MApp_context& aContext, RDbDatabase& Db, 
		const TDesC& aDirectory, MDownloadObserver& aObserver);
	virtual void DownloadL(TInt64 aRequestId, const TDesC& aUrl,
		TBool aForce=EFalse) = 0;
	virtual void RemoveRequest(TInt64 aRequestId) = 0;
	virtual void SetFixedIap(TInt aIap) = 0;
protected:
	CDownloader();
};

#endif
