/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/
#ifndef __ENGINENOTIFIER_H__
#define __ENGINENOTIFIER_H__

#include <e32std.h>

class MEngineNotifier  
    {
public:

    enum TErrorType
        {
        EDisconnected,
        ETimeOutOnWrite,
        EGeneralReadError,
        EGeneralWriteError,
	ETimeOutOnRead,
	ENetworkConnectError,
	EUnknownError,
	ESocketEngineTimeOut,
	EDNSLookupFailed,
	ESocketConnectError

	,EStreamError
	,EXmlParseError
	,EIdentificationError
	,EIdentificationFailed
	,EIdentificationTimeOut
	,EServerUnreachable

	};

	virtual void ReportError(TErrorType aErrorType, TInt aErrorCode) = 0;
	virtual void ResponseReceived(const TDesC8& aBuffer) = 0;
	virtual void CanWrite() = 0;
};

#endif 
