/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/
#ifndef __JABBER_H__
#define __JABBER_H__

#include "socketsengine.h"
#include <app_context.h>
#include <expat.h>
#include <list.h>

#ifdef __S60V2__
#include <zlib.h>
#else
// From Symbian FAQ
#include <ezlib.h>
#endif

class MJabberObserver 
{
public:
	enum TJabberStatus
        {
		EJabberConnected=0,
		EJabberDisconnected=1,
		EIdentificationFailed=10
	};

	virtual void NotifyJabberStatus(TInt st)=0;
	virtual void NotifyNewPresenceInfo(const TDesC & from, const TDesC & info, const TTime& stamp)= 0;
	virtual void NotifyNewMessage(const TDesC & from, const TDesC& subject, const TDesC & message) = 0;
};

class CJabber : public CBase, public MContextBase, public MTimeOut, public MEngineObserver
{
public:
	IMPORT_C static CJabber * NewL(MJabberObserver& aObserver, MApp_context& Context);
	IMPORT_C static CJabber * NewLC(MJabberObserver& aObserver, MApp_context& Context);
	IMPORT_C ~CJabber();

	IMPORT_C void ConnectL(const TDesC16 &u, const TDesC16 &p, const TDesC16 &s, const TUint32 iAccessPoint);
	IMPORT_C void Disconnect(TBool close_connection);
	IMPORT_C TBool IsConnected();
	IMPORT_C void SendPresenceInfoL(const TDesC &presenceInfo);

private:
	void expired(CBase* Source);

	virtual void NotifyEngineStatus(TInt st, TInt aError);
	virtual void NotifyNewData(const TDesC8& aBuffer);
	virtual void NotifyCanWrite();

	void ConstructL();
	CJabber(MJabberObserver& aObserver,MApp_context& Context);
	enum TJabberError {EIdentificationFailed, EStreamError, EXmlParseError};
	void ReportError(TInt aErrorType);
	void DoDisconnect(TBool close_connection);

	//(expat handlers)
	static void startElement (void *userData, const XML_Char *el, const XML_Char **atts);
	static void endElement (void *userData, const XML_Char *name);
	static void charData (void *userData, const XML_Char *s, int len);

	void startElement (const XML_Char *el, const XML_Char **atts);
	void endElement (const XML_Char *name);
	void charData (const XML_Char *s, int len);

private:
	void SendXMLStreamHeaderL();
	void IdentifyL();
	void SendDisconnectionL();
	void DoSendPresenceInfoL();
private:
	MJabberObserver& iObserver;

private:
	static const TInt KDefaultPortNumber;
	static const TInt KCloseSessionTimeOut;

        CSocketsEngine * iEngine;

	enum TJabberState { ENotConnected, EConnecting, EInitiating, EIdentifying, EConnected, EDisconnecting, EWaitingForRetry };
	
	TJabberState iJabberStatus;
	void ChangeStatus(TJabberState aNewStatus, TInt aError);
	
	TInt                          iPort;
	TBuf16<KMaxServerNameLength>  iServerName;
	TUint32			      iAccessPoint;
	TBuf16<200> iUsername;  // size defined by Jabber specs
public:
	TBuf16<200> iFullNick;  // user@server/Resource
private:
	TBuf16<200> iPassword;  // size defined by Jabber specs
	TBuf16<100> iResource; 
	TBuf16<100> iJabberSessionId;

	CXmlBuf16*		iXmlBuf;
	XML_Parser		iParser;
	CList<TInt> * iStack;
	enum TParseState
	{	EStackUndefined,
		EStackIgnoreElement,
		EStackPresenceInfo,
		EStackMessage,
		EStackSubject,
		EStackBody,
		EStackOfflinePresenceInfo,
		EStackSession,
		EStackConnected,
		EStackIdentFailure,
		EStackStatus,
		EStackStreamError,
		EStackError
	};

	TBuf<20> iErrorCode;
	HBufC16 * iErrorValue;

	HBufC16 * iUserPresenceInfo;
	HBufC16 * iFrom;
	HBufC16 * iPresenceInfo;
	HBufC16 * iMessage;
	HBufC16 * iSubject;

	CTimeOut*		iSendTimer;
	CTimeOut*		iCloseSessionTimer;
	
	TTimeIntervalSeconds iPresenceInterval;
	TInt iFreshnessInterval;
	TTime iLastUpdateSent;	

	TBool restart;
	TBool iCloseConnection;

	friend class CContextServer;
};


#endif
