/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/
#ifndef __SOCKETSENGINE_H__
#define __SOCKETSENGINE_H__

#include "ver.h"
#include <in_sock.h>
#include <timeout.h>
#include "EngineNotifier.h"
#include "Sockets.hrh"
#include <xmlbuf.h>

#include <connectioninit.h>
#include <app_context.h>

#include "socketsreader.h"
#include "socketswriter.h"

#ifdef __S60V2__
#include <zlib.h>
#else
// From Symbian FAQ
#include <ezlib.h>
#endif


class MEngineObserver
{
public:
	enum TEngineStatus {
		ESocketConnected=0,
		ESocketDisconnected=1,
		ESocketUnreachable=2
	};

	virtual void NotifyEngineStatus(TInt st, TInt aError) = 0;
	virtual void NotifyNewData(const TDesC8& aBuffer) = 0;
	virtual void NotifyCanWrite() = 0;
};

class CSocketsEngine : public CCheckedActive, public MTimeOut, public MEngineNotifier, public MSocketObserver, public MContextBase
    {
public: 
	static CSocketsEngine* NewL(MEngineObserver& aObserver, MApp_context& Context,
		TBool aDoCompress=EFalse);
	static CSocketsEngine* NewLC(MEngineObserver& aObserver, MApp_context& Context,
		TBool aDoCompress=EFalse);
	~CSocketsEngine();
	
	void ConnectL(const TDesC& host, const TInt& port, TUint32 iap);
	void Disconnect(TBool closeConnection); // 

	void WriteL(const TDesC16& aData);
	void WriteL(const TDesC8& aData);
	void Read();
	void StopRead();

public: 
	void ReportError(MEngineNotifier::TErrorType aErrorType, TInt aErrorCode);
	virtual void ResponseReceived(const TDesC8& aBuffer);
	void CanWrite();

public: 
	void success(CBase* source);
	void error(CBase* source, TInt code, const TDesC& reason);
	void info(CBase* source, const TDesC& msg);

private: 
	MEngineObserver& iObserver;
	IMPORT_C void expired(CBase* Source);
	void DisconnectSocket();

protected: 
	void DoCancel();
	void CheckedRunL();
	TInt CheckedRunError(TInt aError);

private: 
	CSocketsEngine(MEngineObserver& aObserver, MApp_context& Context,
		TBool aDoCompress);
	void ConstructL();
	void OpenConnectionAndConnectL();
	void ConnectL();
	void ConnectL(TUint32 aAddr);
	enum TSocketsEngineState 
		{ ENotConnected, EConnecting, EConnected, ELookingUp, EDisconnecting, EWaitingForRetry };
	void ChangeStatus(TSocketsEngineState aNewStatus);

private:
	static const TInt KTimeOut;
	static const TInt KDefaultPortNumber;
	static const TInt KTimeBeforeRetry;
	static const TInt KMaxConnectionRetry;

	TSocketsEngineState         iEngineStatus;

	RSocket                     iSocket;
	CSocketsReader*             iSocketsReader;
	CSocketsWriter*             iSocketsWriter;
	RHostResolver               iResolver;

	TNameEntry                  iNameEntry;
	TNameRecord                 iNameRecord;

	CTimeOut*		    iTimer;

	TInetAddr                   iAddress;
	TInt                        iPort;
	TBuf16<KMaxServerNameLength>  iServerName;

	CConnectionOpener *	iConnectionOpener;
	TUint32		iAccessPoint;
	RSocketServ		iSocketServ;

	TBool iSocketOpen;
	TBool iResolverOpen;

	TInt iConnectionRetry;
	TInt iTimeBeforeRetry;
    
#ifdef __S60V2__
	RConnection		iConnection;
#endif

	TBool		iDoCompress;
	void InitZStreamsL();

	z_stream	in_z_stream, out_z_stream;
	TBool		in_z_open, out_z_open;

	HBufC8		*in_z_buf, *out_z_buf;

	void AppendToOutZBufL(const TDesC8& aData);
	Bytef		out_z_buf_tmp[1024];
	HBufC8		*iTransferBuffer;
	class CCnvCharacterSetConverter *iCC;

};
#endif