/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

#ifndef __SOCKETSREADER_H__
#define __SOCKETSREADER_H__

#include <in_sock.h>
#include <timeout.h>
#include <app_context.h>
#include "enginenotifier.h"

class CSocketsReader : public CCheckedActive , public MTimeOut, public MContextBase
    {
public:
	static CSocketsReader* NewL(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context);
	static CSocketsReader* NewLC(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context);
	~CSocketsReader();
	void Start();
	void SetIssueRead(TBool issue);

protected: 
	void DoCancel();
	TInt CheckedRunError(TInt aError);
	void CheckedRunL();	

private:
	CSocketsReader(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context);
	void ConstructL();
	void IssueRead();

private: 
	void expired(CBase*);

private: 
	enum {KReadBufferSize = 2048};
	RSocket&                iSocket;
	CTimeOut * iReadTimer;
	MEngineNotifier&        iEngineNotifier;
	TBuf8<KReadBufferSize>  iBuffer;
	TSockXfrLength          iDummyLength;
	TBool issueRead;
	static const TInt KReadTimeOut;
    };

#endif // __SOCKETSREADER_H__

