/* 
Copyright (C) 2004  Mika Raento - Renaud Petit

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   
    
     email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/
#ifndef __SOCKETSWRITER_H__
#define __SOCKETSWRITER_H__

#include <in_sock.h>
#include <TimeOut.h>
#include <app_context.h>

#include "enginenotifier.h"

class CSocketsWriter : public CCheckedActive, public MTimeOut, public MContextBase
{
public:
	static CSocketsWriter* NewL(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context);
	static CSocketsWriter* NewLC(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context);
	~CSocketsWriter();
	void IssueWriteL(const TDesC8& aData);
	
public: 
	void expired(CBase*); 
	
protected: 
	void DoCancel();
	void CheckedRunL();	
	TInt CheckedRunError(TInt aError);
private:
	CSocketsWriter(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context);
	void ConstructL();
	void SendNextPacket();
		
private: 
	enum {KWriteBufferSize = 400};
	static const TInt KTimeOut;
	enum TWriteState { ESending, EWaiting };

	RSocket&                iSocket;
	MEngineNotifier&        iEngineNotifier;
	HBufC8*			iTransferBuffer;
	HBufC8*			iWriteBuffer;
	CTimeOut*          iTimer;
	TInt                    iTimeOut;
	TWriteState             iWriteStatus;
    };
    
#endif 
    
