#ifndef CL_TRANSFER2_H_INCLUDED
#define CL_TRANSFER2_H_INCLUDED 1

#include <d32dbms.h>
#include <app_context.h>
#include "status_notif.h"
#include <connectioninit.h>
#include <bbdata.h>

typedef struct {
	TInt err;
	TFileName fn;
} TFileOpStatus;


IMPORT_C void ToPacket(const TDesC& filen, TDes& packet);
IMPORT_C void ToDel(const TDesC& filen, TDes& del);

IMPORT_C void GetMimeTypeL(const TDesC& FileName,TDes &aBuf);

class CHttpTransfer2 : public CCheckedActive {
public:
	IMPORT_C static CHttpTransfer2* NewL(MApp_context& Context,
		RDbDatabase& Db, MSocketObserver* aStatusNotif);

	virtual TFileName AddFileToQueueL(const TDesC& aFileName, TInt UrlSetting,
		TInt ScriptSetting, TBool DeleteAfter, const TDesC& aMeta,
		MBBData* aPacket, TInt aWaitTime=0, TBool aDontMove=EFalse) = 0;
	virtual TInt DeleteFile(const TDesC& aFileName) = 0;
	virtual TFileOpStatus DoNotTransfer(const TDesC& aFileName) = 0;
	virtual TFileOpStatus MoveToOld(const TDesC& aFileName) = 0;
	virtual TBool FileIsQueued(const TDesC& aFileName) = 0;
	virtual void Trigger(TBool Force=EFalse) = 0;

	CHttpTransfer2();
	IMPORT_C virtual ~CHttpTransfer2();
};

#endif