#ifndef CL_TRANSFERDIR2_H_INCLUDED
#define CL_TRANSFERDIR2_H_INCLUDED 1

#include "transfer2.h"
#include <bbdata.h>

class MUploadCallBack {
public:
	virtual TFileOpStatus Back(bool Upload, bool DeleteFromPhone, MBBData* Packet) = 0;
};

class MUploadPrompt {
public:
	virtual void Prompt(const TDesC& FileName, MUploadCallBack* CallBack) = 0;
};

class CTransferDir : public CCheckedActive
{
public:
	IMPORT_C static CTransferDir* NewL(MApp_context& Context, MSocketObserver& aObserver,
		const TDesC& aDbName);
	virtual TInt ProcessDir(const TDesC& aDirName, TInt UrlSetting,
		TInt ScriptSetting, const TDesC& aMeta, MUploadPrompt* Prompt, TTime TimeLimit,
		TBool aMoveToMMC, TBool aDontMoveToSubDirs) = 0;
	virtual CHttpTransfer2* Transferer() = 0;
	IMPORT_C ~CTransferDir();
protected:
	CTransferDir();
};
#endif
