#include "bb_incoming.h"
#include "xml.h"
#include "symbian_auto_ptr.h"
#include "util.h"
#include "csd_event.h"

EXPORT_C const TTypeName& TBBAck::Type() const
{
	CALLSTACKITEM_N(_CL("TBBAck"), _CL("Type"));

	return KAckType;
}

EXPORT_C TBool TBBAck::Equals(const MBBData* aRhs) const
{
	CALLSTACKITEM_N(_CL("TBBAck"), _CL("Equals"));

	const TBBAck* rhs=bb_cast<TBBAck>(aRhs);
	return (rhs && *this==*rhs);
}

EXPORT_C const TTypeName& TBBAck::StaticType()
{
	CALLSTACKITEM_N(_CL("TBBAck"), _CL("StaticType"));

	return KAckType;
}

EXPORT_C const MBBData* TBBAck::Part(TUint aPartNo) const
{
	CALLSTACKITEM_N(_CL("TBBAck"), _CL("Part"));

	if (aPartNo==0) return &iId;
	return 0;
}

EXPORT_C TBBAck::TBBAck() : TBBCompoundData(KAck), iId(KId)
{
	CALLSTACKITEM_N(_CL("TBBAck"), _CL("TBBAck"));

}

EXPORT_C MBBData* TBBAck::CloneL(const TDesC&) const
{
	TBBAck* ret=new (ELeave) TBBAck;
	ret->iId()=iId();
	return ret;
}

const TDesC& TBBAck::StringSep(TUint) const
{
	CALLSTACKITEM_N(_CL("TBBAck"), _CL("StringSep"));

	return KNullDesC;
}

EXPORT_C bool TBBAck::operator==(const TBBAck& aRhs) const
{
	CALLSTACKITEM_N(_CL("TBBAck"), _CL("operator"));

	return (iId==aRhs.iId);
}

class CStreamXmlImpl : public CStreamXml {
public:
	MBBData* iData; MNestedXmlHandler* iCurrentHandler;
	MIncomingObserver& iObserver;
	CXmlParser* iParser;
	bool iCheckType;
	HBufC* iBuf;
	
	CStreamXmlImpl(MBBData* aData, MIncomingObserver& aObserver,
		bool aCheckType=true) : iData(aData), iObserver(aObserver), 
		iCheckType(aCheckType) { }
	void ConstructL() { iParser=CXmlParser::NewL(*this); }
	~CStreamXmlImpl() { delete iBuf; delete iCurrentHandler; delete iParser; }

	virtual void StartElement(const XML_Char *name,
				const XML_Char **atts) {

		TPtrC namep( (TUint16*)name);
		if (namep.Compare(iData->Name())==0) {
			iObserver.StreamOpened();
		} else {
			User::Leave(KUnexpectedElement);
		}
		if (!iCurrentHandler) iCurrentHandler=iData->FromXmlL(this, iParser, iBuf, iCheckType);
		else User::Leave(KErrGeneral);

		if (iCurrentHandler) iCurrentHandler->StartElement(name, atts);
		iParser->SetHandler(iCurrentHandler);
	}
		
	virtual CXmlParser* Parser() {
		return iParser;
	}

	virtual void EndElement(const XML_Char * /*name*/) {
		iObserver.StreamClosed();
	}

	virtual void CharacterData(const XML_Char * /*s*/,
				    int /*len*/) {
		User::Leave(KErrGeneral);
	}

	virtual void Error(XML_Error Code, const XML_LChar * String, long ByteIndex) {
		SetError(KErrInvalidXml);
		User::Leave(KErrInvalidXml);
	}
	virtual void SetError(TInt aError) { 
		iObserver.StreamError(aError, _L(""));
	}

};


EXPORT_C CStreamXml* CStreamXml::NewL(MBBData* aData, MIncomingObserver& aObserver,
	bool aCheckType)
{
	auto_ptr<CStreamXmlImpl> ret(new (ELeave) CStreamXmlImpl(aData, aObserver, aCheckType));
	ret->ConstructL();
	return ret.release();
}

EXPORT_C MBBData* MBBStream::CloneL(const TDesC&) const { return 0; }

class CStreamImpl : public CStream, public MContextBase
{
private:
	CStreamImpl(MIncomingObserver& aObserver, MApp_context& aContext);
	void ConstructL();
	~CStreamImpl();

	const MBBData* Part(TUint aPartNo) const;
        virtual const TTypeName& Type() const;
	virtual void ResetPart(TUint aPart);

	TBBAck	iAck;
	CBBTuple* iTuple;

	friend class CStream;
	friend class auto_ptr<CStreamImpl>;
};

CStream* CStream::NewL(MIncomingObserver& aObserver, MApp_context& aContext)
{
	CALLSTACKITEM_N(_CL("CStream"), _CL("NewL"));

	auto_ptr<CStreamImpl> ret(new (ELeave) CStreamImpl(aObserver, aContext));
	ret->ConstructL();
	return ret.release();
}

_LIT(KStream, "stream");

EXPORT_C MBBStream::MBBStream(const TDesC& aName, MIncomingObserver& aObserver) : TBBCompoundData(aName),
	iObserver(aObserver) { }

CStreamImpl::CStreamImpl(MIncomingObserver& aObserver, MApp_context& aContext) : CStream(aObserver),
	MContextBase(aContext) { }

CStream::CStream(MIncomingObserver& aObserver) : MBBStream(KStream, aObserver) { }

void CStreamImpl::ConstructL()
{
	CALLSTACKITEM_N(_CL("CStreamImpl"), _CL("ConstructL"));
	MBBStream::ConstructL();
	iTuple=new (ELeave) CBBTuple(BBDataFactory());
}

CStreamImpl::~CStreamImpl()
{
	delete iTuple;
}

void CStreamImpl::ResetPart(TUint aPartNo)
{
	if (aPartNo==0) {
		iAck.iId()=0;
	} else if (aPartNo==1) {
		delete iTuple->iData(); iTuple->iData()=0;
		iTuple->iTupleId()=0;
		iTuple->iTupleMeta.iModuleUid()=0;
		iTuple->iTupleMeta.iModuleId()=0;
		iTuple->iTupleMeta.iSubName().Zero();
		iTuple->iData()=0;
	}
}
	
EXPORT_C void MBBStream::ConstructL()
{
	iStreamXml=CStreamXml::NewL(this, iObserver, false);
}

EXPORT_C void MBBStream::Reset()
{
	delete iStreamXml; iStreamXml=0;
	iStreamXml=CStreamXml::NewL(this, iObserver, false);
}

EXPORT_C MBBStream::~MBBStream()
{
	CALLSTACKITEM_N(_CL("MBBStream"), _CL("~MBBStream"));

	delete iStreamXml;
}

EXPORT_C void MBBStream::ParseL(const TDesC8& aXml)
{
	CALLSTACKITEM_N(_CL("MBBStream"), _CL("ParseL"));

	Log(aXml);
	iStreamXml->Parser()->Parse( (char*)(aXml.Ptr()), aXml.Size(), 0);
}

const TTypeName& CStreamImpl::Type() const
{
	CALLSTACKITEM_N(_CL("CStreamImpl"), _CL("Type"));

	return KStreamType;
}

EXPORT_C TBool MBBStream::Equals(const MBBData* ) const { return EFalse; }

const MBBData* CStreamImpl::Part(TUint aPartNo) const
{
	CALLSTACKITEM_N(_CL("CStreamImpl"), _CL("Part"));

	if (aPartNo==0) return &iAck;
	if (aPartNo==1) return iTuple;
	return 0;
}

EXPORT_C const TDesC& MBBStream::StringSep(TUint ) const
{
	CALLSTACKITEM_N(_CL("MBBStream"), _CL("StringSep"));

	return KNullDesC;
}

EXPORT_C void MBBStream::ReadPart(TUint aPart, TBool aErrors)
{
	CALLSTACKITEM_N(_CL("MBBStream"), _CL("ReadPart"));

	iObserver.IncomingData(Part(aPart), aErrors);
	ResetPart(aPart);
}