#include "bluejack.h"

#include "symbian_auto_ptr.h"

/*
 * Concepts:
 * !Bluejacking!
 * !Setting Bluetooth name!
 */

// reverse engineered from BTENG.LIB:
enum TBTDiscoverabilityMode { EBTDiscoverabilityMode0, EBTDiscoverabilityMode1 };
enum TBTSearchMode { EBTSearchMode0, EBTSearchMode1 };
class CBTMCMSettings : public CBase {
public:
        IMPORT_C static int  GetAllSettings(int &, enum TBTDiscoverabilityMode &, enum TBTSearchMode &, class TDes16 &, int &);
        IMPORT_C static int  GetDiscoverabilityModeL(enum TBTDiscoverabilityMode &);
        IMPORT_C static int  GetLocalBDAddress(class TBTDevAddr &);
        IMPORT_C static int  GetLocalBTName(class TDes16 &);
        IMPORT_C static int  GetPowerStateL(int &);
        IMPORT_C static int  GetSearchModeL(enum TBTSearchMode &);
        IMPORT_C static int  IsLocalNameModified(int &);
        IMPORT_C static class CBTMCMSettings *  NewL(class MBTMCMSettingsCB *);
        IMPORT_C static class CBTMCMSettings *  NewLC(class MBTMCMSettingsCB *);
        IMPORT_C int  SetDefaultValuesL(void);
        IMPORT_C int  SetDiscoverabilityModeL(enum TBTDiscoverabilityMode, int);
        IMPORT_C int  SetLocalBTName(class TDesC16 const &);
        IMPORT_C int  SetPowerStateL(int, int);
        IMPORT_C int  SetSearchModeL(enum TBTSearchMode);
};

class CBlueJackImpl : public CBlueJack, public MContextBase {
private:
	CBlueJackImpl(MApp_context& aContext, MObexNotifier& aNotifier);
	void ConstructL();
	~CBlueJackImpl();

	virtual void SendMessageL(const TBTDevAddr& aToAddress,
		const TDesC& aWithDeviceName,
		const TDesC& aWithMessageName,
		const TDesC8& aMessage,
		TInt	aConnectCount);
	virtual void CancelSend(); 

	CObexBufObject* iObject;
	CBufFlat*	iBuffer;
	CBtObex*	iObex;
	MObexNotifier&	iNotifier;
	CBTMCMSettings* iSettings;

	friend class CBlueJack;
	friend class auto_ptr<CBlueJackImpl>;
};

EXPORT_C CBlueJack* CBlueJack::NewL(MApp_context& aContext, MObexNotifier& aNotifier)
{
	CALLSTACKITEM_N(_CL("CBlueJack"), _CL("NewL"));


	auto_ptr<CBlueJackImpl> ret(new (ELeave) CBlueJackImpl(aContext, aNotifier));
	ret->ConstructL();
	return ret.release();
}

CBlueJackImpl::CBlueJackImpl(MApp_context& aContext, MObexNotifier& aNotifier) :
	MContextBase(aContext), iNotifier(aNotifier)
	{ }

void CBlueJackImpl::ConstructL()
{
	CALLSTACKITEM_N(_CL("CBlueJackImpl"), _CL("ConstructL"));


	iBuffer=CBufFlat::NewL(1024);
	iObject=CObexBufObject::NewL(iBuffer);

	iObex=CBtObex::NewL(AppContext(), iNotifier);
#ifndef __WINS__
	iSettings=CBTMCMSettings::NewL(0);
#endif
}

CBlueJackImpl::~CBlueJackImpl()
{
	CALLSTACKITEM_N(_CL("CBlueJackImpl"), _CL("~CBlueJackImpl"));


	delete iObex;
	delete iObject;
	delete iBuffer;
	if (iSettings)
		iSettings->SetLocalBTName(_L("name"));
	delete iSettings;
}

void CBlueJackImpl::SendMessageL(const TBTDevAddr& aToAddress,
	const TDesC& aWithDeviceName,
	const TDesC& aWithMessageName,
	const TDesC8& aMessage,
	TInt	aConnectCount)
{
	CALLSTACKITEM_N(_CL("CBlueJackImpl"), _CL("SendMessageL"));

#ifndef __WINS__
	iSettings->SetLocalBTName(aWithDeviceName);
#endif

	iBuffer->Reset();
	iBuffer->InsertL(0, aMessage);
	iObject->SetTypeL(_L8("text/plain"));
	iObject->SetNameL(aWithMessageName);
	iObject->SetDescriptionL(_L("description of message"));

	iObex->SendMessage(aToAddress, iObject, aConnectCount);
}

void CBlueJackImpl::CancelSend()
{
	CALLSTACKITEM_N(_CL("CBlueJackImpl"), _CL("CancelSend"));

	iObex->CancelSend();
}
