/* 
 Copyright (C) 2004  Mika Raento - Renaud Petit

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
  
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   
    
 email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

#include "Sockets.pan"
#include "SocketsReader.h"
#include "EngineNotifier.h"
#include <flogger.h>
#include "app_context.h"

void Log(const TDesC& msg);
void Log(const TDesC8& msg);
void Log(const TDesC& msg, TInt);

const TInt CSocketsReader::KReadTimeOut = 600;

CSocketsReader* CSocketsReader::NewL(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context)
{
	CALLSTACKITEM2_N(_CL("CSocketsReader"), _CL("NewL"), &Context);
	
	CSocketsReader* self = CSocketsReader::NewLC(aEngineNotifier, aSocket, Context);
	CleanupStack::Pop(self);
	return self;
}


CSocketsReader* CSocketsReader::NewLC(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context)
{
	CALLSTACKITEM2_N(_CL("CSocketsReader"), _CL("NewLC"), &Context);
	
	CSocketsReader* self = new (ELeave) CSocketsReader(aEngineNotifier, aSocket, Context);
	CleanupStack::PushL(self);
	self->ConstructL();
	return self;
}


CSocketsReader::CSocketsReader(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context)
: CCheckedActive(EPriorityLow, _L("SocketReader")), MContextBase(Context),
iSocket(aSocket),
iEngineNotifier(aEngineNotifier),
issueRead(ETrue)
{
}

CSocketsReader::~CSocketsReader()
{
	CALLSTACKITEM_N(_CL("CSocketsReader"), _CL("~CSocketsReader"));
	Cancel();
	delete iReadTimer;
}


void CSocketsReader::SetIssueRead(TBool issue)
{
	CALLSTACKITEM_N(_CL("CSocketsReader"), _CL("SetIssueRead"));
	
	issueRead = issue;
}


void CSocketsReader::ConstructL()
{
	CALLSTACKITEM_N(_CL("CSocketsReader"), _CL("ConstructL"));
	
	iReadTimer = CTimeOut::NewL(*this);
	CActiveScheduler::Add(this);
}

void CSocketsReader::DoCancel()
{
	CALLSTACKITEM_N(_CL("CSocketsReader"), _CL("DoCancel"));

	iReadTimer->Reset();
	iSocket.CancelRead();
}

TInt CSocketsReader::CheckedRunError(TInt aError)
{
	CALLSTACKITEM_N(_CL("CSocketsReader"), _CL("CheckedRunError"));

	Log(_L("Error in CSocketsReader::RunL "), aError);
	iEngineNotifier.ReportError(MEngineNotifier::EUnknownError, aError);
	return KErrNone;
}

void CSocketsReader::expired(CBase*)
{
	CALLSTACKITEM_N(_CL("CSocketsReader"), _CL("expired"));
	
	Cancel();
	iEngineNotifier.ReportError(MEngineNotifier::ETimeOutOnRead, 0);
}

void CSocketsReader::CheckedRunL()
{
	CALLSTACKITEM_N(_CL("CSocketsReader"), _CL("CheckedRunL"));

	iReadTimer->Reset();
	switch (iStatus.Int())
        {
        case KErrNone:
		//Log(iBuffer);
		iEngineNotifier.ResponseReceived(iBuffer);
		// FIXME: if the object gets deleted at this point,
		// the following statement will try to access deleted memory
		if (issueRead) { 
			IssueRead();
		}
		break;
		
        case KErrDisconnected:
		iEngineNotifier.ReportError(MEngineNotifier::EDisconnected,iStatus.Int());
		break;
		
        default:
		iEngineNotifier.ReportError(MEngineNotifier::EGeneralReadError,iStatus.Int());
		break;
        }	
}

void CSocketsReader::IssueRead()
{
	CALLSTACKITEM_N(_CL("CSocketsReader"), _CL("IssueRead"));

	__ASSERT_ALWAYS(!IsActive(), User::Panic(KPanicSocketsEngineRead, ESocketsBadState));
	iReadTimer->Wait(KReadTimeOut);
	iSocket.RecvOneOrMore(iBuffer, 0, iStatus, iDummyLength);
	SetActive();
}

void CSocketsReader::Start()
{
	CALLSTACKITEM_N(_CL("CSocketsReader"), _CL("Start"));

	if (!IsActive()) IssueRead();
}