/* 
Copyright (C) 2004  Mika Raento - Renaud Petit

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   
    
     email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

#include "SocketsWriter.h"
#include "Sockets.pan"
#include "EngineNotifier.h"
#include <charconv.h>
#include <flogger.h>
#include "app_context.h"

#include "util.h"

const TInt CSocketsWriter::KTimeOut = 30; // 30 seconds time-out

CSocketsWriter* CSocketsWriter::NewL(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context)
{
	CALLSTACKITEM2_N(_CL("CSocketsWriter"), _CL("NewL"), &Context);

	CSocketsWriter* self = CSocketsWriter::NewLC(aEngineNotifier, aSocket, Context);
	CleanupStack::Pop(self);
	return self;
}


CSocketsWriter* CSocketsWriter::NewLC(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context)
{
	CALLSTACKITEM2_N(_CL("CSocketsWriter"), _CL("NewLC"), &Context);

	CSocketsWriter* self = new (ELeave) CSocketsWriter(aEngineNotifier, aSocket, Context);
	CleanupStack::PushL(self);
	self->ConstructL();
	return self;
}


CSocketsWriter::CSocketsWriter(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context)
: CCheckedActive(EPriorityLow, _L("SocketWriter")), MContextBase(Context),
iSocket(aSocket),
iEngineNotifier(aEngineNotifier)
{
	CALLSTACKITEM_N(_CL("CSocketsWriter"), _CL("CSocketsWriter"));
}


CSocketsWriter::~CSocketsWriter()
{
	CALLSTACKITEM_N(_CL("CSocketsWriter"), _CL("~CSocketsWriter"));

	Cancel();
	delete iTimer;
	delete iTransferBuffer;
	delete iWriteBuffer;
}

void CSocketsWriter::DoCancel()
{	
	CALLSTACKITEM_N(_CL("CSocketsWriter"), _CL("DoCancel"));

	iSocket.CancelWrite();
	iTimer->Reset();
	iWriteStatus = EWaiting;
}

void CSocketsWriter::ConstructL()
{
	CALLSTACKITEM_N(_CL("CSocketsWriter"), _CL("ConstructL"));

	CActiveScheduler::Add(this);
	
	iTimeOut = KTimeOut; 
	iTimer = CTimeOut::NewL(*this);
	iWriteStatus = EWaiting;
	
	iTransferBuffer=HBufC8::NewL(1024);
	iWriteBuffer=HBufC8::NewL(1024);
}

void CSocketsWriter::expired(CBase*)
{
	CALLSTACKITEM_N(_CL("CSocketsWriter"), _CL("expired"));

	Cancel();
	iWriteStatus = EWaiting;
	iEngineNotifier.ReportError(MEngineNotifier::ETimeOutOnWrite, KErrTimedOut);
}

TInt CSocketsWriter::CheckedRunError(TInt aError)
{
	CALLSTACKITEM_N(_CL("CSocketsWriter"), _CL("CheckedRunError"));
	
	Log(_L("Error in CSocketsReader::RunL %d"), aError);
	return aError;
}

void CSocketsWriter::CheckedRunL()
{
	CALLSTACKITEM_N(_CL("CSocketsWriter"), _CL("CheckedRunL"));

	iTimer->Cancel();

	if (iStatus == KErrNone)
	{
		switch(iWriteStatus)
		{
		case ESending:
			SendNextPacket();
			iEngineNotifier.CanWrite();
			break;
		default:
			User::Panic(KPanicSocketsEngineWrite, ESocketsBadStatus);
			break;
		};
	}
	else 
	{
		iWriteStatus = EWaiting;
		iEngineNotifier.ReportError(MEngineNotifier::EGeneralWriteError, iStatus.Int());
	}
}

void CSocketsWriter::IssueWriteL(const TDesC8& aData)
{
	CALLSTACKITEM_N(_CL("CSocketsWriter"), _CL("IssueWriteL"));

	if ((iWriteStatus != EWaiting) && (iWriteStatus != ESending))
        {
		User::Leave(KErrNotReady);
        }
	while ((aData.Size() + iTransferBuffer->Des().Length()) > iTransferBuffer->Des().MaxLength())
        {
		iTransferBuffer=iTransferBuffer->ReAllocL(iTransferBuffer->Des().MaxLength()*2);
        }
	iTransferBuffer->Des().Append(aData);
	if (!IsActive()) SendNextPacket();
}

void CSocketsWriter::SendNextPacket()
{
	CALLSTACKITEM_N(_CL("CSocketsWriter"), _CL("SendNextPacket"));
	
	if (iTransferBuffer->Length() > 0)
        {
		if (!iWriteBuffer ||  iWriteBuffer->Des().MaxLength() < iTransferBuffer->Length() ) {
			delete iWriteBuffer; iWriteBuffer=iTransferBuffer->Des().AllocL();
		} else {
			*iWriteBuffer=*iTransferBuffer;
		}
		iTransferBuffer->Des().Zero();
		iSocket.Write(*iWriteBuffer, iStatus); // Initiate actual write
		iTimer->Wait(iTimeOut);
		SetActive();
		iWriteStatus = ESending;
        }
	else
        {
		iWriteStatus = EWaiting;
        }
}
