#include <flogger.h>
#include <E32SVR.H>

void ConvertTo16(const TDesC8& msg, TDes16& msg16)
{
	TBuf<2> hex;
	for (int i=0; (i<msg.Length() && msg16.Length()<msg16.MaxLength()-4); i++) {
		unsigned char c=msg[i];
		if ( (c>32 && c<128) || c==10 || c==13 || c==' ' || c=='\t') {
			msg16.Append(c);
		} else {
			hex.Zero();
			if (c<16) hex.Append(_L("0"));
			hex.AppendNum(c, EHex);
			msg16.Append(_L("\\x"));
			msg16.Append(hex);
		}

	}
}

EXPORT_C void LogL(const TDesC& msg)
{

	RFileLogger iLog;
	User::LeaveIfError(iLog.Connect());
	CleanupClosePushL(iLog);
	iLog.CreateLog(_L("Context"),_L("Network"),EFileLoggingModeAppend);
	TInt i=0;
#ifdef __WINS__
	while (i<msg.Length()) {
#else
	{
#endif
		RDebug::Print(msg.Mid(i));
		iLog.Write(msg.Mid(i));
		i+=128;
	}
	
	iLog.CloseLog();
	CleanupStack::PopAndDestroy();
}

EXPORT_C void Log(const TDesC& msg)
{

	TRAPD(err, LogL(msg));
	// ignore error, not much else we can do
	// and not critical
}
EXPORT_C void LogL(const TDesC8& msg)
{

	RFileLogger iLog;
	User::LeaveIfError(iLog.Connect());
	CleanupClosePushL(iLog);
	iLog.CreateLog(_L("Context"),_L("Network"),EFileLoggingModeAppend);
	TInt i=0;
#ifdef __WINS__
	while (i<msg.Length()) {
#else
	{
#endif
		TInt len=msg.Length()-i;
		if (len > 100) len=100;

		#ifdef __WINS__
			TBuf<128> msg16;
			ConvertTo16(msg.Mid(i, len), msg16);
			RDebug::Print(msg16);
		#endif

		iLog.Write(msg.Mid(i, len));
		i+=100;
	}
	
	// Close the log file and the connection to the server.
	iLog.CloseLog();
	CleanupStack::PopAndDestroy();
}

EXPORT_C void Log(const TDesC8& msg)
{

	TRAPD(err, LogL(msg));
	// ignore error, not much else we can do
	// and not critical
}

EXPORT_C void LogL(const TDesC& msg, TInt i)
{

	RFileLogger iLog;
	User::LeaveIfError(iLog.Connect());
	CleanupClosePushL(iLog);
	iLog.CreateLog(_L("Context"),_L("Network"),EFileLoggingModeAppend);
	iLog.Write(msg);
	RDebug::Print(msg.Left(128));
	TBuf<10> iBuf;
	iBuf.Format(_L("%d"),i);
	iLog.Write(iBuf);
	RDebug::Print(iBuf);
	// Close the log file and the connection to the server.
	iLog.CloseLog();
	CleanupStack::PopAndDestroy();
}

EXPORT_C void Log(const TDesC& msg, TInt i)
{

	TRAPD(err, LogL(msg, i));
	// ignore error, not much else we can do
	// and not critical
}

