#include "foreground.h"
#include "symbian_auto_ptr.h"
#include <e32std.h>
#include <apgwgnam.h>


class CForegroundImpl : public CForeground {
	virtual void AddObserver(MForegroundObserver* aObserver);

	CForegroundImpl(RWsSession& aWsSession);

	void ConstructL();
	void RunL();
	TInt RunError(TInt aError);
	void DoCancel();
	void StartL();
	void Release();
	void Listen();

	RPointerArray<MForegroundObserver> iObservers;
	RWsSession&	iWsSession;
	RWindowGroup	iWg; bool iWg_is_open;
	
	friend class CForeground;
public:
	virtual ~CForegroundImpl();
};

CForeground::CForeground(CActive::TPriority aPriority) : CActive(aPriority)
{
}

CForeground::~CForeground()
{
	
}

CForeground* CForeground::NewL(RWsSession& aWsSession)
{
	auto_ptr<CForegroundImpl> ret(new (ELeave) CForegroundImpl(aWsSession));
	ret->ConstructL();
	return ret.release();
}

void CForegroundImpl::AddObserver(MForegroundObserver* aObserver)
{
	User::LeaveIfError(iObservers.Append(aObserver));
}

CForegroundImpl::CForegroundImpl(RWsSession& aWsSession) : CForeground(EPriorityHigh), iWsSession(aWsSession), iWg(aWsSession)
{
}

CForegroundImpl::~CForegroundImpl()
{
	Release();

	iObservers.Close();
}

void CForegroundImpl::ConstructL()
{
	CActiveScheduler::Add(this);

	StartL();
}

void CForegroundImpl::RunL()
{
	if (iStatus == KErrNone) {
		TWsEvent e;
		iWsSession.GetEvent(e);
	}

	TInt wgid=iWsSession.GetFocusWindowGroup();
	
	CApaWindowGroupName* gn;
	gn=CApaWindowGroupName::NewLC(iWsSession, wgid);

	int i;
	for (i=0; i<iObservers.Count(); i++) {
		iObservers[i]->ForegroundChanged(gn->AppUid());
	}
	CleanupStack::PopAndDestroy(); // gn

	Listen();
}

TInt CForegroundImpl::RunError(TInt /*aError*/)
{
	TRAPD(err, StartL());
	return err;
}

void CForegroundImpl::DoCancel()
{
	iWsSession.EventReadyCancel();
}

void CForegroundImpl::StartL()
{
	Release();
	User::LeaveIfError(iWg.Construct((TUint32)&iWg, EFalse));
	iWg.SetOrdinalPosition(-1);
	iWg.EnableReceiptOfFocus(EFalse);

	CApaWindowGroupName* wn=CApaWindowGroupName::NewLC(iWsSession);
	wn->SetHidden(ETrue);
	wn->SetWindowGroupName(iWg);
	CleanupStack::PopAndDestroy();

	User::LeaveIfError(iWg.EnableFocusChangeEvents());

	Listen();
}

void CForegroundImpl::Listen()
{
	iStatus=KRequestPending;
	iWsSession.EventReady(&iStatus);
	SetActive();
}

void CForegroundImpl::Release()
{
	Cancel();
	if (iWg_is_open) {
		iWg.Close();
		iWg_is_open=false;
	}
}