/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//CContextNotifyClientSession.h


#ifndef __CONTEXTNOTIFYCLIENTSESSION_H__
#define __CONTEXTNOTIFYCLIENTSESSION_H__

#include <e32base.h>
#include <fbs.h>
#include <coecntrl.h>
#include <akntitle.h>

class RContextNotifyClientSession : public RSessionBase
{
public:
	IMPORT_C RContextNotifyClientSession();
	IMPORT_C TInt Connect();
	IMPORT_C void Close();
	IMPORT_C TVersion Version() const;
	IMPORT_C void TerminateContextNotify(TRequestStatus& aStatus);
	IMPORT_C void AddIcon(CFbsBitmap* aIcon, CFbsBitmap* aMask, TInt& aId, TRequestStatus& aStatus);
	IMPORT_C void RemoveIcon(TInt aId, TRequestStatus& aStatus);
	IMPORT_C void ChangeIcon(CFbsBitmap* aIcon, CFbsBitmap* aMask, TInt aId, TRequestStatus& aStatus);
	
	IMPORT_C void Cancel() const;
private: 
	TPckg<TInt> *iIdPckg;
};

class CLocalNotifyWindow : public CAknTitlePane {
public:
	IMPORT_C static void CreateAndActivateL();
	IMPORT_C static void Destroy();
	IMPORT_C static CLocalNotifyWindow* Global(); 
	virtual TInt AddIconL(CFbsBitmap* aIcon, CFbsBitmap* aMask) = 0;
	virtual void RemoveIcon(TInt aId) = 0;
	virtual void ChangeIconL(CFbsBitmap* aIcon, CFbsBitmap* aMask, TInt Id) = 0;
	virtual void DrawOnGc(CWindowGc& gc, TPoint& aFromPos) = 0;
	virtual void AddNotifiedControl(CCoeControl* aControl) = 0;
	virtual void RemoveNotifiedControl(CCoeControl* aControl) = 0;
protected:
	~CLocalNotifyWindow();
};

class CNotifyWindowControl : public CCoeControl {
public:
	IMPORT_C void Draw(const TRect& aRect) const;
	IMPORT_C void ConstructL(CCoeControl *aTopLevel);
	IMPORT_C ~CNotifyWindowControl();
private:
	CLocalNotifyWindow* iLocal;
	CCoeControl *iTopLevel;
};

#endif // __TIMESERVERSESSION_H__