#ifndef CL_BASESTACK_H_INCLUDED
#define CL_BASESTACK_H_INCLUDED 1

#include <e32base.h>
#include <app_context.h>

class CBaseStack : public CBase {
public:
	struct TBaseItem {
		TInt		iBaseId;
		TBuf<50>	iBaseName;
		TTime		iEntered;
		TTime		iLeft;

		IMPORT_C TBaseItem();
		IMPORT_C TBaseItem(const TBaseItem& anItem);
		IMPORT_C TBaseItem(TInt aBaseId, const TDesC& aBaseName, const TTime& anEntered);
		IMPORT_C TBaseItem& operator=(const TBaseItem& aItem);
		IMPORT_C void Reset();
	};
	IMPORT_C static CBaseStack* NewL(MApp_context& Context);
	IMPORT_C ~CBaseStack();

	virtual void DeleteLastL() = 0;
	virtual void DeleteFirstL() = 0;
	virtual TBool LastL(TBaseItem& anItem) = 0;
	virtual TBool PrevL(TBaseItem& anItem) = 0;
	virtual TBool FirstL(TBaseItem& anItem) = 0;
	virtual TBool NextL(TBaseItem& anItem) = 0;
	virtual void PushBackL(const TBaseItem& anItem) = 0;
	virtual TInt CountL() = 0;
	virtual void SetLastLeft(const TTime& aLeft) = 0;
	virtual void SetLastName(const TDesC& aName) = 0;
};
	
#endif
