/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CL_CELLMAP_H_INCLUDED
#define CL_CELLMAP_H_INCLUDED 1

#include <app_context.h>
#include <db.h>
#include <file_output_base.h>

#include <csd_cell.h>
#include "operatormap.h"

class CCellMap : public MDBStore, public MContextBase, public CBase {
public:
	IMPORT_C static CCellMap* NewL(MApp_context& Context, RDbDatabase& Db, COperatorMap* aOpMap);
	IMPORT_C TInt GetId(const TBBCellId& Cell);
	IMPORT_C void SetId(const TBBCellId& Cell, TInt Id);
	IMPORT_C ~CCellMap();
	IMPORT_C static void Parse(const TDesC& Cell, TUint& cell, TUint& area, TDes& nw);
	IMPORT_C void PrintMapping(Mfile_output_base& To);
private:
	CCellMap(MApp_context& Context, RDbDatabase& Db, COperatorMap *aOpMap);
	void ConstructL();

	COperatorMap* iOpMap;
	TInt	iNextId;
	TBool	iConstructed;
};

#endif
