#ifndef CONTEXT_CSD_BASE_H_INCLUDED
#define CONTEXT_CSD_BASE_H_INCLUDED 1

#include <e32std.h>
#include <bbdata.h>
#include <context_uids.h>
#include <concretedata.h>
#include <csd_cell.h>

_LIT(KBase, "base");
const TTupleName KBaseTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 24 };
const TTypeName KBaseInfoType = { { CONTEXT_UID_SENSORDATAFACTORY }, 24, 1, 0 };
const TTypeName KBaseVisitType = { { CONTEXT_UID_SENSORDATAFACTORY }, 30, 1, 0 };

const TTypeName KLocationType = { {  CONTEXT_UID_SENSORDATAFACTORY }, 34, 1, 0 };
const TTupleName KLocationTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 34 };

class TBBLocation : public TBBCompoundData {
public:
	TBBCellId		iCellId;
	TBBUint			iLocationId;
	TBBBool			iIsBase;
	TBBBool			iLocationChanged;
	TBBTime			iEnteredLocation;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TBBLocation& operator=(const TBBLocation& aRhs);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	IMPORT_C TBBLocation();
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C bool operator==(const TBBLocation& aRhs) const;

};

class TBBBaseVisit : public TBBCompoundData {
public:
	TBBUint			iBaseId;
	TBBShortString		iBaseName;
	TBBTime			iEntered;
	TBBTime			iLeft;

	IMPORT_C TBool	IsSet() const;

	IMPORT_C virtual void	IntoXmlL(MBBExternalizer* aBuf, TBool aIncludeType=ETrue) const;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TBBBaseVisit& operator=(const TBBBaseVisit& aBaseInfo);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	IMPORT_C TBBBaseVisit(const TDesC& aName);
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C bool operator==(const TBBBaseVisit& aRhs) const;

};

class TBBBaseInfo : public TBBCompoundData {
public:
	TBBBaseVisit		iPreviousStay;
	TBBBaseVisit		iPreviousVisit;
	TBBBaseVisit		iCurrent;

	IMPORT_C void IntoStringL(TDes& aString) const;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TBBBaseInfo& operator=(const TBBBaseInfo& aBaseInfo);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	IMPORT_C TBBBaseInfo();
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C bool operator==(const TBBBaseInfo& aRhs) const;
};

#endif
