#ifndef CONTEXT_CSD_BATTERY_H_INCLUDED
#define CONTEXT_CSD_BATTERY_H_INCLUDED 1

#include <bbdata.h>
#include <concretedata.h>
#include <context_uids.h>

const TTypeName KBatteryType = { { CONTEXT_UID_SENSORDATAFACTORY }, 26, 1, 0 };
const TTupleName KBatteryTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 26 };

class TBBBattery : public TBBCompoundData {
public:
	TBBInt		iState;
	TBBUint		iLevel;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TBBBattery(const TDesC& aName);

	IMPORT_C bool operator==(const TBBBattery& aRhs) const;
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C TBBBattery& operator=(const TBBBattery& aBattery);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
};

#endif