#ifndef CONTEXT_CSD_CALENDAR_H_INCLUDED
#define CONTEXT_CSD_CALENDAR_H_INCLUDED 1

#include <bbdata.h>
#include <concretedata.h>
#include <context_uids.h>

const TTypeName KCalendarEventType = { { CONTEXT_UID_SENSORDATAFACTORY }, 38, 1, 0 };
const TTypeName KCalendarType = { { CONTEXT_UID_SENSORDATAFACTORY }, 39, 1, 0 };
const TTupleName KCalendarTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 39 };

_LIT(KCalendar, "calendar");

class TBBCalendarEvent : public TBBCompoundData {
public:
	TBBShortString		iDescription;
	TBBTime			iStartTime;
	TBBTime			iEndTime;

	IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TBBCalendarEvent(const TDesC& aName);

	IMPORT_C bool operator==(const TBBCalendarEvent& aRhs) const;
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C TBBCalendarEvent& operator=(const TBBCalendarEvent& aRhs);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
};

class TBBCalendar : public TBBCompoundData {
public:
	TBBCalendarEvent	iPreviousOrCurrent;
	TBBCalendarEvent	iCurrentOrNext;

	IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

	IMPORT_C TBBCalendar();

	IMPORT_C bool operator==(const TBBCalendar& aRhs) const;
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C TBBCalendar& operator=(const TBBCalendar& aRhs);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
};

#endif
