#ifndef CONTEXT_CSD_CELL_H_INCLUDED
#define CONTEXT_CSD_CELL_H_INCLUDED 1

#include <bbdata.h>
#include <concretedata.h>
#include <context_uids.h>

_LIT(KCell, "location.value");
_LIT(KCellName, "cell_name");


const TTypeName KCellIdType = { { CONTEXT_UID_SENSORDATAFACTORY }, 1, 1, 0 };
const TTypeName KShortNetworkNameType = { { CONTEXT_UID_SENSORDATAFACTORY }, 2, 1, 0 };

const TTupleName KCellIdTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 1 };
const TTupleName KCellNameTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 23 };

// KShortNetworkNameSize=20 in etelbgsm.h, but we don't
// want to include that here
class TBBShortNetworkName : public TBBFixedLengthStringBase {
public:
	TBuf<20> iValue;
        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C static const TTypeName& StaticType();

	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	TDes& operator()() { return iValue; }
	const TDesC& operator()() const { return iValue; }

	virtual TDes& Value() { return iValue; }
	virtual const TDesC& Value() const  { return iValue; }
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	TBBShortNetworkName(const TDesC& aName) : TBBFixedLengthStringBase(aName) { }
	TBBShortNetworkName& operator=(const TDesC& aValue) { iValue=aValue.Left(20); return *this; }
	bool operator==(const TBBShortNetworkName& aRhs) const { return !(iValue.Compare(aRhs.iValue)); }
};

class TBBCellId : public TBBCompoundData  {
public:
	TBBUint iMCC;
	TBBUint iMNC;
	TBBShortNetworkName iShortName;
	TBBUint iLocationAreaCode;
	TBBUint iCellId;
	TBBUint	iMappedId;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;

        IMPORT_C virtual void FromStringL(const TDesC& aString);
	IMPORT_C void IntoStringL(TDes& aString) const;
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	IMPORT_C TBBCellId(const TDesC& aName);
	IMPORT_C TBBCellId(const TBBCellId& aCell);
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C bool operator==(const TBBCellId& aRhs) const;
	IMPORT_C TBBCellId& operator=(const TBBCellId& aRhs);
};

#endif
