#ifndef CONTEXT_CSD_CURRENT_APP_H_INCLUDED
#define CONTEXT_CSD_CURRENT_APP_H_INCLUDED 1

#include <bbdata.h>
#include <concretedata.h>
#include <context_uids.h>

const TTypeName KCurrentAppType = { { CONTEXT_UID_SENSORDATAFACTORY }, 11, 1, 0 };
const TTupleName KCurrentAppTuple = { { CONTEXT_UID_CONTEXTSENSORS }, 11 };

_LIT(KCurrentApp, "active_app");
_LIT(KUid, "uid");
_LIT(KCaption, "caption");

class TBBCurrentApp : public TBBCompoundData {
public:
	TBBUid			iUid;
	TBBShortString		iCaption;

        IMPORT_C virtual const TTypeName& Type() const;
	IMPORT_C virtual TBool Equals(const MBBData* aRhs) const;

	IMPORT_C static const TTypeName& StaticType();
	IMPORT_C const MBBData* Part(TUint aPartNo) const;
	IMPORT_C TBBCurrentApp& operator=(const TBBCurrentApp& aCurrentApp);
	IMPORT_C MBBData* CloneL(const TDesC& Name) const;
public:
	IMPORT_C TBBCurrentApp();
	virtual const TDesC& StringSep(TUint aBeforePart) const;

	IMPORT_C bool operator==(const TBBCurrentApp& aRhs) const;
};

#endif
